/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.UUID;
import org.joda.time.DateTime;
import org.killbill.billing.account.api.AccountEmail;
import org.killbill.billing.jaxrs.json.JsonBase;

public class AccountEmailJson
extends JsonBase {
    private final String accountId;
    private final String email;

    @JsonCreator
    public AccountEmailJson(@JsonProperty(value="accountId") String accountId, @JsonProperty(value="email") String email) {
        this.accountId = accountId;
        this.email = email;
    }

    public String getAccountId() {
        return this.accountId;
    }

    public String getEmail() {
        return this.email;
    }

    public AccountEmail toAccountEmail(final UUID accountEmailId) {
        return new AccountEmail(){

            public UUID getAccountId() {
                return UUID.fromString(AccountEmailJson.this.accountId);
            }

            public String getEmail() {
                return AccountEmailJson.this.email;
            }

            public UUID getId() {
                return accountEmailId;
            }

            public DateTime getCreatedDate() {
                return null;
            }

            public DateTime getUpdatedDate() {
                return null;
            }
        };
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("AccountEmailJson");
        sb.append("{accountId='").append(this.accountId).append('\'');
        sb.append(", email='").append(this.email).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AccountEmailJson that = (AccountEmailJson)o;
        if (this.accountId != null ? !this.accountId.equals(that.accountId) : that.accountId != null) {
            return false;
        }
        return !(this.email != null ? !this.email.equals(that.email) : that.email != null);
    }

    public int hashCode() {
        int result = this.accountId != null ? this.accountId.hashCode() : 0;
        result = 31 * result + (this.email != null ? this.email.hashCode() : 0);
        return result;
    }
}

