/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.jaxrs.json;

import com.google.common.collect.ImmutableList;
import java.math.BigDecimal;
import java.util.List;
import java.util.UUID;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.jaxrs.JaxrsTestSuiteNoDB;
import org.killbill.billing.jaxrs.json.BundleJson;
import org.killbill.billing.jaxrs.json.BundleTimelineJson;
import org.killbill.billing.jaxrs.json.InvoiceJson;
import org.killbill.billing.jaxrs.json.PaymentJson;
import org.killbill.billing.jaxrs.json.SubscriptionJson;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestBundleTimelineJson
extends JaxrsTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testJson() throws Exception {
        String viewId = UUID.randomUUID().toString();
        String reason = UUID.randomUUID().toString();
        BundleJson bundleJson = this.createBundleWithSubscriptions();
        InvoiceJson invoiceJson = this.createInvoice();
        PaymentJson paymentJson = this.createPayment(UUID.fromString(invoiceJson.getAccountId()), UUID.fromString(invoiceJson.getInvoiceId()));
        BundleTimelineJson bundleTimelineJson = new BundleTimelineJson(viewId, bundleJson, (List)ImmutableList.of((Object)paymentJson), (List)ImmutableList.of((Object)invoiceJson), reason);
        String asJson = this.mapper.writeValueAsString((Object)bundleTimelineJson);
        BundleTimelineJson fromJson = (BundleTimelineJson)this.mapper.readValue(asJson, BundleTimelineJson.class);
        Assert.assertEquals((Object)fromJson, (Object)bundleTimelineJson);
    }

    private BundleJson createBundleWithSubscriptions() {
        String someUUID = UUID.randomUUID().toString();
        UUID accountId = UUID.randomUUID();
        UUID bundleId = UUID.randomUUID();
        UUID subscriptionId = UUID.randomUUID();
        String externalKey = UUID.randomUUID().toString();
        SubscriptionJson entitlementJsonWithEvents = new SubscriptionJson(accountId.toString(), bundleId.toString(), subscriptionId.toString(), externalKey, new LocalDate(), someUUID, someUUID, someUUID, someUUID, new LocalDate(), new LocalDate(), new LocalDate(), new LocalDate(), null, null, null, null);
        return new BundleJson(accountId.toString(), bundleId.toString(), externalKey, (List)ImmutableList.of((Object)entitlementJsonWithEvents), null);
    }

    private InvoiceJson createInvoice() {
        UUID accountId = UUID.randomUUID();
        UUID invoiceId = UUID.randomUUID();
        BigDecimal invoiceAmount = BigDecimal.TEN;
        BigDecimal creditAdj = BigDecimal.ONE;
        BigDecimal refundAdj = BigDecimal.ONE;
        LocalDate invoiceDate = this.clock.getUTCToday();
        LocalDate targetDate = this.clock.getUTCToday();
        String invoiceNumber = UUID.randomUUID().toString();
        BigDecimal balance = BigDecimal.ZERO;
        return new InvoiceJson(invoiceAmount, Currency.USD.toString(), creditAdj, refundAdj, invoiceId.toString(), invoiceDate, targetDate, invoiceNumber, balance, accountId.toString(), null, null, null, null);
    }

    private PaymentJson createPayment(UUID accountId, UUID invoiceId) {
        UUID paymentId = UUID.randomUUID();
        Integer paymentNumber = 17;
        UUID paymentMethodId = UUID.randomUUID();
        BigDecimal paidAmount = BigDecimal.TEN;
        BigDecimal amount = BigDecimal.ZERO;
        DateTime paymentRequestedDate = this.clock.getUTCNow();
        DateTime paymentEffectiveDate = this.clock.getUTCNow();
        Integer retryCount = Integer.MAX_VALUE;
        String currency = "USD";
        String status = UUID.randomUUID().toString();
        String gatewayErrorCode = "OK";
        String gatewayErrorMsg = "Excellent...";
        return new PaymentJson(amount, paidAmount, accountId.toString(), invoiceId.toString(), paymentId.toString(), paymentNumber.toString(), paymentMethodId.toString(), paymentRequestedDate, paymentEffectiveDate, retryCount, "USD", status, "OK", "Excellent...", null, null, null, null);
    }
}

