/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.plugin;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import org.killbill.billing.catalog.DefaultBlock;
import org.killbill.billing.catalog.DefaultDuration;
import org.killbill.billing.catalog.DefaultFixed;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultLimit;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultPriceListSet;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.DefaultRecurring;
import org.killbill.billing.catalog.DefaultTier;
import org.killbill.billing.catalog.DefaultTieredBlock;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Block;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.Fixed;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Limit;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Price;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.Tier;
import org.killbill.billing.catalog.api.TieredBlock;
import org.killbill.billing.catalog.api.Unit;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.catalog.api.rules.Case;
import org.killbill.billing.catalog.api.rules.CaseBillingAlignment;
import org.killbill.billing.catalog.api.rules.CaseCancelPolicy;
import org.killbill.billing.catalog.api.rules.CaseChange;
import org.killbill.billing.catalog.api.rules.CaseChangePlanAlignment;
import org.killbill.billing.catalog.api.rules.CaseChangePlanPolicy;
import org.killbill.billing.catalog.api.rules.CaseCreateAlignment;
import org.killbill.billing.catalog.api.rules.CasePhase;
import org.killbill.billing.catalog.api.rules.CasePriceList;
import org.killbill.billing.catalog.api.rules.PlanRules;
import org.killbill.billing.catalog.plugin.api.StandalonePluginCatalog;
import org.killbill.billing.catalog.rules.DefaultCaseBillingAlignment;
import org.killbill.billing.catalog.rules.DefaultCaseCancelPolicy;
import org.killbill.billing.catalog.rules.DefaultCaseChange;
import org.killbill.billing.catalog.rules.DefaultCaseChangePlanAlignment;
import org.killbill.billing.catalog.rules.DefaultCaseChangePlanPolicy;
import org.killbill.billing.catalog.rules.DefaultCaseCreateAlignment;
import org.killbill.billing.catalog.rules.DefaultCasePhase;
import org.killbill.billing.catalog.rules.DefaultCasePriceList;
import org.killbill.billing.catalog.rules.DefaultCaseStandardNaming;
import org.killbill.billing.catalog.rules.DefaultPlanRules;

public class StandaloneCatalogMapper {
    private final String catalogName;
    private Map<String, Product> tmpDefaultProducts;
    private Map<String, Plan> tmpDefaultPlans;
    private DefaultPriceListSet tmpDefaultPriceListSet;
    private Map<String, DefaultPriceList> tmpDefaultPriceListMap;

    public StandaloneCatalogMapper(String catalogName) {
        this.catalogName = catalogName;
        this.tmpDefaultProducts = null;
        this.tmpDefaultPlans = null;
        this.tmpDefaultPriceListMap = new HashMap<String, DefaultPriceList>();
    }

    public StandaloneCatalog toStandaloneCatalog(StandalonePluginCatalog pluginCatalog) {
        StandaloneCatalog result = new StandaloneCatalog();
        result.setCatalogName(this.catalogName);
        result.setEffectiveDate(pluginCatalog.getEffectiveDate().toDate());
        result.setProducts(this.toDefaultProducts(pluginCatalog.getProducts()));
        result.setPlans(this.toDefaultPlans(result, pluginCatalog.getPlans()));
        result.setPriceLists(this.toDefaultPriceListSet(pluginCatalog.getDefaultPriceList(), pluginCatalog.getChildrenPriceList()));
        result.setSupportedCurrencies((Currency[])this.toArray(pluginCatalog.getCurrencies()));
        result.setUnits(this.toDefaultUnits(pluginCatalog.getUnits()));
        result.setPlanRules(this.toDefaultPlanRules(pluginCatalog.getPlanRules()));
        for (Product cur : pluginCatalog.getProducts()) {
            Product target = result.getCatalogEntityCollectionProduct().findByName(cur.getName());
            if (target == null) continue;
            ((DefaultProduct)target).setAvailable(this.toFilteredDefaultProduct(cur.getAvailable()));
            ((DefaultProduct)target).setIncluded(this.toFilteredDefaultProduct(cur.getIncluded()));
        }
        result.initialize(result);
        return result;
    }

    private DefaultPlanRules toDefaultPlanRules(PlanRules input) {
        DefaultPlanRules result = new DefaultPlanRules();
        result.setBillingAlignmentCase(this.toDefaultCaseBillingAlignments(input.getCaseBillingAlignment()));
        result.setCancelCase(this.toDefaultCaseCancelPolicys(input.getCaseCancelPolicy()));
        result.setChangeAlignmentCase(this.toDefaultCaseChangePlanAlignments(input.getCaseChangePlanAlignment()));
        result.setChangeCase(this.toDefaultCaseChangePlanPolicies(input.getCaseChangePlanPolicy()));
        result.setCreateAlignmentCase(this.toDefaultCaseCreateAlignments(input.getCaseCreateAlignment()));
        result.setPriceListCase(this.toDefaultCasePriceLists(input.getCasePriceList()));
        return result;
    }

    final DefaultCaseChangePlanPolicy[] toDefaultCaseChangePlanPolicies(Iterable<CaseChangePlanPolicy> input) {
        return this.toArrayWithTransform(input, new Function<CaseChangePlanPolicy, DefaultCaseChangePlanPolicy>(){

            public DefaultCaseChangePlanPolicy apply(CaseChangePlanPolicy input) {
                return StandaloneCatalogMapper.this.toDefaultCaseChangePlanPolicy(input);
            }
        });
    }

    final DefaultCaseChangePlanAlignment[] toDefaultCaseChangePlanAlignments(Iterable<CaseChangePlanAlignment> input) {
        return this.toArrayWithTransform(input, new Function<CaseChangePlanAlignment, DefaultCaseChangePlanAlignment>(){

            public DefaultCaseChangePlanAlignment apply(CaseChangePlanAlignment input) {
                return StandaloneCatalogMapper.this.toDefaultCaseChangePlanAlignment(input);
            }
        });
    }

    final DefaultCaseBillingAlignment[] toDefaultCaseBillingAlignments(Iterable<CaseBillingAlignment> input) {
        return this.toArrayWithTransform(input, new Function<CaseBillingAlignment, DefaultCaseBillingAlignment>(){

            public DefaultCaseBillingAlignment apply(CaseBillingAlignment input) {
                return StandaloneCatalogMapper.this.toDefaultCaseBillingAlignment(input);
            }
        });
    }

    final DefaultCaseCancelPolicy[] toDefaultCaseCancelPolicys(Iterable<CaseCancelPolicy> input) {
        return this.toArrayWithTransform(input, new Function<CaseCancelPolicy, DefaultCaseCancelPolicy>(){

            public DefaultCaseCancelPolicy apply(CaseCancelPolicy input) {
                return StandaloneCatalogMapper.this.toDefaultCaseCancelPolicy(input);
            }
        });
    }

    final DefaultCaseCreateAlignment[] toDefaultCaseCreateAlignments(Iterable<CaseCreateAlignment> input) {
        return this.toArrayWithTransform(input, new Function<CaseCreateAlignment, DefaultCaseCreateAlignment>(){

            public DefaultCaseCreateAlignment apply(CaseCreateAlignment input) {
                return StandaloneCatalogMapper.this.toCaseCreateAlignment(input);
            }
        });
    }

    final DefaultCasePriceList[] toDefaultCasePriceLists(Iterable<CasePriceList> input) {
        return this.toArrayWithTransform(input, new Function<CasePriceList, DefaultCasePriceList>(){

            public DefaultCasePriceList apply(CasePriceList input) {
                return StandaloneCatalogMapper.this.toDefaultCasePriceList(input);
            }
        });
    }

    final DefaultCasePriceList toDefaultCasePriceList(CasePriceList input) {
        DefaultCasePriceList result = new DefaultCasePriceList();
        result.setToPriceList(this.toDefaultPriceList(input.getDestinationPriceList()));
        this.populateDefaultCase((Case)input, result);
        return result;
    }

    final DefaultCaseCreateAlignment toCaseCreateAlignment(CaseCreateAlignment input) {
        DefaultCaseCreateAlignment result = new DefaultCaseCreateAlignment();
        result.setAlignment(input.getPlanAlignmentCreate());
        this.populateDefaultCase((Case)input, result);
        return result;
    }

    final DefaultCaseBillingAlignment toDefaultCaseBillingAlignment(CaseBillingAlignment input) {
        DefaultCaseBillingAlignment result = new DefaultCaseBillingAlignment();
        result.setAlignment(input.getBillingAlignment());
        this.populateDefaultCasePhase((CasePhase)input, result);
        return result;
    }

    final DefaultCaseCancelPolicy toDefaultCaseCancelPolicy(CaseCancelPolicy input) {
        DefaultCaseCancelPolicy result = new DefaultCaseCancelPolicy();
        result.setPolicy(input.getBillingActionPolicy());
        this.populateDefaultCasePhase((CasePhase)input, result);
        return result;
    }

    final void populateDefaultCasePhase(CasePhase input, DefaultCasePhase result) {
        result.setPhaseType(input.getPhaseType());
        this.populateDefaultCase((Case)input, result);
    }

    final void populateDefaultCase(Case input, DefaultCaseStandardNaming result) {
        result.setBillingPeriod(input.getBillingPeriod());
        result.setPriceList(this.toDefaultPriceList(input.getPriceList()));
        result.setProduct(this.toDefaultProduct(input.getProduct()));
        result.setProductCategory(input.getProductCategory());
    }

    final DefaultCaseChangePlanPolicy toDefaultCaseChangePlanPolicy(CaseChangePlanPolicy input) {
        DefaultCaseChangePlanPolicy result = new DefaultCaseChangePlanPolicy();
        result.setPolicy(input.getBillingActionPolicy());
        this.populateDefaultCaseChange((CaseChange)input, result);
        return result;
    }

    final DefaultCaseChangePlanAlignment toDefaultCaseChangePlanAlignment(CaseChangePlanAlignment input) {
        DefaultCaseChangePlanAlignment result = new DefaultCaseChangePlanAlignment();
        result.setAlignment(input.getAlignment());
        this.populateDefaultCaseChange((CaseChange)input, result);
        return result;
    }

    final void populateDefaultCaseChange(CaseChange input, DefaultCaseChange result) {
        result.setPhaseType(input.getPhaseType());
        result.setFromBillingPeriod(input.getFromBillingPeriod());
        result.setFromPriceList(this.toDefaultPriceList(input.getFromPriceList()));
        result.setFromProduct(this.toDefaultProduct(input.getFromProduct()));
        result.setFromProductCategory(input.getFromProductCategory());
        result.setToBillingPeriod(input.getToBillingPeriod());
        result.setToPriceList(this.toDefaultPriceList(input.getToPriceList()));
        result.setToProduct(this.toDefaultProduct(input.getToProduct()));
        result.setToProductCategory(input.getToProductCategory());
    }

    private Iterable<Product> toDefaultProducts(Iterable<Product> input) {
        if (this.tmpDefaultProducts == null) {
            HashMap<String, Product> map = new HashMap<String, Product>();
            for (Product product : input) {
                map.put(product.getName(), this.toDefaultProduct(product));
            }
            this.tmpDefaultProducts = map;
        }
        return this.tmpDefaultProducts.values();
    }

    private Collection<Product> toFilteredDefaultProduct(Collection<Product> input) {
        if (!input.iterator().hasNext()) {
            return Collections.emptyList();
        }
        Iterable inputProductNames = Iterables.transform(input, (Function)new Function<Product, String>(){

            public String apply(Product input) {
                return input.getName();
            }
        });
        ArrayList<Product> filteredAndOrdered = new ArrayList<Product>(input.size());
        for (String cur : inputProductNames) {
            Product found = this.tmpDefaultProducts.get(cur);
            if (found == null) {
                throw new IllegalStateException("Failed to find product " + cur);
            }
            filteredAndOrdered.add(found);
        }
        return filteredAndOrdered;
    }

    private Iterable<Plan> toDefaultPlans(StaticCatalog staticCatalog, Iterable<Plan> input) {
        if (this.tmpDefaultPlans == null) {
            HashMap<String, Plan> map = new HashMap<String, Plan>();
            for (Plan plan : input) {
                map.put(plan.getName(), this.toDefaultPlan(staticCatalog, plan));
            }
            this.tmpDefaultPlans = map;
        }
        return this.tmpDefaultPlans.values();
    }

    private Iterable<Plan> toFilterDefaultPlans(final String priceListName) {
        if (this.tmpDefaultPlans == null) {
            throw new IllegalStateException("Cannot filter on uninitialized plans");
        }
        return Iterables.filter(this.tmpDefaultPlans.values(), (Predicate)new Predicate<Plan>(){

            public boolean apply(Plan input) {
                return ((DefaultPlan)input).getPriceListName().equals(priceListName);
            }
        });
    }

    private DefaultPriceListSet toDefaultPriceListSet(PriceList defaultPriceList, Iterable<PriceList> childrenPriceLists) {
        if (this.tmpDefaultPriceListSet == null) {
            this.tmpDefaultPriceListSet = new DefaultPriceListSet(this.toDefaultPriceList(defaultPriceList), this.toDefaultPriceLists(childrenPriceLists));
        }
        return this.tmpDefaultPriceListSet;
    }

    private DefaultPlanPhase[] toDefaultPlanPhases(Iterable<PlanPhase> input) {
        if (!input.iterator().hasNext()) {
            return new DefaultPlanPhase[0];
        }
        return this.toArrayWithTransform(input, new Function<PlanPhase, DefaultPlanPhase>(){

            public DefaultPlanPhase apply(PlanPhase input) {
                return StandaloneCatalogMapper.this.toDefaultPlanPhase(input);
            }
        });
    }

    private DefaultPriceList[] toDefaultPriceLists(Iterable<PriceList> input) {
        return this.toArrayWithTransform(input, new Function<PriceList, DefaultPriceList>(){

            public DefaultPriceList apply(PriceList input) {
                return StandaloneCatalogMapper.this.toDefaultPriceList(input);
            }
        });
    }

    private DefaultPrice[] toDefaultPrices(Iterable<Price> input) {
        return this.toArrayWithTransform(input, new Function<Price, DefaultPrice>(){

            public DefaultPrice apply(Price input) {
                return StandaloneCatalogMapper.this.toDefaultPrice(input);
            }
        });
    }

    private DefaultUnit[] toDefaultUnits(Iterable<Unit> input) {
        return this.toArrayWithTransform(input, new Function<Unit, DefaultUnit>(){

            public DefaultUnit apply(Unit inputTransform) {
                return StandaloneCatalogMapper.this.toDefaultUnit(inputTransform);
            }
        });
    }

    private DefaultUnit toDefaultUnit(Unit input) {
        DefaultUnit result = new DefaultUnit();
        result.setName(input.getName());
        result.setPrettyName(input.getPrettyName());
        return result;
    }

    private DefaultPriceList toDefaultPriceList(@Nullable PriceList input) {
        if (input == null) {
            return null;
        }
        DefaultPriceList result = this.tmpDefaultPriceListMap.get(input.getName());
        if (result == null) {
            result = new DefaultPriceList();
            result.setName(input.getName());
            result.setPlans(this.toFilterDefaultPlans(input.getName()));
            this.tmpDefaultPriceListMap.put(input.getName(), result);
        }
        return result;
    }

    private Product toDefaultProduct(@Nullable Product input) {
        if (input == null) {
            return null;
        }
        if (this.tmpDefaultProducts != null) {
            Product existingProduct = this.tmpDefaultProducts.get(input.getName());
            if (existingProduct == null) {
                throw new IllegalStateException("Unknown product " + input.getName());
            }
            return existingProduct;
        }
        DefaultProduct result = new DefaultProduct();
        result.setCatalogName(this.catalogName);
        result.setCatagory(input.getCategory());
        result.setName(input.getName());
        result.setPrettyName(input.getPrettyName());
        return result;
    }

    private Plan toDefaultPlan(StaticCatalog staticCatalog, Plan input) {
        if (this.tmpDefaultPlans != null) {
            Plan existingPlan = this.tmpDefaultPlans.get(input.getName());
            if (existingPlan == null) {
                throw new IllegalStateException("Unknown plan " + input.getName());
            }
            return existingPlan;
        }
        DefaultPlan result = new DefaultPlan();
        result.setName(input.getName());
        result.setPrettyName(input.getPrettyName());
        result.setRecurringBillingMode(input.getRecurringBillingMode());
        result.setEffectiveDateForExistingSubscriptions(input.getEffectiveDateForExistingSubscriptions());
        result.setFinalPhase(this.toDefaultPlanPhase(input.getFinalPhase()));
        result.setInitialPhases(this.toDefaultPlanPhases((Iterable<PlanPhase>)ImmutableList.copyOf((Object[])input.getInitialPhases())));
        result.setPlansAllowedInBundle(input.getPlansAllowedInBundle());
        result.setProduct(this.toDefaultProduct(input.getProduct()));
        result.setPriceListName(input.getPriceList().getName());
        result.initialize((StandaloneCatalog)staticCatalog);
        return result;
    }

    private DefaultPlanPhase toDefaultPlanPhase(PlanPhase input) {
        DefaultPlanPhase result = new DefaultPlanPhase();
        result.setDuration(this.toDefaultDuration(input.getDuration()));
        result.setFixed(this.toDefaultFixed(input.getFixed()));
        result.setPhaseType(input.getPhaseType());
        result.setRecurring(this.toDefaultRecurring(input.getRecurring()));
        if (input.getUsages() != null && input.getUsages().length > 0) {
            result.setUsages(this.toDefaultUsages(Arrays.asList(input.getUsages())));
        }
        return result;
    }

    private DefaultRecurring toDefaultRecurring(Recurring input) {
        DefaultRecurring result = null;
        if (input != null) {
            result = new DefaultRecurring();
            result.setBillingPeriod(input.getBillingPeriod());
            result.setRecurringPrice(this.toDefaultInternationalPrice(input.getRecurringPrice()));
        }
        return result;
    }

    private final DefaultDuration toDefaultDuration(Duration input) {
        DefaultDuration result = new DefaultDuration();
        result.setNumber(input.getNumber());
        result.setUnit(input.getUnit());
        return result;
    }

    private final DefaultFixed toDefaultFixed(@Nullable Fixed input) {
        DefaultFixed result = null;
        if (input != null) {
            result = new DefaultFixed();
            result.setFixedPrice(this.toDefaultInternationalPrice(input.getPrice()));
            result.setType(input.getType());
        }
        return result;
    }

    private DefaultInternationalPrice toDefaultInternationalPrice(InternationalPrice input) {
        DefaultInternationalPrice result = null;
        if (input != null) {
            result = new DefaultInternationalPrice();
            result.setPrices(this.toDefaultPrices((Iterable<Price>)ImmutableList.copyOf((Object[])input.getPrices())));
        }
        return result;
    }

    private DefaultPrice toDefaultPrice(Price input) {
        try {
            DefaultPrice result = new DefaultPrice();
            result.setCurrency(input.getCurrency());
            result.setValue(input.getValue());
            return result;
        }
        catch (CurrencyValueNull currencyValueNull) {
            throw new IllegalStateException(currencyValueNull);
        }
    }

    private DefaultUsage[] toDefaultUsages(Iterable<Usage> input) {
        return this.toArrayWithTransform(input, new Function<Usage, DefaultUsage>(){

            @Nullable
            public DefaultUsage apply(@Nullable Usage input) {
                return StandaloneCatalogMapper.this.toDefaultUsage(input);
            }
        });
    }

    private DefaultUsage toDefaultUsage(Usage input) {
        DefaultUsage result = new DefaultUsage();
        result.setName(input.getName());
        result.setBillingMode(input.getBillingMode());
        result.setBillingPeriod(input.getBillingPeriod());
        result.setUsageType(input.getUsageType());
        result.setTierBlockPolicy(input.getTierBlockPolicy());
        if (input.getLimits() != null && input.getLimits().length > 0) {
            result.setLimits(this.toDefaultLimits(Arrays.asList(input.getLimits())));
        }
        if (input.getBlocks() != null && input.getBlocks().length > 0) {
            result.setBlocks(this.toDefaultBlocks(Arrays.asList(input.getBlocks())));
        }
        if (input.getTiers() != null && input.getTiers().length > 0) {
            result.setTiers(this.toDefaultTiers(Arrays.asList(input.getTiers())));
        }
        result.setFixedPrice(this.toDefaultInternationalPrice(input.getFixedPrice()));
        result.setRecurringPrice(this.toDefaultInternationalPrice(input.getRecurringPrice()));
        return result;
    }

    private DefaultLimit[] toDefaultLimits(Iterable<Limit> input) {
        return this.toArrayWithTransform(input, new Function<Limit, DefaultLimit>(){

            public DefaultLimit apply(Limit input) {
                return StandaloneCatalogMapper.this.toDefaultLimit(input);
            }
        });
    }

    private DefaultLimit toDefaultLimit(Limit input) {
        DefaultLimit result = null;
        if (input != null) {
            result = new DefaultLimit();
            result.setUnit(this.toDefaultUnit(input.getUnit()));
            result.setMax(input.getMax());
            result.setMin(input.getMin());
        }
        return result;
    }

    private DefaultBlock[] toDefaultBlocks(Iterable<Block> input) {
        return this.toArrayWithTransform(input, new Function<Block, DefaultBlock>(){

            @Nullable
            public DefaultBlock apply(@Nullable Block input) {
                return StandaloneCatalogMapper.this.toDefaultBlock(input);
            }
        });
    }

    private DefaultBlock toDefaultBlock(Block input) {
        DefaultBlock result = null;
        if (input != null) {
            result = new DefaultBlock();
            result.setType(input.getType());
            result.setPrice(this.toDefaultInternationalPrice(input.getPrice()));
            result.setUnit(this.toDefaultUnit(input.getUnit()));
            result.setSize(input.getSize());
        }
        return result;
    }

    private DefaultTier[] toDefaultTiers(Iterable<Tier> input) {
        return this.toArrayWithTransform(input, new Function<Tier, DefaultTier>(){

            @Nullable
            public DefaultTier apply(@Nullable Tier input) {
                return StandaloneCatalogMapper.this.toDefaultTier(input);
            }
        });
    }

    private DefaultTier toDefaultTier(Tier input) {
        DefaultTier result = null;
        if (input != null) {
            result = new DefaultTier();
            if (input.getLimits() != null && input.getLimits().length > 0) {
                result.setLimits(this.toDefaultLimits(Arrays.asList(input.getLimits())));
            }
            result.setFixedPrice(this.toDefaultInternationalPrice(input.getFixedPrice()));
            result.setRecurringPrice(this.toDefaultInternationalPrice(input.getRecurringPrice()));
            if (input.getTieredBlocks() != null && input.getTieredBlocks().length > 0) {
                result.setBlocks(this.toDefaultTieredBlocks(Arrays.asList(input.getTieredBlocks())));
            }
        }
        return result;
    }

    private DefaultTieredBlock[] toDefaultTieredBlocks(Iterable<TieredBlock> input) {
        return this.toArrayWithTransform(input, new Function<TieredBlock, DefaultTieredBlock>(){

            @Nullable
            public DefaultTieredBlock apply(@Nullable TieredBlock input) {
                return StandaloneCatalogMapper.this.toDefaultTieredBlock(input);
            }
        });
    }

    private DefaultTieredBlock toDefaultTieredBlock(TieredBlock input) {
        DefaultTieredBlock result = null;
        if (input != null) {
            result = new DefaultTieredBlock();
            result.setUnit(this.toDefaultUnit(input.getUnit()));
            result.setMax(input.getMax());
            result.setType(input.getType());
            result.setSize(input.getSize());
            result.setPrice(this.toDefaultInternationalPrice(input.getPrice()));
        }
        return result;
    }

    private <I, C extends I> C[] toArrayWithTransform(Iterable<I> input, Function<I, C> transformer) {
        if (input == null || !input.iterator().hasNext()) {
            return null;
        }
        Iterable tmp = Iterables.transform(input, transformer);
        return this.toArray(tmp);
    }

    private <C> C[] toArray(Iterable<C> input) {
        if (!input.iterator().hasNext()) {
            throw new IllegalStateException("Nothing to convert into array");
        }
        Object[] foo = (Object[])Array.newInstance(input.iterator().next().getClass(), 1);
        return ImmutableList.copyOf(input).toArray(foo);
    }
}

