/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.io;

import com.google.common.base.MoreObjects;
import com.google.common.io.Resources;
import com.google.inject.Inject;
import java.io.ByteArrayInputStream;
import java.io.Closeable;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import javax.xml.bind.JAXBException;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.DefaultVersionedCatalog;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.StandaloneCatalogWithPriceOverride;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.catalog.io.CatalogLoader;
import org.killbill.billing.catalog.override.PriceOverride;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.config.definition.CatalogConfig;
import org.killbill.commons.concurrent.Executors;
import org.killbill.xmlloader.UriAccessor;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationException;
import org.killbill.xmlloader.XMLLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VersionedCatalogLoader
implements CatalogLoader,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger(VersionedCatalogLoader.class);
    private static final Object PROTOCOL_FOR_FILE = "file";
    private static final String XML_EXTENSION = ".xml";
    private final PriceOverride priceOverride;
    private final ExecutorService executorService;
    private final InternalCallContextFactory internalCallContextFactory;

    @Inject
    public VersionedCatalogLoader(CatalogConfig config, PriceOverride priceOverride, InternalCallContextFactory internalCallContextFactory) {
        this.executorService = Executors.newFixedThreadPool((int)((Integer)MoreObjects.firstNonNull((Object)config.getCatalogThreadNb(), (Object)1)), (String)VersionedCatalogLoader.class.getName());
        this.priceOverride = priceOverride;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    @Override
    public VersionedCatalog loadDefaultCatalog(String uriString) throws CatalogApiException {
        try {
            List<Object> xmlURIs;
            if (uriString.endsWith(XML_EXTENSION)) {
                xmlURIs = new ArrayList<URI>();
                xmlURIs.add(new URI(uriString));
            } else {
                URL url = this.getURLFromString(uriString);
                String directoryContents = UriAccessor.accessUriAsString((String)uriString);
                xmlURIs = this.findXmlReferences(directoryContents, url);
            }
            DefaultVersionedCatalog result = new DefaultVersionedCatalog();
            for (URI uRI : xmlURIs) {
                StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromUri((URI)uRI, StandaloneCatalog.class);
                result.add(new StandaloneCatalogWithPriceOverride(catalog, this.priceOverride, InternalCallContextFactory.INTERNAL_TENANT_RECORD_ID, this.internalCallContextFactory));
            }
            XMLLoader.initializeAndValidate((ValidatingConfig)result);
            return result;
        }
        catch (ValidationException e) {
            logger.warn("Failed to load default catalog", (Throwable)e);
            throw new CatalogApiException((Throwable)e, ErrorCode.CAT_INVALID_DEFAULT, new Object[]{uriString});
        }
        catch (JAXBException e) {
            logger.warn("Failed to load default catalog", (Throwable)e);
            throw new CatalogApiException((Throwable)e, ErrorCode.CAT_INVALID_DEFAULT, new Object[]{uriString});
        }
        catch (IllegalArgumentException e) {
            logger.warn("Failed to load default catalog", (Throwable)e);
            throw new CatalogApiException((Throwable)e, ErrorCode.CAT_INVALID_DEFAULT, new Object[]{uriString});
        }
        catch (Exception e) {
            logger.warn("Failed to load default catalog", (Throwable)e);
            throw new IllegalStateException(e);
        }
    }

    private URL getURLFromString(String urlString) {
        try {
            return new URL(urlString);
        }
        catch (MalformedURLException malformedURLException) {
            return Resources.getResource((String)urlString);
        }
    }

    public VersionedCatalog load(Collection<String> catalogXMLs, final boolean filterTemplateCatalog, final Long tenantRecordId) throws CatalogApiException {
        try {
            ArrayList<Future<StandaloneCatalog>> catalogs = new ArrayList<Future<StandaloneCatalog>>(catalogXMLs.size());
            for (final String string : catalogXMLs) {
                catalogs.add(this.executorService.submit(new Callable<StandaloneCatalog>(){

                    @Override
                    public StandaloneCatalog call() throws Exception {
                        ByteArrayInputStream curCatalogStream = new ByteArrayInputStream(string.getBytes());
                        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromStream((InputStream)curCatalogStream, StandaloneCatalog.class);
                        if (!filterTemplateCatalog || !catalog.isTemplateCatalog()) {
                            return new StandaloneCatalogWithPriceOverride(catalog, VersionedCatalogLoader.this.priceOverride, tenantRecordId, VersionedCatalogLoader.this.internalCallContextFactory);
                        }
                        return null;
                    }
                }));
            }
            DefaultVersionedCatalog result = new DefaultVersionedCatalog();
            for (Future future : catalogs) {
                StandaloneCatalog catalog = (StandaloneCatalog)future.get();
                if (catalog == null) continue;
                result.add(catalog);
            }
            XMLLoader.initializeAndValidate((ValidatingConfig)result);
            return result;
        }
        catch (ValidationException e) {
            logger.warn("Failed to load catalog for tenantRecordId='{}'", (Object)tenantRecordId, (Object)e);
            for (ValidationError validationError : e.getErrors()) {
                logger.warn(validationError.toString());
            }
            throw new CatalogApiException((Throwable)e, ErrorCode.CAT_INVALID_FOR_TENANT, new Object[]{tenantRecordId});
        }
        catch (InterruptedException e) {
            logger.warn("Failed to load catalog for tenantRecordId='{}'", (Object)tenantRecordId, (Object)e);
            throw new CatalogApiException((Throwable)e, ErrorCode.CAT_INVALID_FOR_TENANT, new Object[]{tenantRecordId});
        }
        catch (ExecutionException e) {
            logger.warn("Failed to load catalog for tenantRecordId='{}'", (Object)tenantRecordId, (Object)e);
            throw new CatalogApiException((Throwable)e, ErrorCode.CAT_INVALID_FOR_TENANT, new Object[]{tenantRecordId});
        }
    }

    protected List<URI> findXmlReferences(String directoryContents, URL url) throws URISyntaxException {
        if (url.getProtocol().equals(PROTOCOL_FOR_FILE)) {
            return this.findXmlFileReferences(directoryContents, url);
        }
        return this.findXmlUrlReferences(directoryContents, url);
    }

    protected List<URI> findXmlUrlReferences(String directoryContents, URL url) throws URISyntaxException {
        ArrayList<URI> results = new ArrayList<URI>();
        List<String> urlFragments = this.extractHrefs(directoryContents);
        for (String u : urlFragments) {
            if (!u.endsWith(XML_EXTENSION)) continue;
            if (u.startsWith("/")) {
                results.add(new URI(url.getProtocol() + ":" + u));
                continue;
            }
            if (u.startsWith("http:")) {
                results.add(new URI(u));
                continue;
            }
            results.add(this.appendToURI(url, u));
        }
        return results;
    }

    protected List<String> extractHrefs(String directoryContents) {
        ArrayList<String> results = new ArrayList<String>();
        int start = 0;
        int end = 0;
        String HREF_SEARCH_END = "\"";
        String HREF_LOW_START = "href=\"";
        while (start >= 0) {
            start = directoryContents.indexOf("href=\"", end);
            if (start > 0) {
                start += "href=\"".length();
            }
            end = directoryContents.indexOf("\"", start);
            if (start < 0) continue;
            results.add(directoryContents.substring(start, end));
        }
        start = 0;
        end = 0;
        while (start >= 0) {
            String HREF_CAPS_START = "HREF=\"";
            start = directoryContents.indexOf("HREF=\"", end);
            if (start > 0) {
                start = "href=\"".length();
            }
            end = directoryContents.indexOf("\"", start);
            if (start < 0) continue;
            results.add(directoryContents.substring(start, end));
        }
        return results;
    }

    protected List<URI> findXmlFileReferences(String directoryContents, URL url) throws URISyntaxException {
        String[] filenames;
        ArrayList<URI> results = new ArrayList<URI>();
        for (String filename : filenames = directoryContents.split("\\n")) {
            if (!filename.endsWith(XML_EXTENSION)) continue;
            results.add(this.appendToURI(url, filename));
        }
        return results;
    }

    protected URI appendToURI(URL url, String filename) throws URISyntaxException {
        String f = filename;
        if (!url.toString().endsWith("/")) {
            f = "/" + filename;
        }
        return new URI(url.toString() + f);
    }

    @Override
    public void close() {
        this.executorService.shutdown();
    }
}

