/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.glue;

import com.google.common.base.MoreObjects;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import java.lang.annotation.Annotation;
import org.killbill.billing.catalog.DefaultCatalogService;
import org.killbill.billing.catalog.api.CatalogInternalApi;
import org.killbill.billing.catalog.api.CatalogService;
import org.killbill.billing.catalog.api.CatalogUserApi;
import org.killbill.billing.catalog.api.DefaultCatalogInternalApi;
import org.killbill.billing.catalog.api.user.DefaultCatalogUserApi;
import org.killbill.billing.catalog.caching.CatalogCache;
import org.killbill.billing.catalog.caching.CatalogCacheInvalidationCallback;
import org.killbill.billing.catalog.caching.DefaultCatalogCache;
import org.killbill.billing.catalog.caching.DefaultOverriddenPlanCache;
import org.killbill.billing.catalog.caching.OverriddenPlanCache;
import org.killbill.billing.catalog.caching.PriceOverridePattern;
import org.killbill.billing.catalog.dao.CatalogOverrideDao;
import org.killbill.billing.catalog.dao.DefaultCatalogOverrideDao;
import org.killbill.billing.catalog.glue.DefaultCatalogProviderPluginRegistryProvider;
import org.killbill.billing.catalog.io.CatalogLoader;
import org.killbill.billing.catalog.io.VersionedCatalogLoader;
import org.killbill.billing.catalog.override.DefaultPriceOverride;
import org.killbill.billing.catalog.override.PriceOverride;
import org.killbill.billing.catalog.plugin.VersionedCatalogMapper;
import org.killbill.billing.catalog.plugin.api.CatalogPluginApi;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.platform.api.KillbillConfigSource;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.util.config.definition.CatalogConfig;
import org.killbill.billing.util.glue.KillBillModule;
import org.skife.config.ConfigurationObjectFactory;

public class CatalogModule
extends KillBillModule {
    public static final String CATALOG_INVALIDATION_CALLBACK = "CatalogInvalidationCallback";
    private final PriceOverridePattern priceOverridePattern;

    public CatalogModule(KillbillConfigSource configSource) {
        super(configSource);
        boolean useRECXMLNamesCompliant = Boolean.valueOf((String)MoreObjects.firstNonNull((Object)configSource.getString("org.killbill.catalog.price.override.delimiter.REC-xml-names-19990114.compliant"), (Object)"false"));
        this.priceOverridePattern = new PriceOverridePattern(useRECXMLNamesCompliant);
    }

    protected void installConfig() {
        CatalogConfig config = (CatalogConfig)new ConfigurationObjectFactory(this.skifeConfigSource).build(CatalogConfig.class);
        this.bind(CatalogConfig.class).toInstance((Object)config);
    }

    protected void installCatalog() {
        this.bind(PriceOverridePattern.class).toInstance((Object)this.priceOverridePattern);
        this.bind(CatalogService.class).to(DefaultCatalogService.class).asEagerSingleton();
        this.bind(CatalogLoader.class).to(VersionedCatalogLoader.class).asEagerSingleton();
        this.bind(PriceOverride.class).to(DefaultPriceOverride.class).asEagerSingleton();
    }

    protected void installCatalogDao() {
        this.bind(CatalogOverrideDao.class).to(DefaultCatalogOverrideDao.class).asEagerSingleton();
    }

    protected void installCatalogUserApi() {
        this.bind(CatalogUserApi.class).to(DefaultCatalogUserApi.class).asEagerSingleton();
    }

    protected void installCatalogInternalApi() {
        this.bind(CatalogInternalApi.class).to(DefaultCatalogInternalApi.class).asEagerSingleton();
    }

    public void installCatalogConfigCache() {
        this.bind(CatalogCache.class).to(DefaultCatalogCache.class).asEagerSingleton();
        this.bind(TenantInternalApi.CacheInvalidationCallback.class).annotatedWith((Annotation)Names.named((String)CATALOG_INVALIDATION_CALLBACK)).to(CatalogCacheInvalidationCallback.class).asEagerSingleton();
        this.bind(OverriddenPlanCache.class).to(DefaultOverriddenPlanCache.class).asEagerSingleton();
    }

    protected void installCatalogPluginApi() {
        this.bind((TypeLiteral)new TypeLiteral<OSGIServiceRegistration<CatalogPluginApi>>(){}).toProvider(DefaultCatalogProviderPluginRegistryProvider.class).asEagerSingleton();
        this.bind(VersionedCatalogMapper.class).asEagerSingleton();
    }

    protected void configure() {
        this.installConfig();
        this.installCatalogDao();
        this.installCatalog();
        this.installCatalogUserApi();
        this.installCatalogInternalApi();
        this.installCatalogConfigCache();
        this.installCatalogPluginApi();
    }
}

