/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.caching;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.api.CatalogApiException;

public class PriceOverridePattern {
    public static final String LEGACY_CUSTOM_PLAN_NAME_DELIMITER = "-";
    public static final String CUSTOM_PLAN_NAME_DELIMITER = ":";
    private final String delimiter;
    private final Pattern pattern;

    public PriceOverridePattern(boolean useRECXMLNamesCompliant) {
        this.delimiter = useRECXMLNamesCompliant ? CUSTOM_PLAN_NAME_DELIMITER : LEGACY_CUSTOM_PLAN_NAME_DELIMITER;
        this.pattern = Pattern.compile("(.*)" + this.delimiter + "(\\d+)(?:!\\d+)?$");
    }

    public String[] getPlanParts(String planName) throws CatalogApiException {
        Matcher m = this.pattern.matcher(planName);
        if (!m.matches()) {
            throw new CatalogApiException(ErrorCode.CAT_NO_SUCH_PLAN, new Object[]{planName});
        }
        String[] res = new String[]{m.group(1), m.group(2)};
        return res;
    }

    public Pattern pattern() {
        return this.pattern;
    }

    public String getPlanName(String[] parts) {
        return String.format("%s%s%s", parts[0], this.delimiter, parts[1]);
    }

    public boolean isOverriddenPlan(String planName) {
        Matcher m = this.pattern.matcher(planName);
        return m.matches();
    }
}

