/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.caching;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhasePriceOverride;
import org.killbill.billing.catalog.DefaultTierPriceOverride;
import org.killbill.billing.catalog.DefaultTieredBlockPriceOverride;
import org.killbill.billing.catalog.DefaultUsagePriceOverride;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.Tier;
import org.killbill.billing.catalog.api.TierPriceOverride;
import org.killbill.billing.catalog.api.TieredBlock;
import org.killbill.billing.catalog.api.TieredBlockPriceOverride;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.catalog.api.UsagePriceOverride;
import org.killbill.billing.catalog.caching.OverriddenPlanCache;
import org.killbill.billing.catalog.caching.PriceOverridePattern;
import org.killbill.billing.catalog.dao.CatalogOverrideBlockDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideTierDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideUsageDefinitionModelDao;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.cache.OverriddenPlanCacheLoader;

public class DefaultOverriddenPlanCache
implements OverriddenPlanCache {
    private final CacheController<String, Plan> cacheController;
    private final OverriddenPlanCacheLoader.LoaderCallback loaderCallback;
    private final CatalogOverrideDao overrideDao;
    private final PriceOverridePattern priceOverridePattern;

    @Inject
    public DefaultOverriddenPlanCache(CatalogOverrideDao overrideDao, CacheControllerDispatcher cacheControllerDispatcher, PriceOverridePattern priceOverridePattern) {
        this.overrideDao = overrideDao;
        this.cacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.OVERRIDDEN_PLAN);
        this.priceOverridePattern = priceOverridePattern;
        this.loaderCallback = new OverriddenPlanCacheLoader.LoaderCallback(){

            public Plan loadPlan(String planName, StaticCatalog catalog, InternalTenantContext context) throws CatalogApiException {
                return DefaultOverriddenPlanCache.this.loadOverriddenPlan(planName, (StandaloneCatalog)catalog, context);
            }
        };
    }

    @Override
    public DefaultPlan getOverriddenPlan(String planName, StandaloneCatalog catalog, InternalTenantContext context) {
        ObjectType irrelevant = null;
        Object[] args = new Object[]{this.loaderCallback, catalog};
        CacheLoaderArgument argument = new CacheLoaderArgument(irrelevant, args, context);
        String planNameVersion = DefaultOverriddenPlanCache.getPlanNameVersion(planName, catalog);
        DefaultPlan defaultPlan = (DefaultPlan)this.cacheController.get((Object)planNameVersion, argument);
        defaultPlan.initialize(catalog);
        return defaultPlan;
    }

    @Override
    public void addDryRunPlan(String planName, Plan plan) {
        String planNameVersion = DefaultOverriddenPlanCache.getPlanNameVersion(planName, plan.getCatalog());
        this.cacheController.putIfAbsent((Object)planNameVersion, (Object)plan);
    }

    private static String getPlanNameVersion(String planName, StaticCatalog catalog) {
        return String.format("%s!%d", planName, catalog.getEffectiveDate().getTime());
    }

    private DefaultPlan loadOverriddenPlan(String planName, StandaloneCatalog catalog, InternalTenantContext context) throws CatalogApiException {
        String[] parts = this.priceOverridePattern.getPlanParts(planName);
        String parentPlanName = parts[0];
        Long planDefRecordId = Long.parseLong(parts[1]);
        List<CatalogOverridePhaseDefinitionModelDao> phaseDefs = this.overrideDao.getOverriddenPlanPhases(planDefRecordId, context);
        DefaultPlan defaultPlan = catalog.findPlan(parentPlanName);
        PlanPhasePriceOverride[] overrides = this.createOverrides(defaultPlan, phaseDefs, context);
        DefaultPlan result = new DefaultPlan(this.priceOverridePattern.getPlanName(parts), defaultPlan, overrides);
        result.initialize(catalog);
        return result;
    }

    private PlanPhasePriceOverride[] createOverrides(Plan defaultPlan, List<CatalogOverridePhaseDefinitionModelDao> phaseDefs, InternalTenantContext context) {
        PlanPhasePriceOverride[] result = new PlanPhasePriceOverride[defaultPlan.getAllPhases().length];
        for (int i = 0; i < defaultPlan.getAllPhases().length; ++i) {
            final PlanPhase curPhase = defaultPlan.getAllPhases()[i];
            CatalogOverridePhaseDefinitionModelDao overriddenPhase = (CatalogOverridePhaseDefinitionModelDao)Iterables.tryFind(phaseDefs, (Predicate)new Predicate<CatalogOverridePhaseDefinitionModelDao>(){

                public boolean apply(CatalogOverridePhaseDefinitionModelDao input) {
                    return input.getParentPhaseName().equals(curPhase.getName());
                }
            }).orNull();
            if (overriddenPhase != null) {
                List<UsagePriceOverride> usagePriceOverrides = this.getUsagePriceOverrides(curPhase, overriddenPhase, context);
                result[i] = new DefaultPlanPhasePriceOverride(curPhase.getName(), Currency.valueOf((String)overriddenPhase.getCurrency()), overriddenPhase.getFixedPrice(), overriddenPhase.getRecurringPrice(), usagePriceOverrides);
                continue;
            }
            result[i] = null;
        }
        return result;
    }

    List<UsagePriceOverride> getUsagePriceOverrides(PlanPhase curPhase, CatalogOverridePhaseDefinitionModelDao overriddenPhase, InternalTenantContext context) {
        ArrayList<UsagePriceOverride> usagePriceOverrides = new ArrayList<UsagePriceOverride>();
        List<CatalogOverrideUsageDefinitionModelDao> usageDefs = this.overrideDao.getOverriddenPhaseUsages(overriddenPhase.getRecordId(), context);
        for (int i = 0; i < curPhase.getUsages().length; ++i) {
            final Usage curUsage = curPhase.getUsages()[i];
            CatalogOverrideUsageDefinitionModelDao overriddenUsage = (CatalogOverrideUsageDefinitionModelDao)Iterables.tryFind(usageDefs, (Predicate)new Predicate<CatalogOverrideUsageDefinitionModelDao>(){

                public boolean apply(CatalogOverrideUsageDefinitionModelDao input) {
                    return input.getParentUsageName().equals(curUsage.getName());
                }
            }).orNull();
            if (overriddenUsage == null) continue;
            List<TierPriceOverride> tierPriceOverrides = this.getTierPriceOverrides(curUsage, overriddenUsage, context);
            usagePriceOverrides.add(new DefaultUsagePriceOverride(overriddenUsage.getParentUsageName(), curUsage.getUsageType(), tierPriceOverrides));
        }
        return usagePriceOverrides;
    }

    List<TierPriceOverride> getTierPriceOverrides(Usage curUsage, CatalogOverrideUsageDefinitionModelDao overriddenUsage, final InternalTenantContext context) {
        ArrayList<TierPriceOverride> tierPriceOverrides = new ArrayList<TierPriceOverride>();
        List<CatalogOverrideTierDefinitionModelDao> tierDefs = this.overrideDao.getOverriddenUsageTiers(overriddenUsage.getRecordId(), context);
        for (int i = 0; i < curUsage.getTiers().length; ++i) {
            Tier curTier = curUsage.getTiers()[i];
            final TieredBlock[] curTieredBlocks = curTier.getTieredBlocks();
            CatalogOverrideTierDefinitionModelDao overriddenTier = (CatalogOverrideTierDefinitionModelDao)Iterables.tryFind(tierDefs, (Predicate)new Predicate<CatalogOverrideTierDefinitionModelDao>(){

                public boolean apply(CatalogOverrideTierDefinitionModelDao input) {
                    List<CatalogOverrideBlockDefinitionModelDao> blockDefs = DefaultOverriddenPlanCache.this.overrideDao.getOverriddenTierBlocks(input.getRecordId(), context);
                    for (CatalogOverrideBlockDefinitionModelDao blockDef : blockDefs) {
                        String unitName = blockDef.getParentUnitName();
                        Double max = blockDef.getMax();
                        Double size = blockDef.getSize();
                        for (TieredBlock curTieredBlock : curTieredBlocks) {
                            if (!unitName.equals(curTieredBlock.getUnit().getName()) || Double.compare(size, curTieredBlock.getSize()) != 0 || Double.compare(max, curTieredBlock.getMax()) != 0) continue;
                            return true;
                        }
                    }
                    return false;
                }
            }).orNull();
            if (overriddenTier == null) continue;
            List<TieredBlockPriceOverride> tieredBlockPriceOverrides = this.getTieredBlockPriceOverrides(curTier, overriddenTier, context);
            tierPriceOverrides.add(new DefaultTierPriceOverride(tieredBlockPriceOverrides));
        }
        return tierPriceOverrides;
    }

    List<TieredBlockPriceOverride> getTieredBlockPriceOverrides(Tier curTier, CatalogOverrideTierDefinitionModelDao overriddenTier, InternalTenantContext context) {
        ArrayList<TieredBlockPriceOverride> blockPriceOverrides = new ArrayList<TieredBlockPriceOverride>();
        List<CatalogOverrideBlockDefinitionModelDao> blockDefs = this.overrideDao.getOverriddenTierBlocks(overriddenTier.getRecordId(), context);
        for (int i = 0; i < curTier.getTieredBlocks().length; ++i) {
            final TieredBlock curTieredBlock = curTier.getTieredBlocks()[i];
            CatalogOverrideBlockDefinitionModelDao overriddenTierBlock = (CatalogOverrideBlockDefinitionModelDao)Iterables.tryFind(blockDefs, (Predicate)new Predicate<CatalogOverrideBlockDefinitionModelDao>(){

                public boolean apply(CatalogOverrideBlockDefinitionModelDao input) {
                    return input.getParentUnitName().equals(curTieredBlock.getUnit().getName()) && Double.compare(input.getSize(), curTieredBlock.getSize()) == 0 && Double.compare(input.getMax(), curTieredBlock.getMax()) == 0;
                }
            }).orNull();
            if (overriddenTierBlock == null) continue;
            blockPriceOverrides.add(new DefaultTieredBlockPriceOverride(overriddenTierBlock.getParentUnitName(), overriddenTierBlock.getSize(), overriddenTierBlock.getPrice(), Currency.valueOf((String)overriddenTierBlock.getCurrency()), overriddenTierBlock.getMax()));
        }
        return blockPriceOverrides;
    }
}

