/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.caching;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.ObjectType;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultVersionedCatalog;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.StandaloneCatalogWithPriceOverride;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.catalog.caching.CatalogCache;
import org.killbill.billing.catalog.io.VersionedCatalogLoader;
import org.killbill.billing.catalog.override.PriceOverride;
import org.killbill.billing.catalog.plugin.VersionedCatalogMapper;
import org.killbill.billing.catalog.plugin.api.CatalogPluginApi;
import org.killbill.billing.catalog.plugin.api.VersionedPluginCatalog;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.killbill.billing.util.cache.Cachable;
import org.killbill.billing.util.cache.CacheController;
import org.killbill.billing.util.cache.CacheControllerDispatcher;
import org.killbill.billing.util.cache.CacheLoaderArgument;
import org.killbill.billing.util.cache.TenantCatalogCacheLoader;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCatalogCache
implements CatalogCache {
    private final Logger logger = LoggerFactory.getLogger(DefaultCatalogCache.class);
    private final CacheController<Long, DefaultVersionedCatalog> cacheController;
    private final VersionedCatalogLoader loader;
    private final CacheLoaderArgument cacheLoaderArgumentWithTemplateFiltering;
    private final CacheLoaderArgument cacheLoaderArgument;
    private final OSGIServiceRegistration<CatalogPluginApi> pluginRegistry;
    private final VersionedCatalogMapper versionedCatalogMapper;
    private final PriceOverride priceOverride;
    private final InternalCallContextFactory internalCallContextFactory;
    private VersionedCatalog defaultCatalog;

    @Inject
    public DefaultCatalogCache(OSGIServiceRegistration<CatalogPluginApi> pluginRegistry, VersionedCatalogMapper versionedCatalogMapper, CacheControllerDispatcher cacheControllerDispatcher, VersionedCatalogLoader loader, PriceOverride priceOverride, InternalCallContextFactory internalCallContextFactory) {
        this.pluginRegistry = pluginRegistry;
        this.versionedCatalogMapper = versionedCatalogMapper;
        this.cacheController = cacheControllerDispatcher.getCacheController(Cachable.CacheType.TENANT_CATALOG);
        this.loader = loader;
        this.priceOverride = priceOverride;
        this.internalCallContextFactory = internalCallContextFactory;
        this.cacheLoaderArgumentWithTemplateFiltering = this.initializeCacheLoaderArgument(true);
        this.cacheLoaderArgument = this.initializeCacheLoaderArgument(false);
        this.setDefaultCatalog();
    }

    @Override
    public void loadDefaultCatalog(String url) throws CatalogApiException {
        if (url != null) {
            this.defaultCatalog = this.loader.loadDefaultCatalog(url);
        }
    }

    @Override
    public VersionedCatalog getCatalog(boolean useDefaultCatalog, boolean filterTemplateCatalog, boolean internalUse, InternalTenantContext tenantContext) throws CatalogApiException {
        VersionedCatalog pluginVersionedCatalog;
        if (internalUse) {
            Preconditions.checkState((tenantContext.getAccountRecordId() != null ? 1 : 0) != 0, (Object)"Unexpected null accountRecordId in context issued from internal Kill Bill service");
        }
        if ((pluginVersionedCatalog = this.getCatalogFromPlugins(tenantContext)) != null) {
            return pluginVersionedCatalog;
        }
        if (InternalCallContextFactory.INTERNAL_TENANT_RECORD_ID.equals(tenantContext.getTenantRecordId())) {
            return useDefaultCatalog ? this.defaultCatalog : null;
        }
        try {
            DefaultVersionedCatalog tenantCatalog = (DefaultVersionedCatalog)this.cacheController.get((Object)tenantContext.getTenantRecordId(), filterTemplateCatalog ? this.cacheLoaderArgumentWithTemplateFiltering : this.cacheLoaderArgument);
            if (useDefaultCatalog && tenantCatalog == null) {
                tenantCatalog = new DefaultVersionedCatalog();
                for (StaticCatalog cur : this.defaultCatalog.getVersions()) {
                    StandaloneCatalogWithPriceOverride curWithOverride = new StandaloneCatalogWithPriceOverride(cur, this.priceOverride, tenantContext.getTenantRecordId(), this.internalCallContextFactory);
                    tenantCatalog.add(curWithOverride);
                }
                this.initializeCatalog(tenantCatalog);
                this.cacheController.putIfAbsent((Object)tenantContext.getTenantRecordId(), (Object)tenantCatalog);
            }
            return tenantCatalog;
        }
        catch (IllegalStateException e) {
            throw new CatalogApiException(ErrorCode.CAT_INVALID_FOR_TENANT, new Object[]{tenantContext.getTenantRecordId()});
        }
    }

    @Override
    public void clearCatalog(InternalTenantContext tenantContext) {
        if (!InternalCallContextFactory.INTERNAL_TENANT_RECORD_ID.equals(tenantContext.getTenantRecordId())) {
            this.cacheController.remove((Object)tenantContext.getTenantRecordId());
        }
    }

    private VersionedCatalog getCatalogFromPlugins(InternalTenantContext internalTenantContext) throws CatalogApiException {
        TenantContext tenantContext = this.internalCallContextFactory.createTenantContext(internalTenantContext);
        Set allServices = this.pluginRegistry.getAllServices();
        for (String service : allServices) {
            DefaultVersionedCatalog versionedCatalog;
            boolean cacheable;
            CatalogPluginApi plugin = (CatalogPluginApi)this.pluginRegistry.getServiceForName(service);
            DateTime latestCatalogUpdatedDate = plugin.getLatestCatalogVersion((Iterable)ImmutableList.of(), tenantContext);
            boolean bl = cacheable = latestCatalogUpdatedDate != null;
            if (cacheable && (versionedCatalog = (DefaultVersionedCatalog)this.cacheController.get((Object)internalTenantContext.getTenantRecordId(), this.cacheLoaderArgument)) != null && versionedCatalog.getCurrentVersion().getEffectiveDate().compareTo(latestCatalogUpdatedDate.toDate()) == 0) {
                return versionedCatalog;
            }
            VersionedPluginCatalog pluginCatalog = plugin.getVersionedPluginCatalog((Iterable)ImmutableList.of(), tenantContext);
            if (pluginCatalog == null) continue;
            if (allServices.size() > 1) {
                this.logger.info("Returning catalog from plugin {} on tenant {} ", (Object)service, (Object)internalTenantContext.getTenantRecordId());
            }
            DefaultVersionedCatalog resolvedPluginCatalog = this.versionedCatalogMapper.toVersionedCatalog(pluginCatalog);
            this.cacheController.remove((Object)internalTenantContext.getTenantRecordId());
            if (cacheable) {
                this.cacheController.putIfAbsent((Object)internalTenantContext.getTenantRecordId(), (Object)resolvedPluginCatalog);
            }
            return resolvedPluginCatalog;
        }
        return null;
    }

    private void initializeCatalog(VersionedCatalog tenantCatalog) {
        for (StaticCatalog cur : tenantCatalog.getVersions()) {
            if (cur instanceof StandaloneCatalogWithPriceOverride) {
                ((StandaloneCatalogWithPriceOverride)cur).initialize((StandaloneCatalog)cur, this.priceOverride, this.internalCallContextFactory);
                continue;
            }
            ((StandaloneCatalog)cur).initialize((StandaloneCatalog)cur);
        }
    }

    private CacheLoaderArgument initializeCacheLoaderArgument(final boolean filterTemplateCatalog) {
        TenantCatalogCacheLoader.LoaderCallback loaderCallback = new TenantCatalogCacheLoader.LoaderCallback(){

            public VersionedCatalog loadCatalog(List<String> catalogXMLs, Long tenantRecordId) throws CatalogApiException {
                VersionedCatalog versionedCatalog = DefaultCatalogCache.this.loader.load(catalogXMLs, filterTemplateCatalog, tenantRecordId);
                if (versionedCatalog != null) {
                    DefaultCatalogCache.this.initializeCatalog(versionedCatalog);
                }
                return versionedCatalog;
            }
        };
        Object[] args = new Object[]{loaderCallback};
        ObjectType irrelevant = null;
        InternalTenantContext notUsed = null;
        return new CacheLoaderArgument(irrelevant, args, notUsed);
    }

    @VisibleForTesting
    void setDefaultCatalog() {
        try {
            this.defaultCatalog = this.loader.loadDefaultCatalog("EmptyCatalog.xml");
        }
        catch (CatalogApiException e) {
            this.defaultCatalog = new DefaultVersionedCatalog();
            this.logger.error("Exception loading EmptyCatalog - should never happen!", (Throwable)e);
        }
    }
}

