/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.api.user;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.xml.bind.JAXBException;
import javax.xml.transform.TransformerException;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.killbill.billing.BillingExceptionBase;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogUpdater;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogService;
import org.killbill.billing.catalog.api.CatalogUserApi;
import org.killbill.billing.catalog.api.SimplePlanDescriptor;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.catalog.caching.CatalogCache;
import org.killbill.billing.tenant.api.TenantApiException;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.billing.tenant.api.TenantUserApi;
import org.killbill.billing.util.callcontext.CallContext;
import org.killbill.billing.util.callcontext.InternalCallContextFactory;
import org.killbill.billing.util.callcontext.TenantContext;
import org.killbill.clock.Clock;
import org.killbill.xmlloader.ValidationErrors;
import org.killbill.xmlloader.ValidationException;
import org.killbill.xmlloader.XMLLoader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.SAXException;

public class DefaultCatalogUserApi
implements CatalogUserApi {
    private final Logger logger = LoggerFactory.getLogger(DefaultCatalogUserApi.class);
    private final CatalogService catalogService;
    private final InternalCallContextFactory internalCallContextFactory;
    private final TenantUserApi tenantApi;
    private final CatalogCache catalogCache;
    private final Clock clock;

    @Inject
    public DefaultCatalogUserApi(CatalogService catalogService, TenantUserApi tenantApi, CatalogCache catalogCache, Clock clock, InternalCallContextFactory internalCallContextFactory) {
        this.catalogService = catalogService;
        this.tenantApi = tenantApi;
        this.catalogCache = catalogCache;
        this.clock = clock;
        this.internalCallContextFactory = internalCallContextFactory;
    }

    public VersionedCatalog getCatalog(String catalogName, TenantContext tenantContext) throws CatalogApiException {
        InternalTenantContext internalTenantContext = tenantContext.getAccountId() != null ? this.internalCallContextFactory.createInternalTenantContext(tenantContext.getAccountId(), tenantContext) : this.createInternalTenantContext(tenantContext);
        VersionedCatalog fullCatalog = this.catalogService.getFullCatalog(true, true, internalTenantContext);
        return fullCatalog;
    }

    public StaticCatalog getCurrentCatalog(String catalogName, TenantContext tenantContext) throws CatalogApiException {
        VersionedCatalog fullCatalog = this.getCatalog(catalogName, tenantContext);
        return fullCatalog.getCurrentVersion();
    }

    public void uploadCatalog(String catalogXML, CallContext callContext) throws CatalogApiException {
        InternalTenantContext internalTenantContext = this.createInternalTenantContext((TenantContext)callContext);
        try {
            VersionedCatalog versionedCatalog = this.catalogService.getFullCatalog(false, true, internalTenantContext);
            ByteArrayInputStream stream = new ByteArrayInputStream(catalogXML.getBytes());
            StaticCatalog newCatalogVersion = (StaticCatalog)XMLLoader.getObjectFromStream((InputStream)stream, StandaloneCatalog.class);
            if (versionedCatalog != null) {
                StaticCatalog lastVersion = versionedCatalog.getCurrentVersion();
                if (lastVersion != null && lastVersion.getCatalogName() != null && !newCatalogVersion.getCatalogName().equals(lastVersion.getCatalogName())) {
                    ValidationErrors errors = new ValidationErrors();
                    errors.add(String.format("Catalog name '%s' should match previous catalog name '%s'", newCatalogVersion.getCatalogName(), lastVersion.getCatalogName()), StandaloneCatalog.class, "");
                    this.logger.info("Failed to load new catalog version: " + errors.toString());
                    throw new CatalogApiException(ErrorCode.CAT_INVALID_FOR_TENANT, new Object[]{internalTenantContext.getTenantRecordId()});
                }
                for (StaticCatalog c : versionedCatalog.getVersions()) {
                    if (c.getEffectiveDate().compareTo(newCatalogVersion.getEffectiveDate()) != 0) continue;
                    ValidationErrors errors = new ValidationErrors();
                    errors.add(String.format("Catalog version for effectiveDate '%s' already exists", newCatalogVersion.getEffectiveDate()), StandaloneCatalog.class, "");
                    this.logger.info("Failed to load new catalog version: " + errors.toString());
                    throw new CatalogApiException(ErrorCode.CAT_INVALID_FOR_TENANT, new Object[]{internalTenantContext.getTenantRecordId()});
                }
            }
            this.tenantApi.addTenantKeyValue(TenantKV.TenantKey.CATALOG.toString(), catalogXML, callContext);
            this.catalogCache.clearCatalog(internalTenantContext);
        }
        catch (TenantApiException e) {
            throw new CatalogApiException((BillingExceptionBase)e);
        }
        catch (ValidationException e) {
            throw new CatalogApiException((Throwable)e, ErrorCode.CAT_INVALID_FOR_TENANT, new Object[]{internalTenantContext.getTenantRecordId()});
        }
        catch (JAXBException e) {
            throw new CatalogApiException((Throwable)e, ErrorCode.CAT_INVALID_FOR_TENANT, new Object[]{internalTenantContext.getTenantRecordId()});
        }
        catch (IOException e) {
            throw new IllegalStateException(e);
        }
        catch (TransformerException e) {
            throw new IllegalStateException(e);
        }
        catch (SAXException e) {
            throw new IllegalStateException(e);
        }
    }

    public void createDefaultEmptyCatalog(@Nullable DateTime effectiveDate, CallContext callContext) throws CatalogApiException {
        try {
            InternalTenantContext internalTenantContext = this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId((TenantContext)callContext);
            StandaloneCatalog currentCatalog = this.getCurrentStandaloneCatalogForTenant(internalTenantContext);
            CatalogUpdater catalogUpdater = currentCatalog != null ? new CatalogUpdater(currentCatalog) : new CatalogUpdater(this.getSafeFirstCatalogEffectiveDate(effectiveDate, callContext), null);
            this.tenantApi.updateTenantKeyValue(TenantKV.TenantKey.CATALOG.toString(), catalogUpdater.getCatalogXML(internalTenantContext), callContext);
            this.catalogCache.clearCatalog(internalTenantContext);
        }
        catch (TenantApiException e) {
            throw new CatalogApiException((BillingExceptionBase)e);
        }
    }

    public void addSimplePlan(SimplePlanDescriptor descriptor, @Nullable DateTime effectiveDate, CallContext callContext) throws CatalogApiException {
        try {
            InternalTenantContext internalTenantContext = this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId((TenantContext)callContext);
            StandaloneCatalog currentCatalog = this.getCurrentStandaloneCatalogForTenant(internalTenantContext);
            CatalogUpdater catalogUpdater = currentCatalog != null ? new CatalogUpdater(currentCatalog) : new CatalogUpdater(this.getSafeFirstCatalogEffectiveDate(effectiveDate, callContext), descriptor.getCurrency());
            catalogUpdater.addSimplePlanDescriptor(descriptor);
            this.tenantApi.updateTenantKeyValue(TenantKV.TenantKey.CATALOG.toString(), catalogUpdater.getCatalogXML(internalTenantContext), callContext);
            this.catalogCache.clearCatalog(internalTenantContext);
        }
        catch (TenantApiException e) {
            throw new CatalogApiException((BillingExceptionBase)e);
        }
    }

    public void deleteCatalog(CallContext callContext) throws CatalogApiException {
        InternalTenantContext internalTenantContext = this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId((TenantContext)callContext);
        try {
            this.tenantApi.deleteTenantKey(TenantKV.TenantKey.CATALOG.toString(), callContext);
            this.catalogCache.clearCatalog(internalTenantContext);
            this.createDefaultEmptyCatalog(callContext.getCreatedDate(), callContext);
        }
        catch (TenantApiException e) {
            throw new CatalogApiException((BillingExceptionBase)e);
        }
    }

    private DateTime getSafeFirstCatalogEffectiveDate(@Nullable DateTime input, CallContext callContext) {
        DateTime catalogEffectiveDate = callContext.getCreatedDate().minusDays(1);
        return input == null || input.isAfter((ReadableInstant)catalogEffectiveDate) ? catalogEffectiveDate : input;
    }

    private StandaloneCatalog getCurrentStandaloneCatalogForTenant(InternalTenantContext internalTenantContext) throws CatalogApiException {
        VersionedCatalog versionedCatalog = this.catalogService.getFullCatalog(false, false, internalTenantContext);
        if (versionedCatalog != null) {
            StandaloneCatalog standaloneCatalogWithPriceOverride = (StandaloneCatalog)versionedCatalog.getCurrentVersion();
            return standaloneCatalogWithPriceOverride;
        }
        return null;
    }

    private InternalTenantContext createInternalTenantContext(TenantContext tenantContext) {
        return this.internalCallContextFactory.createInternalTenantContextWithoutAccountRecordId(tenantContext);
    }
}

