/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.TreeSet;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlRootElement;
import org.joda.time.DateTime;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.util.catalog.CatalogDateHelper;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

@XmlRootElement(name="catalogs")
@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultVersionedCatalog
extends ValidatingConfig<DefaultVersionedCatalog>
implements VersionedCatalog,
Externalizable {
    private static final long serialVersionUID = 3181874902672322725L;
    @XmlElementWrapper(name="versions", required=true)
    @XmlElement(name="version", type=StandaloneCatalog.class, required=true)
    private final List<StaticCatalog> versions = new ArrayList<StaticCatalog>();
    @XmlElement(required=true)
    private String catalogName;

    public String getCatalogName() {
        return !this.versions.isEmpty() ? this.versions.get(0).getCatalogName() : null;
    }

    public List<StaticCatalog> getVersions() {
        return this.versions;
    }

    public StaticCatalog getCurrentVersion() {
        return !this.versions.isEmpty() ? this.versions.get(this.versions.size() - 1) : null;
    }

    public StaticCatalog getVersion(Date date) {
        return this.versionForDate(CatalogDateHelper.toUTCDateTime((Date)date));
    }

    private StaticCatalog versionForDate(DateTime date) {
        return this.versions.get(this.indexOfVersionForDate(date.toDate()));
    }

    private int indexOfVersionForDate(Date date) {
        for (int i = this.versions.size() - 1; i >= 0; --i) {
            StaticCatalog c = this.versions.get(i);
            if (c.getEffectiveDate().getTime() > date.getTime()) continue;
            return i;
        }
        if (!this.versions.isEmpty()) {
            return 0;
        }
        throw new IllegalStateException(String.format("No existing versions in the VersionedCatalog catalog for input date %s", date));
    }

    public void add(StandaloneCatalog e) {
        if (this.catalogName == null && e.getCatalogName() != null) {
            this.catalogName = e.getCatalogName();
        }
        this.versions.add(e);
        Collections.sort(this.versions, new Comparator<StaticCatalog>(){

            @Override
            public int compare(StaticCatalog c1, StaticCatalog c2) {
                return c1.getEffectiveDate().compareTo(c2.getEffectiveDate());
            }
        });
    }

    public void initialize(DefaultVersionedCatalog catalog) {
        super.initialize((Object)catalog);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
    }

    public ValidationErrors validate(DefaultVersionedCatalog catalog, ValidationErrors errors) {
        TreeSet<Date> effectiveDates = new TreeSet<Date>();
        for (StaticCatalog c : this.versions) {
            if (effectiveDates.contains(c.getEffectiveDate())) {
                errors.add((Object)new ValidationError(String.format("Catalog effective date '%s' already exists for a previous version", c.getEffectiveDate()), DefaultVersionedCatalog.class, ""));
            } else {
                effectiveDates.add(c.getEffectiveDate());
            }
            if (!c.getCatalogName().equals(this.catalogName)) {
                errors.add((Object)new ValidationError(String.format("Catalog name '%s' is not consistent across versions ", c.getCatalogName()), DefaultVersionedCatalog.class, ""));
            }
            errors.addAll((Collection)((StandaloneCatalog)c).validate((StandaloneCatalog)c, errors));
        }
        this.validateUniformPlanShapeAcrossVersions(errors);
        return errors;
    }

    private void validateUniformPlanShapeAcrossVersions(ValidationErrors errors) {
        for (int i = 0; i < this.versions.size(); ++i) {
            StaticCatalog c = this.versions.get(i);
            for (Plan plan : ((StandaloneCatalog)c).getPlans()) {
                for (int j = i + 1; j < this.versions.size(); ++j) {
                    StaticCatalog next = this.versions.get(j);
                    Plan targetPlan = ((StandaloneCatalog)next).getPlansMap().findByName(plan.getName());
                    if (targetPlan == null) continue;
                    this.validatePlanShape(plan, targetPlan, errors);
                }
            }
        }
    }

    private void validatePlanShape(Plan plan, Plan targetPlan, ValidationErrors errors) {
        if (plan.getAllPhases().length != targetPlan.getAllPhases().length) {
            errors.add((Object)new ValidationError(String.format("Number of phases for plan '%s' differs between version '%s' and '%s'", plan.getName(), plan.getCatalog().getEffectiveDate(), targetPlan.getCatalog().getEffectiveDate()), DefaultVersionedCatalog.class, ""));
            return;
        }
        for (int i = 0; i < plan.getAllPhases().length; ++i) {
            PlanPhase cur = plan.getAllPhases()[i];
            PlanPhase target = targetPlan.getAllPhases()[i];
            if (cur.getName().equals(target.getName())) continue;
            errors.add((Object)new ValidationError(String.format("Phase '%s'for plan '%s' in version '%s' does not exist in version '%s'", cur.getName(), plan.getName(), plan.getCatalog().getEffectiveDate(), targetPlan.getCatalog().getEffectiveDate()), DefaultVersionedCatalog.class, ""));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.catalogName = in.readBoolean() ? in.readUTF() : null;
        this.versions.addAll((Collection)in.readObject());
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeBoolean(this.catalogName != null);
        if (this.catalogName != null) {
            oo.writeUTF(this.catalogName);
        }
        oo.writeObject(this.versions);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DefaultVersionedCatalog that = (DefaultVersionedCatalog)o;
        if (this.versions != null ? !this.versions.equals(that.versions) : that.versions != null) {
            return false;
        }
        return this.catalogName != null ? this.catalogName.equals(that.catalogName) : that.catalogName == null;
    }

    public int hashCode() {
        int result = this.versions != null ? this.versions.hashCode() : 0;
        result = 31 * result + (this.catalogName != null ? this.catalogName.hashCode() : 0);
        return result;
    }
}

