/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultBlock;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultLimit;
import org.killbill.billing.catalog.DefaultTier;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Block;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.Limit;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.Tier;
import org.killbill.billing.catalog.api.TierBlockPolicy;
import org.killbill.billing.catalog.api.TierPriceOverride;
import org.killbill.billing.catalog.api.TieredBlock;
import org.killbill.billing.catalog.api.TieredBlockPriceOverride;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.catalog.api.UsagePriceOverride;
import org.killbill.billing.catalog.api.UsageType;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultUsage
extends ValidatingConfig<StandaloneCatalog>
implements Usage,
Externalizable {
    @XmlAttribute(required=true)
    @XmlID
    private String name;
    @XmlAttribute(required=false)
    private String prettyName;
    @XmlAttribute(required=true)
    private BillingMode billingMode;
    @XmlAttribute(required=true)
    private UsageType usageType;
    @XmlAttribute(required=false)
    private TierBlockPolicy tierBlockPolicy;
    @XmlElement(required=true)
    private BillingPeriod billingPeriod;
    @XmlElementWrapper(name="limits", required=false)
    @XmlElement(name="limit", required=false)
    private DefaultLimit[] limits;
    @XmlElementWrapper(name="blocks", required=false)
    @XmlElement(name="block", required=false)
    private DefaultBlock[] blocks;
    @XmlElementWrapper(name="tiers", required=false)
    @XmlElement(name="tier", required=false)
    private DefaultTier[] tiers;
    @XmlElement(required=false)
    private DefaultInternationalPrice fixedPrice;
    @XmlElement(required=false)
    private DefaultInternationalPrice recurringPrice;
    private PlanPhase phase;

    public DefaultUsage() {
    }

    public StaticCatalog getCatalog() {
        return (StaticCatalog)this.root;
    }

    public DefaultUsage(Usage in, UsagePriceOverride override, Currency currency) {
        this.name = in.getName();
        this.usageType = in.getUsageType();
        this.tierBlockPolicy = in.getTierBlockPolicy();
        this.billingPeriod = in.getBillingPeriod();
        this.billingMode = in.getBillingMode();
        this.limits = (DefaultLimit[])in.getLimits();
        this.blocks = (DefaultBlock[])in.getBlocks();
        this.tiers = new DefaultTier[in.getTiers().length];
        for (int i = 0; i < in.getTiers().length; ++i) {
            if (override != null && override.getTierPriceOverrides() != null) {
                final TieredBlock[] curTieredBlocks = in.getTiers()[i].getTieredBlocks();
                TierPriceOverride overriddenTier = (TierPriceOverride)Iterables.tryFind((Iterable)override.getTierPriceOverrides(), (Predicate)new Predicate<TierPriceOverride>(){

                    public boolean apply(TierPriceOverride input) {
                        if (input != null) {
                            List blockPriceOverrides = input.getTieredBlockPriceOverrides();
                            for (TieredBlockPriceOverride blockDef : blockPriceOverrides) {
                                String unitName = blockDef.getUnitName();
                                Double max = blockDef.getMax();
                                Double size = blockDef.getSize();
                                for (TieredBlock curTieredBlock : curTieredBlocks) {
                                    if (!unitName.equals(curTieredBlock.getUnit().getName()) || Double.compare(size, curTieredBlock.getSize()) != 0 || Double.compare(max, curTieredBlock.getMax()) != 0) continue;
                                    return true;
                                }
                            }
                        }
                        return false;
                    }
                }).orNull();
                this.tiers[i] = overriddenTier != null ? new DefaultTier(in.getTiers()[i], overriddenTier, currency) : (DefaultTier)in.getTiers()[i];
                continue;
            }
            this.tiers[i] = (DefaultTier)in.getTiers()[i];
        }
    }

    public String getName() {
        return this.name;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public BillingMode getBillingMode() {
        return this.billingMode;
    }

    public UsageType getUsageType() {
        return this.usageType;
    }

    public TierBlockPolicy getTierBlockPolicy() {
        return this.tierBlockPolicy;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public boolean compliesWithLimits(String unit, double value) {
        Limit limit = this.findLimit(unit);
        return limit == null || limit.compliesWith(value);
    }

    public Limit[] getLimits() {
        return this.limits;
    }

    public Tier[] getTiers() {
        return this.tiers;
    }

    public Block[] getBlocks() {
        return this.blocks;
    }

    public InternationalPrice getFixedPrice() {
        return this.fixedPrice;
    }

    public InternationalPrice getRecurringPrice() {
        return this.recurringPrice;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.billingMode == BillingMode.IN_ADVANCE && this.usageType == UsageType.CAPACITY && this.limits.length == 0) {
            errors.add((Object)new ValidationError(String.format("Usage [IN_ADVANCE CAPACITY] section of phase %s needs to define some limits", this.phase.toString()), DefaultUsage.class, ""));
        }
        if (this.billingMode == BillingMode.IN_ADVANCE && this.usageType == UsageType.CONSUMABLE && this.blocks.length == 0) {
            errors.add((Object)new ValidationError(String.format("Usage [IN_ADVANCE CONSUMABLE] section of phase %s needs to define some blocks", this.phase.toString()), DefaultUsage.class, ""));
        }
        if (this.billingMode == BillingMode.IN_ARREAR && this.tiers.length == 0) {
            errors.add((Object)new ValidationError(String.format("Usage [IN_ARREAR] section of phase %s needs to define some tiers", this.phase.toString()), DefaultUsage.class, ""));
        }
        this.validateCollection(catalog, errors, this.limits);
        this.validateCollection(catalog, errors, this.tiers);
        return errors;
    }

    public void initialize(StandaloneCatalog root) {
        super.initialize((Object)root);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
        if (this.prettyName == null) {
            this.prettyName = this.name;
        }
        for (DefaultLimit defaultLimit : this.limits) {
            defaultLimit.initialize(root);
        }
        for (ValidatingConfig validatingConfig : this.blocks) {
            validatingConfig.initialize(root);
            validatingConfig.setPhase(this.phase);
        }
        for (ValidatingConfig validatingConfig : this.tiers) {
            validatingConfig.initialize(root);
            validatingConfig.setPhase(this.phase);
        }
    }

    public DefaultUsage setBillingPeriod(BillingPeriod billingPeriod) {
        this.billingPeriod = billingPeriod;
        return this;
    }

    public DefaultUsage setName(String name) {
        this.name = name;
        return this;
    }

    public DefaultUsage setBillingMode(BillingMode billingMode) {
        this.billingMode = billingMode;
        return this;
    }

    public DefaultUsage setUsageType(UsageType usageType) {
        this.usageType = usageType;
        return this;
    }

    public DefaultUsage setTierBlockPolicy(TierBlockPolicy tierBlockPolicy) {
        this.tierBlockPolicy = tierBlockPolicy;
        return this;
    }

    public DefaultUsage setPhase(PlanPhase phase) {
        this.phase = phase;
        return this;
    }

    public DefaultUsage setTiers(DefaultTier[] tiers) {
        this.tiers = tiers;
        return this;
    }

    public DefaultUsage setBlocks(DefaultBlock[] blocks) {
        this.blocks = blocks;
        return this;
    }

    public DefaultUsage setLimits(DefaultLimit[] limits) {
        this.limits = limits;
        return this;
    }

    public DefaultUsage setFixedPrice(DefaultInternationalPrice fixedPrice) {
        this.fixedPrice = fixedPrice;
        return this;
    }

    public DefaultUsage setRecurringPrice(DefaultInternationalPrice recurringPrice) {
        this.recurringPrice = recurringPrice;
        return this;
    }

    protected Limit findLimit(String unit) {
        for (DefaultLimit limit : this.limits) {
            if (!limit.getUnit().getName().equals(unit)) continue;
            return limit;
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultUsage)) {
            return false;
        }
        DefaultUsage that = (DefaultUsage)o;
        if (this.billingMode != that.billingMode) {
            return false;
        }
        if (this.billingPeriod != that.billingPeriod) {
            return false;
        }
        if (this.fixedPrice != null ? !this.fixedPrice.equals(that.fixedPrice) : that.fixedPrice != null) {
            return false;
        }
        if (!Arrays.equals(this.limits, that.limits)) {
            return false;
        }
        if (this.name != null ? !this.name.equals(that.name) : that.name != null) {
            return false;
        }
        if (this.prettyName != null ? !this.prettyName.equals(that.prettyName) : that.prettyName != null) {
            return false;
        }
        if (this.recurringPrice != null ? !this.recurringPrice.equals(that.recurringPrice) : that.recurringPrice != null) {
            return false;
        }
        if (!Arrays.equals(this.blocks, that.blocks)) {
            return false;
        }
        if (!Arrays.equals(this.tiers, that.tiers)) {
            return false;
        }
        if (this.usageType != that.usageType) {
            return false;
        }
        return this.tierBlockPolicy == that.tierBlockPolicy;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.prettyName != null ? this.prettyName.hashCode() : 0);
        result = 31 * result + (this.billingMode != null ? this.billingMode.hashCode() : 0);
        result = 31 * result + (this.usageType != null ? this.usageType.hashCode() : 0);
        result = 31 * result + (this.tierBlockPolicy != null ? this.tierBlockPolicy.hashCode() : 0);
        result = 31 * result + (this.billingPeriod != null ? this.billingPeriod.hashCode() : 0);
        result = 31 * result + (this.limits != null ? Arrays.hashCode(this.limits) : 0);
        result = 31 * result + (this.blocks != null ? Arrays.hashCode(this.blocks) : 0);
        result = 31 * result + (this.tiers != null ? Arrays.hashCode(this.tiers) : 0);
        result = 31 * result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
        result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.name);
        out.writeUTF(this.prettyName);
        out.writeBoolean(this.billingMode != null);
        if (this.billingMode != null) {
            out.writeUTF(this.billingMode.name());
        }
        out.writeBoolean(this.usageType != null);
        if (this.usageType != null) {
            out.writeUTF(this.usageType.name());
        }
        out.writeBoolean(this.tierBlockPolicy != null);
        if (this.tierBlockPolicy != null) {
            out.writeUTF(this.tierBlockPolicy.name());
        }
        out.writeBoolean(this.billingPeriod != null);
        if (this.billingPeriod != null) {
            out.writeUTF(this.billingPeriod.name());
        }
        out.writeObject(this.limits);
        out.writeObject(this.blocks);
        out.writeObject(this.tiers);
        out.writeObject(this.fixedPrice);
        out.writeObject(this.recurringPrice);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.name = in.readUTF();
        this.prettyName = in.readUTF();
        this.billingMode = in.readBoolean() ? BillingMode.valueOf((String)in.readUTF()) : null;
        this.usageType = in.readBoolean() ? UsageType.valueOf((String)in.readUTF()) : null;
        this.tierBlockPolicy = in.readBoolean() ? TierBlockPolicy.valueOf((String)in.readUTF()) : null;
        this.billingPeriod = in.readBoolean() ? BillingPeriod.valueOf((String)in.readUTF()) : null;
        this.limits = (DefaultLimit[])in.readObject();
        this.blocks = (DefaultBlock[])in.readObject();
        this.tiers = (DefaultTier[])in.readObject();
        this.fixedPrice = (DefaultInternationalPrice)in.readObject();
        this.recurringPrice = (DefaultInternationalPrice)in.readObject();
    }
}

