/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.catalog.DefaultBlock;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.api.BlockType;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.TieredBlock;
import org.killbill.billing.catalog.api.TieredBlockPriceOverride;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultTieredBlock
extends DefaultBlock
implements TieredBlock,
Externalizable {
    @XmlElement(required=true)
    private double max;

    public Double getMax() {
        return this.max;
    }

    public DefaultTieredBlock setMax(double max) {
        this.max = max;
        return this;
    }

    public DefaultTieredBlock() {
        this.setType(BlockType.TIERED);
    }

    public DefaultTieredBlock(TieredBlock in, TieredBlockPriceOverride override, Currency currency) {
        super((DefaultUnit)in.getUnit(), in.getSize(), (DefaultInternationalPrice)in.getPrice(), override.getPrice(), currency);
        this.max = in.getMax();
        this.setType(BlockType.TIERED);
    }

    @Override
    public BlockType getType() {
        return BlockType.TIERED;
    }

    @Override
    public DefaultTieredBlock setType(BlockType type) {
        super.setType(BlockType.TIERED);
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultTieredBlock that = (DefaultTieredBlock)o;
        return Double.compare(that.max, this.max) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        long temp = Double.doubleToLongBits(this.max);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeDouble(this.max);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.max = in.readDouble();
    }
}

