/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultRecurring
extends ValidatingConfig<StandaloneCatalog>
implements Recurring,
Externalizable {
    @XmlElement(required=true)
    private BillingPeriod billingPeriod;
    @XmlElement(required=false)
    private DefaultInternationalPrice recurringPrice;
    private String planName;
    private PhaseType phaseType;

    public DefaultRecurring() {
    }

    public DefaultRecurring(DefaultRecurring in, PlanPhasePriceOverride override) {
        this.billingPeriod = in.getBillingPeriod();
        this.recurringPrice = in.getRecurringPrice() != null ? new DefaultInternationalPrice(in.getRecurringPrice(), override, false) : null;
    }

    public BillingPeriod getBillingPeriod() {
        return this.billingPeriod;
    }

    public DefaultInternationalPrice getRecurringPrice() {
        return this.recurringPrice;
    }

    public void initialize(StandaloneCatalog root) {
        super.initialize((Object)root);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
        if (this.recurringPrice != null) {
            this.recurringPrice.initialize(root);
        }
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.planName == null) {
            errors.add((Object)new ValidationError("Invalid plan for recurring section", DefaultRecurring.class, ""));
        }
        if (this.phaseType == null) {
            errors.add((Object)new ValidationError("Invalid phase for recurring section", DefaultPlan.class, this.planName));
        }
        if (this.billingPeriod == null) {
            errors.add((Object)new ValidationError(String.format("Recurring section of Phase %s of plan %s has a recurring price but no billing period", this.phaseType.toString(), this.planName), DefaultPlanPhase.class, this.phaseType.toString()));
        }
        if (this.recurringPrice != null && (this.billingPeriod == null || this.billingPeriod == BillingPeriod.NO_BILLING_PERIOD)) {
            errors.add((Object)new ValidationError(String.format("Recurring section of Phase %s of plan %s has a recurring price but no billing period", this.phaseType.toString(), this.planName), DefaultPlanPhase.class, this.phaseType.toString()));
        }
        if (this.recurringPrice == null && this.billingPeriod != BillingPeriod.NO_BILLING_PERIOD) {
            errors.add((Object)new ValidationError(String.format("Recurring section of Phase %s of plan %s has no recurring price but does have a billing period. The billing period should be set to '%s'", this.phaseType.toString(), this.planName, BillingPeriod.NO_BILLING_PERIOD), DefaultPlanPhase.class, this.phaseType.toString()));
        }
        return errors;
    }

    public DefaultRecurring setBillingPeriod(BillingPeriod billingPeriod) {
        this.billingPeriod = billingPeriod;
        return this;
    }

    public DefaultRecurring setRecurringPrice(DefaultInternationalPrice recurringPrice) {
        this.recurringPrice = recurringPrice;
        return this;
    }

    public DefaultRecurring setPlan(String planName) {
        this.planName = planName;
        return this;
    }

    public DefaultRecurring setPhase(PlanPhase phase) {
        this.phaseType = phase.getPhaseType();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultRecurring)) {
            return false;
        }
        DefaultRecurring that = (DefaultRecurring)o;
        if (this.billingPeriod != that.billingPeriod) {
            return false;
        }
        return !(this.recurringPrice != null ? !this.recurringPrice.equals(that.recurringPrice) : that.recurringPrice != null);
    }

    public int hashCode() {
        int result = this.billingPeriod != null ? this.billingPeriod.hashCode() : 0;
        result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.billingPeriod != null);
        if (this.billingPeriod != null) {
            out.writeUTF(this.billingPeriod.name());
        }
        out.writeObject(this.recurringPrice);
        out.writeUTF(this.planName);
        out.writeBoolean(this.phaseType != null);
        if (this.phaseType != null) {
            out.writeUTF(this.phaseType.name());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.billingPeriod = in.readBoolean() ? BillingPeriod.valueOf((String)in.readUTF()) : null;
        this.recurringPrice = (DefaultInternationalPrice)in.readObject();
        this.planName = in.readUTF();
        this.phaseType = in.readBoolean() ? PhaseType.valueOf((String)in.readUTF()) : null;
    }
}

