/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.annotation.Nullable;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultDuration;
import org.killbill.billing.catalog.DefaultFixed;
import org.killbill.billing.catalog.DefaultRecurring;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Duration;
import org.killbill.billing.catalog.api.Fixed;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.Recurring;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.catalog.api.UsagePriceOverride;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultPlanPhase
extends ValidatingConfig<StandaloneCatalog>
implements PlanPhase,
Externalizable {
    @XmlAttribute(required=false)
    private String prettyName;
    @XmlAttribute(required=true)
    private PhaseType type;
    @XmlElement(required=true)
    private DefaultDuration duration;
    @XmlElement(required=false)
    private DefaultFixed fixed;
    @XmlElement(required=false)
    private DefaultRecurring recurring;
    @XmlElementWrapper(name="usages", required=false)
    @XmlElement(name="usage", required=false)
    private DefaultUsage[] usages;
    private String planName;
    private Product product;

    public DefaultPlanPhase() {
        this.usages = new DefaultUsage[0];
    }

    public DefaultPlanPhase(Plan parentPlan, DefaultPlanPhase in, @Nullable PlanPhasePriceOverride override) {
        this.type = in.getPhaseType();
        this.duration = (DefaultDuration)in.getDuration();
        this.fixed = override != null && override.getFixedPrice() != null ? new DefaultFixed((DefaultFixed)in.getFixed(), override) : (DefaultFixed)in.getFixed();
        this.recurring = override != null && override.getRecurringPrice() != null ? new DefaultRecurring((DefaultRecurring)in.getRecurring(), override) : (DefaultRecurring)in.getRecurring();
        this.usages = new DefaultUsage[in.getUsages().length];
        for (int i = 0; i < in.getUsages().length; ++i) {
            UsagePriceOverride usagePriceOverride;
            final Usage curUsage = in.getUsages()[i];
            this.usages[i] = override != null && override.getUsagePriceOverrides() != null ? ((usagePriceOverride = (UsagePriceOverride)Iterables.tryFind((Iterable)override.getUsagePriceOverrides(), (Predicate)new Predicate<UsagePriceOverride>(){

                public boolean apply(UsagePriceOverride input) {
                    return input != null && input.getName().equals(curUsage.getName());
                }
            }).orNull()) != null ? new DefaultUsage(in.getUsages()[i], usagePriceOverride, override.getCurrency()) : (DefaultUsage)curUsage) : (DefaultUsage)curUsage;
        }
        this.planName = parentPlan.getName();
        this.product = parentPlan.getProduct();
    }

    public static String phaseName(String planName, PhaseType phasetype) {
        return planName + "-" + phasetype.toString().toLowerCase();
    }

    public static String planName(String phaseName) throws CatalogApiException {
        for (PhaseType type : PhaseType.values()) {
            if (!phaseName.endsWith(type.toString().toLowerCase())) continue;
            return phaseName.substring(0, phaseName.length() - type.toString().length() - 1);
        }
        throw new CatalogApiException(ErrorCode.CAT_BAD_PHASE_NAME, new Object[]{phaseName});
    }

    public StaticCatalog getCatalog() {
        return (StaticCatalog)this.root;
    }

    public PhaseType getPhaseType() {
        return this.type;
    }

    public boolean compliesWithLimits(String unit, double value) {
        for (DefaultUsage usage : this.usages) {
            if (usage.compliesWithLimits(unit, value)) continue;
            return false;
        }
        return this.product.compliesWithLimits(unit, value);
    }

    public Fixed getFixed() {
        return this.fixed;
    }

    public Recurring getRecurring() {
        return this.recurring;
    }

    public Usage[] getUsages() {
        return this.usages;
    }

    public String getName() {
        return DefaultPlanPhase.phaseName(this.planName, this.getPhaseType());
    }

    public String getPrettyName() {
        return this.prettyName != null ? this.prettyName : this.getName();
    }

    public Duration getDuration() {
        return this.duration;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.planName == null) {
            errors.add((Object)new ValidationError(String.format("Invalid plan for phase '%s'", this.type), DefaultPlanPhase.class, ""));
        }
        if (this.fixed == null && this.recurring == null && this.usages.length == 0) {
            errors.add((Object)new ValidationError(String.format("Phase %s of plan %s need to define at least either a fixed or recurrring or usage section.", this.type.toString(), this.planName), DefaultPlanPhase.class, this.type.toString()));
        }
        if (this.fixed != null) {
            this.fixed.validate(catalog, errors);
        }
        if (this.recurring != null) {
            this.recurring.validate(catalog, errors);
        }
        this.duration.validate(catalog, errors);
        this.validateCollection(catalog, errors, this.usages);
        return errors;
    }

    public void initialize(StandaloneCatalog root) {
        super.initialize((Object)root);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
        if (this.fixed != null) {
            this.fixed.initialize(root);
        }
        if (this.recurring != null) {
            this.recurring.initialize(root);
            this.recurring.setPlan(this.planName);
            this.recurring.setPhase(this);
        }
        for (DefaultUsage usage : this.usages) {
            usage.initialize(root);
            usage.setPhase(this);
        }
        this.duration.initialize(root);
    }

    public DefaultPlanPhase setPrettyName(String prettyName) {
        this.prettyName = prettyName;
        return this;
    }

    public DefaultPlanPhase setFixed(DefaultFixed fixed) {
        this.fixed = fixed;
        return this;
    }

    public DefaultPlanPhase setRecurring(DefaultRecurring recurring) {
        this.recurring = recurring;
        return this;
    }

    public DefaultPlanPhase setUsages(DefaultUsage[] usages) {
        this.usages = usages;
        return this;
    }

    public DefaultPlanPhase setPhaseType(PhaseType cohort) {
        this.type = cohort;
        return this;
    }

    public DefaultPlanPhase setDuration(DefaultDuration duration) {
        this.duration = duration;
        return this;
    }

    public DefaultPlanPhase setPlan(Plan plan) {
        this.planName = plan.getName();
        this.product = plan.getProduct();
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPlanPhase)) {
            return false;
        }
        DefaultPlanPhase that = (DefaultPlanPhase)o;
        if (this.duration != null ? !this.duration.equals(that.duration) : that.duration != null) {
            return false;
        }
        if (this.fixed != null ? !this.fixed.equals(that.fixed) : that.fixed != null) {
            return false;
        }
        if (this.recurring != null ? !this.recurring.equals(that.recurring) : that.recurring != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return Arrays.equals(this.usages, that.usages);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.duration != null ? this.duration.hashCode() : 0);
        result = 31 * result + (this.fixed != null ? this.fixed.hashCode() : 0);
        result = 31 * result + (this.recurring != null ? this.recurring.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("DefaultPlanPhase{");
        sb.append("type=").append(this.type);
        sb.append(", duration=").append(this.duration);
        sb.append(", fixed=").append(this.fixed);
        sb.append(", recurring=").append(this.recurring);
        sb.append(", usages=").append(Arrays.toString(this.usages));
        sb.append(", plan=").append(this.planName);
        sb.append('}');
        return sb.toString();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.prettyName != null);
        if (this.prettyName != null) {
            out.writeUTF(this.prettyName);
        }
        out.writeBoolean(this.type != null);
        if (this.type != null) {
            out.writeUTF(this.type.name());
        }
        out.writeObject(this.duration);
        out.writeObject(this.fixed);
        out.writeObject(this.recurring);
        out.writeObject(this.usages);
        out.writeUTF(this.planName);
        out.writeObject(this.product);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prettyName = in.readBoolean() ? in.readUTF() : null;
        this.type = in.readBoolean() ? PhaseType.valueOf((String)in.readUTF()) : null;
        this.duration = (DefaultDuration)in.readObject();
        this.fixed = (DefaultFixed)in.readObject();
        this.recurring = (DefaultRecurring)in.readObject();
        this.usages = (DefaultUsage[])in.readObject();
        this.planName = in.readUTF();
        this.product = (Product)in.readObject();
    }
}

