/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.lang.reflect.Array;
import java.util.Date;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultPriceListSet;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogEntity;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.MutableStaticCatalog;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.Price;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.rules.DefaultPlanRules;

public class DefaultMutableStaticCatalog
extends StandaloneCatalog
implements MutableStaticCatalog {
    public DefaultMutableStaticCatalog() {
    }

    public DefaultMutableStaticCatalog(Date effectiveDate) {
        super(effectiveDate);
    }

    public DefaultMutableStaticCatalog(StandaloneCatalog input) {
        this.setCatalogName(input.getCatalogName()).setRecurringBillingMode(input.getRecurringBillingMode()).setEffectiveDate(input.getEffectiveDate()).setSupportedCurrencies(input.getSupportedCurrencies()).setUnits((DefaultUnit[])input.getUnits()).setProducts(input.getProducts()).setPlans(input.getPlans()).setPlanRules((DefaultPlanRules)input.getPlanRules()).setPriceLists(input.getPriceLists());
        this.initialize(this);
    }

    public void addCurrency(Currency currency) {
        Currency[] newEntries = this.allocateNewEntries(this.getSupportedCurrencies(), currency);
        this.setSupportedCurrencies(newEntries);
    }

    public void addProduct(Product product) {
        this.getCatalogEntityCollectionProduct().add(product);
    }

    public void addPlan(Plan plan) {
        this.getPlansMap().add(plan);
        DefaultPriceList priceList = (DefaultPriceList)plan.getPriceList();
        priceList.getCatalogEntityCollectionPlan().add(plan);
    }

    public void addPriceList(PriceList priceList) {
        PriceList[] newEntries = this.allocateNewEntries(this.getPriceLists().getChildPriceLists(), priceList);
        DefaultPriceListSet priceListSet = new DefaultPriceListSet(this.getPriceLists().getDefaultPricelist(), (DefaultPriceList[])newEntries);
        this.setPriceLists(priceListSet);
    }

    public void addRecurringPriceToPlan(DefaultInternationalPrice currentPrices, Price newPrice) {
        Price[] newEntries = this.allocateNewEntries(currentPrices.getPrices(), newPrice);
        currentPrices.setPrices((DefaultPrice[])newEntries);
    }

    public void addProductAvailableAO(Product targetBasePlan, DefaultProduct aoProduct) {
        ((DefaultProduct)targetBasePlan).getCatalogEntityCollectionAvailable().add(aoProduct);
    }

    private <T> T[] allocateNewEntries(T[] existingEntries, T newEntry) {
        if (existingEntries != null) {
            for (T input : existingEntries) {
                boolean found;
                if (input instanceof CatalogEntity) {
                    found = ((CatalogEntity)input).getName().equals(((CatalogEntity)newEntry).getName());
                } else if (input instanceof Enum) {
                    found = ((Enum)input).name().equals(((Enum)newEntry).name());
                } else if (input instanceof Price) {
                    found = ((Price)input).getCurrency().equals((Object)((Price)newEntry).getCurrency());
                } else {
                    throw new IllegalStateException("Unexpected type " + newEntry.getClass());
                }
                if (!found) continue;
                throw new IllegalStateException("Already existing " + newEntry);
            }
        }
        int length = existingEntries != null ? existingEntries.length : 0;
        Object[] newEntries = (Object[])Array.newInstance(newEntry.getClass(), length + 1);
        for (int i = 0; i < newEntries.length + 1; ++i) {
            if (i < newEntries.length - 1) {
                newEntries[i] = existingEntries[i];
                continue;
            }
            newEntries[newEntries.length - 1] = newEntry;
        }
        return newEntries;
    }
}

