/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.killbill.billing.catalog.api.BlockType;
import org.killbill.billing.catalog.api.FixedType;
import org.killbill.billing.catalog.api.TierBlockPolicy;

public class CatalogSafetyInitializer {
    public static final Integer DEFAULT_NON_REQUIRED_INTEGER_FIELD_VALUE = -1;
    public static final Double DEFAULT_NON_REQUIRED_DOUBLE_FIELD_VALUE = -1.0;
    private static final Map<Class, LinkedList<Field>> perCatalogClassNonRequiredFields = new HashMap<Class, LinkedList<Field>>();

    public static void initializeNonRequiredNullFieldsWithDefaultValue(Object obj) {
        LinkedList<Field> fields = perCatalogClassNonRequiredFields.get(obj.getClass());
        if (fields == null) {
            fields = CatalogSafetyInitializer.initializeNonRequiredFields(obj.getClass());
            perCatalogClassNonRequiredFields.put(obj.getClass(), fields);
        }
        try {
            for (Field f : fields) {
                if (f.getType().isArray()) {
                    CatalogSafetyInitializer.initializeArrayIfNull(obj, f);
                    continue;
                }
                if (f.getType().isPrimitive()) continue;
                if (f.getType().isEnum()) {
                    if (FixedType.class.equals(f.getType())) {
                        CatalogSafetyInitializer.initializeFieldWithValue(obj, f, FixedType.ONE_TIME);
                        continue;
                    }
                    if (BlockType.class.equals(f.getType())) {
                        CatalogSafetyInitializer.initializeFieldWithValue(obj, f, BlockType.VANILLA);
                        continue;
                    }
                    if (!TierBlockPolicy.class.equals(f.getType())) continue;
                    CatalogSafetyInitializer.initializeFieldWithValue(obj, f, TierBlockPolicy.ALL_TIERS);
                    continue;
                }
                if (Integer.class.equals(f.getType())) {
                    CatalogSafetyInitializer.initializeFieldWithValue(obj, f, DEFAULT_NON_REQUIRED_INTEGER_FIELD_VALUE);
                    continue;
                }
                if (!Double.class.equals(f.getType())) continue;
                CatalogSafetyInitializer.initializeFieldWithValue(obj, f, DEFAULT_NON_REQUIRED_DOUBLE_FIELD_VALUE);
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Failed during catalog initialization : ", e);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Failed during catalog initialization : ", e);
        }
    }

    private static LinkedList<Field> initializeNonRequiredFields(Class<?> aClass) {
        Field[] fields;
        LinkedList<Field> result = new LinkedList<Field>();
        for (Field f : fields = aClass.getDeclaredFields()) {
            if (f.getType().isArray()) {
                XmlElementWrapper xmlElementWrapper = f.getAnnotation(XmlElementWrapper.class);
                if (xmlElementWrapper != null) {
                    if (xmlElementWrapper.required()) continue;
                    result.add(f);
                    continue;
                }
                XmlElement xmlElement = f.getAnnotation(XmlElement.class);
                if (xmlElement == null || xmlElement.required()) continue;
                result.add(f);
                continue;
            }
            if (f.getType().isPrimitive()) continue;
            if (f.getType().isEnum()) {
                if (FixedType.class.equals(f.getType())) {
                    result.add(f);
                    continue;
                }
                if (BlockType.class.equals(f.getType())) {
                    result.add(f);
                    continue;
                }
                if (!TierBlockPolicy.class.equals(f.getType())) continue;
                result.add(f);
                continue;
            }
            if (Integer.class.equals(f.getType())) {
                result.add(f);
                continue;
            }
            if (!Double.class.equals(f.getType())) continue;
            result.add(f);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeFieldWithValue(Object obj, Field f, Object value) throws IllegalAccessException, ClassNotFoundException {
        Map<Class, LinkedList<Field>> map = perCatalogClassNonRequiredFields;
        synchronized (map) {
            f.setAccessible(true);
            if (f.get(obj) == null) {
                f.set(obj, value);
            }
            f.setAccessible(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void initializeArrayIfNull(Object obj, Field f) throws IllegalAccessException, ClassNotFoundException {
        Map<Class, LinkedList<Field>> map = perCatalogClassNonRequiredFields;
        synchronized (map) {
            f.setAccessible(true);
            if (f.get(obj) == null) {
                f.set(obj, CatalogSafetyInitializer.getZeroLengthArrayInitializer(f));
            }
            f.setAccessible(false);
        }
    }

    private static Object[] getZeroLengthArrayInitializer(Field f) throws ClassNotFoundException {
        String arrayClassName = f.getType().getCanonicalName();
        Class<?> type = Class.forName(arrayClassName.substring(0, arrayClassName.length() - 2));
        return (Object[])Array.newInstance(type, 0);
    }
}

