/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.collect.Ordering;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import org.killbill.billing.catalog.api.CatalogEntity;

public class CatalogEntityCollection<T extends CatalogEntity>
implements Collection<T>,
Externalizable {
    private final Map<String, T> data = new TreeMap<String, T>((Comparator<String>)Ordering.natural());

    public CatalogEntityCollection() {
    }

    public CatalogEntityCollection(T[] entities) {
        for (T cur : entities) {
            this.addEntry(cur);
        }
    }

    public CatalogEntityCollection(Iterable<T> entities) {
        for (CatalogEntity cur : entities) {
            this.addEntry(cur);
        }
    }

    public T findByName(String entryName) {
        return (T)((CatalogEntity)this.data.get(entryName));
    }

    public Collection<T> getEntries() {
        return this.data.values();
    }

    @Override
    public int size() {
        return this.data.size();
    }

    @Override
    public boolean isEmpty() {
        return this.data.isEmpty();
    }

    @Override
    public boolean contains(Object o) {
        return this.data.containsKey(((CatalogEntity)o).getName());
    }

    @Override
    public Iterator iterator() {
        final Iterator<String> keyIterator = this.data.keySet().iterator();
        Iterator it = new Iterator(){
            private String prevKey = null;

            @Override
            public boolean hasNext() {
                return keyIterator.hasNext();
            }

            public Object next() {
                this.prevKey = (String)keyIterator.next();
                return CatalogEntityCollection.this.data.get(this.prevKey);
            }

            @Override
            public void remove() {
                if (this.prevKey != null) {
                    keyIterator.remove();
                    CatalogEntityCollection.this.data.remove(this.prevKey);
                }
            }
        };
        return it;
    }

    @Override
    public boolean add(T t) {
        this.addEntry(t);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeEntry((CatalogEntity)o);
    }

    @Override
    public boolean addAll(Collection c) {
        for (CatalogEntity cur : c) {
            this.addEntry(cur);
        }
        return true;
    }

    @Override
    public void clear() {
        this.data.clear();
    }

    @Override
    public boolean retainAll(Collection c) {
        throw new IllegalStateException("Not implemented");
    }

    @Override
    public boolean removeAll(Collection c) {
        for (CatalogEntity cur : c) {
            this.data.remove(cur.getName());
        }
        return true;
    }

    @Override
    public boolean containsAll(Collection c) {
        for (CatalogEntity cur : c) {
            if (this.data.containsKey(cur.getName())) continue;
            return false;
        }
        return true;
    }

    @Override
    public Object[] toArray(Object[] a) {
        return this.data.values().toArray(a);
    }

    @Override
    public Object[] toArray() {
        return this.data.values().toArray(new Object[this.data.size()]);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CatalogEntityCollection)) {
            return false;
        }
        CatalogEntityCollection that = (CatalogEntityCollection)o;
        return this.data != null ? this.data.equals(that.data) : that.data == null;
    }

    @Override
    public int hashCode() {
        return this.data != null ? this.data.hashCode() : 0;
    }

    private void addEntry(T entry) {
        this.data.put(entry.getName(), entry);
    }

    private boolean removeEntry(T entry) {
        return this.data.remove(entry.getName()) != null;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.data.putAll((Map)in.readObject());
    }

    @Override
    public void writeExternal(ObjectOutput oo) throws IOException {
        oo.writeObject(this.data);
    }
}

