/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.rules;

import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.MockCatalog;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.rules.DefaultCase;
import org.killbill.billing.catalog.rules.Result;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCase
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testBasic() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = (DefaultPriceList)cat.findPriceList("DEFAULT");
        DefaultCaseResult cr = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.MONTHLY, priceList, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), cat);
        this.assertionException(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", cat);
    }

    @Test(groups={"fast"})
    public void testWildCardProduct() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = (DefaultPriceList)cat.findPriceList("DEFAULT");
        DefaultCaseResult cr = new DefaultCaseResult(null, ProductCategory.BASE, BillingPeriod.MONTHLY, priceList, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertion(Result.FOO, cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), cat);
        this.assertionException(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", cat);
    }

    @Test(groups={"fast"})
    public void testWildCardProductCategory() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = (DefaultPriceList)cat.findPriceList("DEFAULT");
        DefaultCaseResult cr = new DefaultCaseResult(product, null, BillingPeriod.MONTHLY, priceList, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.ADD_ON, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), cat);
        this.assertionException(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", cat);
    }

    @Test(groups={"fast"})
    public void testWildCardBillingPeriod() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = (DefaultPriceList)cat.findPriceList("DEFAULT");
        DefaultCaseResult cr = new DefaultCaseResult(product, ProductCategory.BASE, null, priceList, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), cat);
        this.assertionException(cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", cat);
    }

    @Test(groups={"fast"})
    public void testWildCardPriceList() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = (DefaultPriceList)cat.findPriceList("DEFAULT");
        DefaultCaseResult cr = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.MONTHLY, null, Result.FOO);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, priceList.getName(), cat);
        this.assertionNull(cr, product.getName(), ProductCategory.BASE, BillingPeriod.ANNUAL, priceList.getName(), cat);
        this.assertion(Result.FOO, cr, product.getName(), ProductCategory.BASE, BillingPeriod.MONTHLY, "dipsy", cat);
    }

    @Test
    public void testCaseOrder() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product = cat.getCurrentProduct(0);
        DefaultPriceList priceList = (DefaultPriceList)cat.findPriceList("DEFAULT");
        DefaultCaseResult cr0 = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.MONTHLY, priceList, Result.FOO);
        DefaultCaseResult cr1 = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.MONTHLY, priceList, Result.BAR);
        DefaultCaseResult cr2 = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.ANNUAL, priceList, Result.DIPSY);
        DefaultCaseResult cr3 = new DefaultCaseResult(product, ProductCategory.BASE, BillingPeriod.ANNUAL, priceList, Result.LALA);
        Result r1 = (Result)((Object)DefaultCase.getResult((DefaultCase[])new DefaultCaseResult[]{cr0, cr1, cr2, cr3}, (PlanSpecifier)new PlanSpecifier(product.getName(), BillingPeriod.MONTHLY, priceList.getName()), (StaticCatalog)cat));
        Assert.assertEquals((Object)((Object)r1), (Object)((Object)Result.FOO));
        Result r2 = (Result)((Object)DefaultCase.getResult((DefaultCase[])new DefaultCaseResult[]{cr0, cr1, cr2}, (PlanSpecifier)new PlanSpecifier(product.getName(), BillingPeriod.ANNUAL, priceList.getName()), (StaticCatalog)cat));
        Assert.assertEquals((Object)((Object)r2), (Object)((Object)Result.DIPSY));
    }

    protected void assertionNull(DefaultCaseResult cr, String productName, ProductCategory productCategory, BillingPeriod bp, String priceListName, StandaloneCatalog cat) throws CatalogApiException {
        Assert.assertNull((Object)cr.getResult(new PlanSpecifier(productName, bp, priceListName), (StaticCatalog)cat));
    }

    protected void assertionException(DefaultCaseResult cr, String productName, ProductCategory productCategory, BillingPeriod bp, String priceListName, StandaloneCatalog cat) {
        try {
            cr.getResult(new PlanSpecifier(productName, bp, priceListName), (StaticCatalog)cat);
            Assert.fail((String)"Expecting an exception");
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_PRICE_LIST_NOT_FOUND.getCode());
        }
    }

    protected void assertion(Result result, DefaultCaseResult cr, String productName, ProductCategory productCategory, BillingPeriod bp, String priceListName, StandaloneCatalog cat) throws CatalogApiException {
        Assert.assertEquals((Object)((Object)result), (Object)cr.getResult(new PlanSpecifier(productName, bp, priceListName), (StaticCatalog)cat));
    }

    protected class DefaultCaseResult
    extends DefaultCase<Result> {
        @XmlElement(required=true)
        private final Result policy;
        @XmlElement(required=false, name="product")
        @XmlIDREF
        protected DefaultProduct product;
        @XmlElement(required=false, name="productCategory")
        protected ProductCategory productCategory;
        @XmlElement(required=false, name="billingPeriod")
        protected BillingPeriod billingPeriod;
        @XmlElement(required=false, name="priceList")
        @XmlIDREF
        protected DefaultPriceList priceList;

        public DefaultCaseResult(DefaultProduct product, ProductCategory productCategory, BillingPeriod billingPeriod, DefaultPriceList priceList, Result policy) {
            this.setProduct((Product)product);
            this.setProductCategory(productCategory);
            this.setBillingPeriod(billingPeriod);
            this.setPriceList(priceList);
            this.policy = policy;
        }

        protected Result getResult() {
            return this.policy;
        }

        public DefaultProduct getProduct() {
            return this.product;
        }

        public ProductCategory getProductCategory() {
            return this.productCategory;
        }

        public BillingPeriod getBillingPeriod() {
            return this.billingPeriod;
        }

        public DefaultPriceList getPriceList() {
            return this.priceList;
        }

        protected DefaultCaseResult setProduct(Product product) {
            this.product = (DefaultProduct)product;
            return this;
        }

        protected DefaultCaseResult setProductCategory(ProductCategory productCategory) {
            this.productCategory = productCategory;
            return this;
        }

        protected DefaultCaseResult setBillingPeriod(BillingPeriod billingPeriod) {
            this.billingPeriod = billingPeriod;
            return this;
        }

        protected DefaultCaseResult setPriceList(DefaultPriceList priceList) {
            this.priceList = priceList;
            return this;
        }
    }
}

