/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.plugin;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanAlignmentChange;
import org.killbill.billing.catalog.api.PlanAlignmentCreate;
import org.killbill.billing.catalog.api.PlanChangeResult;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.rules.CaseBillingAlignment;
import org.killbill.billing.catalog.api.rules.CaseCancelPolicy;
import org.killbill.billing.catalog.api.rules.CaseChangePlanAlignment;
import org.killbill.billing.catalog.api.rules.CaseChangePlanPolicy;
import org.killbill.billing.catalog.api.rules.CaseCreateAlignment;
import org.killbill.billing.catalog.api.rules.CasePriceList;
import org.killbill.billing.catalog.api.rules.PlanRules;
import org.killbill.billing.catalog.plugin.TestModelCaseBillingAlignment;
import org.killbill.billing.catalog.plugin.TestModelCaseCancelPolicy;
import org.killbill.billing.catalog.plugin.TestModelCaseChangePlanAlignment;
import org.killbill.billing.catalog.plugin.TestModelCaseChangePlanPolicy;
import org.killbill.billing.catalog.plugin.TestModelCaseCreateAlignment;
import org.killbill.billing.catalog.plugin.TestModelCasePriceList;

public class TestModelPlanRules
implements PlanRules {
    private final Iterable<Product> products;
    private final Iterable<Plan> plans;
    private final Iterable<PriceList> priceLists;
    private final List<CaseChangePlanPolicy> caseChangePlanPolicy;
    private final List<CaseChangePlanAlignment> caseChangePlanAlignment;
    private final List<CaseCancelPolicy> caseCancelPolicy;
    private final List<CaseCreateAlignment> caseCreateAlignment;
    private final List<CaseBillingAlignment> caseBillingAlignments;
    private final List<CasePriceList> casePriceList;

    public TestModelPlanRules(Iterable<Product> products, Iterable<Plan> plans, Iterable<PriceList> priceLists) {
        this.products = products;
        this.plans = plans;
        this.priceLists = priceLists;
        this.caseChangePlanPolicy = new ArrayList<CaseChangePlanPolicy>();
        this.caseChangePlanAlignment = new ArrayList<CaseChangePlanAlignment>();
        this.caseCancelPolicy = new ArrayList<CaseCancelPolicy>();
        this.caseCreateAlignment = new ArrayList<CaseCreateAlignment>();
        this.caseBillingAlignments = new ArrayList<CaseBillingAlignment>();
        this.casePriceList = new ArrayList<CasePriceList>();
    }

    public void addCaseBillingAlignmentRule(CaseBillingAlignment input) {
        this.caseBillingAlignments.add(input);
    }

    public void addCaseBillingAlignmentRule(Product product, ProductCategory productCategory, BillingPeriod billingPeriod, PriceList priceList, PhaseType phaseType, BillingAlignment billingAlignment) {
        this.caseBillingAlignments.add(new TestModelCaseBillingAlignment(product, productCategory, billingPeriod, priceList, phaseType, billingAlignment));
    }

    public void addCaseCancelRule(CaseCancelPolicy input) {
        this.caseCancelPolicy.add(input);
    }

    public void addCaseCancelRule(Product product, ProductCategory productCategory, BillingPeriod billingPeriod, PriceList priceList, PhaseType phaseType, BillingActionPolicy billingActionPolicy) {
        this.caseCancelPolicy.add(new TestModelCaseCancelPolicy(product, productCategory, billingPeriod, priceList, phaseType, billingActionPolicy));
    }

    public void addCaseChangeAlignmentRule(CaseChangePlanAlignment input) {
        this.caseChangePlanAlignment.add(input);
    }

    public void addCaseChangeAlignmentRule(PhaseType phaseType, String fromProduct, ProductCategory fromProductCategory, BillingPeriod fromBillingPeriod, String fromPriceList, String toProduct, ProductCategory toProductCategory, BillingPeriod toBillingPeriod, String toPriceList, PlanAlignmentChange planAlignmentChange) {
        this.caseChangePlanAlignment.add(new TestModelCaseChangePlanAlignment(phaseType, this.findProduct(fromProduct), fromProductCategory, fromBillingPeriod, this.findPriceList(fromPriceList), this.findProduct(toProduct), toProductCategory, toBillingPeriod, this.findPriceList(toPriceList), planAlignmentChange));
    }

    public void addCaseChangePlanPolicyRule(CaseChangePlanPolicy input) {
        this.caseChangePlanPolicy.add(input);
    }

    public void addCaseChangePlanPolicyRule(PhaseType phaseType, String fromProduct, ProductCategory fromProductCategory, BillingPeriod fromBillingPeriod, String fromPriceList, String toProduct, ProductCategory toProductCategory, BillingPeriod toBillingPeriod, String toPriceList, BillingActionPolicy policy) {
        this.caseChangePlanPolicy.add(new TestModelCaseChangePlanPolicy(phaseType, this.findProduct(fromProduct), fromProductCategory, fromBillingPeriod, this.findPriceList(fromPriceList), this.findProduct(toProduct), toProductCategory, toBillingPeriod, this.findPriceList(toPriceList), policy));
    }

    public void addCaseCreateAlignmentRule(CaseCreateAlignment input) {
        this.caseCreateAlignment.add(input);
    }

    public void addCaseCreateAlignmentRule(Product product, ProductCategory productCategory, BillingPeriod billingPeriod, PriceList priceList, PlanAlignmentCreate planAlignmentCreate) {
        this.caseCreateAlignment.add(new TestModelCaseCreateAlignment(product, productCategory, billingPeriod, priceList, planAlignmentCreate));
    }

    public void addPriceListRule(CasePriceList input) {
        this.casePriceList.add(input);
    }

    public void addPriceListRule(Product product, ProductCategory productCategory, BillingPeriod billingPeriod, PriceList priceList, PriceList destPriceList) {
        this.casePriceList.add(new TestModelCasePriceList(product, productCategory, billingPeriod, priceList, destPriceList));
    }

    public StaticCatalog getCatalog() {
        return null;
    }

    public Iterable<CaseChangePlanPolicy> getCaseChangePlanPolicy() {
        return this.caseChangePlanPolicy;
    }

    public Iterable<CaseChangePlanAlignment> getCaseChangePlanAlignment() {
        return this.caseChangePlanAlignment;
    }

    public Iterable<CaseCancelPolicy> getCaseCancelPolicy() {
        return this.caseCancelPolicy;
    }

    public Iterable<CaseCreateAlignment> getCaseCreateAlignment() {
        return this.caseCreateAlignment;
    }

    public Iterable<CaseBillingAlignment> getCaseBillingAlignment() {
        return this.caseBillingAlignments;
    }

    public Iterable<CasePriceList> getCasePriceList() {
        return this.casePriceList;
    }

    public PlanAlignmentCreate getPlanCreateAlignment(PlanSpecifier planSpecifier) throws CatalogApiException {
        return null;
    }

    public BillingActionPolicy getPlanCancelPolicy(PlanPhaseSpecifier planPhaseSpecifier) throws CatalogApiException {
        return null;
    }

    public BillingAlignment getBillingAlignment(PlanPhaseSpecifier planPhaseSpecifier) throws CatalogApiException {
        return null;
    }

    public PlanChangeResult getPlanChangeResult(PlanPhaseSpecifier planPhaseSpecifier, PlanSpecifier planSpecifier) throws CatalogApiException {
        return null;
    }

    private Product findProduct(final @Nullable String productName) {
        return this.find(this.products, productName, "products", new Predicate<Product>(){

            public boolean apply(Product input) {
                return input.getName().equals(productName);
            }
        });
    }

    private Plan findPlan(final @Nullable String planName) {
        return this.find(this.plans, planName, "plans", new Predicate<Plan>(){

            public boolean apply(Plan input) {
                return input.getName().equals(planName);
            }
        });
    }

    private PriceList findPriceList(final @Nullable String priceListName) {
        return this.find(this.priceLists, priceListName, "pricelists", new Predicate<PriceList>(){

            public boolean apply(PriceList input) {
                return input.getName().equals(priceListName);
            }
        });
    }

    private <T> T find(Iterable<T> all, @Nullable String name, String what, Predicate<T> predicate) {
        if (name == null) {
            return null;
        }
        Object result = Iterables.tryFind(all, predicate).orNull();
        if (result == null) {
            throw new IllegalStateException(String.format("%s : cannot find entry %s", what, name));
        }
        return (T)result;
    }
}

