/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.plugin;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import org.joda.time.DateTime;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.Unit;
import org.killbill.billing.catalog.api.rules.CaseBillingAlignment;
import org.killbill.billing.catalog.api.rules.CaseCancelPolicy;
import org.killbill.billing.catalog.api.rules.CaseChangePlanAlignment;
import org.killbill.billing.catalog.api.rules.CaseChangePlanPolicy;
import org.killbill.billing.catalog.api.rules.CaseCreateAlignment;
import org.killbill.billing.catalog.api.rules.CasePriceList;
import org.killbill.billing.catalog.plugin.StandaloneCatalogMapper;
import org.killbill.billing.catalog.plugin.TestModelPlanRules;
import org.killbill.billing.catalog.plugin.TestModelStandalonePluginCatalog;
import org.killbill.billing.catalog.plugin.api.StandalonePluginCatalog;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCatalogPluginMapping
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testMappingFromExistingCatalog() throws Exception {
        StandaloneCatalog inputCatalog = this.getCatalog("SpyCarAdvanced.xml");
        StandalonePluginCatalog pluginCatalog = this.buildStandalonePluginCatalog(inputCatalog);
        StandaloneCatalogMapper mapper = new StandaloneCatalogMapper(inputCatalog.getCatalogName());
        StandaloneCatalog output = mapper.toStandaloneCatalog(pluginCatalog);
        output.setRecurringBillingMode(inputCatalog.getRecurringBillingMode());
        Assert.assertEquals((Object)output, (Object)inputCatalog);
    }

    private StandalonePluginCatalog buildStandalonePluginCatalog(StandaloneCatalog inputCatalog) throws Exception {
        TestModelPlanRules rules = new TestModelPlanRules((Iterable<Product>)ImmutableList.copyOf((Collection)inputCatalog.getProducts()), (Iterable<Plan>)ImmutableList.copyOf((Collection)inputCatalog.getPlans()), inputCatalog.getPriceLists().getAllPriceLists());
        if (inputCatalog.getPlanRules().getCaseChangePlanPolicy() != null) {
            for (CaseChangePlanPolicy cur : inputCatalog.getPlanRules().getCaseChangePlanPolicy()) {
                rules.addCaseChangePlanPolicyRule(cur);
            }
        }
        if (inputCatalog.getPlanRules().getCaseChangePlanAlignment() != null) {
            for (CaseChangePlanPolicy cur : inputCatalog.getPlanRules().getCaseChangePlanAlignment()) {
                rules.addCaseChangeAlignmentRule((CaseChangePlanAlignment)cur);
            }
        }
        if (inputCatalog.getPlanRules().getCaseCancelPolicy() != null) {
            for (CaseChangePlanPolicy cur : inputCatalog.getPlanRules().getCaseCancelPolicy()) {
                rules.addCaseCancelRule((CaseCancelPolicy)cur);
            }
        }
        if (inputCatalog.getPlanRules().getCaseCreateAlignment() != null) {
            for (CaseChangePlanPolicy cur : inputCatalog.getPlanRules().getCaseCreateAlignment()) {
                rules.addCaseCreateAlignmentRule((CaseCreateAlignment)cur);
            }
        }
        if (inputCatalog.getPlanRules().getCaseBillingAlignment() != null) {
            for (CaseChangePlanPolicy cur : inputCatalog.getPlanRules().getCaseBillingAlignment()) {
                rules.addCaseBillingAlignmentRule((CaseBillingAlignment)cur);
            }
        }
        if (inputCatalog.getPlanRules().getCasePriceList() != null) {
            for (CaseChangePlanPolicy cur : inputCatalog.getPlanRules().getCasePriceList()) {
                rules.addPriceListRule((CasePriceList)cur);
            }
        }
        TestModelStandalonePluginCatalog result = new TestModelStandalonePluginCatalog(new DateTime((Object)inputCatalog.getEffectiveDate()), (Iterable<Currency>)ImmutableList.copyOf((Object[])inputCatalog.getSupportedCurrencies()), (Iterable<Product>)ImmutableList.copyOf((Collection)inputCatalog.getProducts()), (Iterable<Plan>)ImmutableList.copyOf((Collection)inputCatalog.getPlans()), (PriceList)inputCatalog.getPriceLists().getDefaultPricelist(), (Iterable<PriceList>)ImmutableList.copyOf((Object[])inputCatalog.getPriceLists().getChildPriceLists()), rules, (Iterable<Unit>)ImmutableList.copyOf((Object[])inputCatalog.getUnits()));
        return result;
    }
}

