/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.io;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultDuration;
import org.killbill.billing.catalog.DefaultFixed;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultMutableStaticCatalog;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.DefaultRecurring;
import org.killbill.billing.catalog.DefaultVersionedCatalog;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.xmlloader.XMLLoader;
import org.killbill.xmlloader.XMLWriter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestXMLWriter
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testVersionedCatalog() throws Exception {
        StandaloneCatalog catalog = this.getCatalog("SpyCarAdvanced.xml");
        DefaultVersionedCatalog versionedCatalog = new DefaultVersionedCatalog();
        versionedCatalog.add(catalog);
        Class<?> serializableClass = versionedCatalog.getClass();
        String newCatalogStr = XMLWriter.writeXML((Object)versionedCatalog, serializableClass);
    }

    @Test(groups={"fast"})
    public void testMarshallUnmarshall() throws Exception {
        StandaloneCatalog catalog = this.getCatalog("SpyCarAdvanced.xml");
        String oldCatalogStr = XMLWriter.writeXML((Object)catalog, StandaloneCatalog.class);
        StandaloneCatalog oldCatalog = (StandaloneCatalog)XMLLoader.getObjectFromStream((InputStream)new ByteArrayInputStream(oldCatalogStr.getBytes(Charset.forName("UTF-8"))), StandaloneCatalog.class);
        String oldCatalogStr2 = XMLWriter.writeXML((Object)oldCatalog, StandaloneCatalog.class);
        Assert.assertEquals((String)oldCatalogStr2, (String)oldCatalogStr);
    }

    @Test(groups={"fast"})
    public void testAddPlan() throws Exception {
        StandaloneCatalog catalog = this.getCatalog("SpyCarBasic.xml");
        DefaultMutableStaticCatalog mutableCatalog = new DefaultMutableStaticCatalog(catalog);
        DefaultProduct newProduct = new DefaultProduct();
        newProduct.setName("Dynamic");
        newProduct.setCatagory(ProductCategory.BASE);
        newProduct.initialize((StandaloneCatalog)mutableCatalog);
        mutableCatalog.addProduct((Product)newProduct);
        DefaultPlanPhase trialPhase = new DefaultPlanPhase();
        trialPhase.setPhaseType(PhaseType.TRIAL);
        trialPhase.setDuration(new DefaultDuration().setUnit(TimeUnit.DAYS).setNumber(Integer.valueOf(14)));
        trialPhase.setFixed(new DefaultFixed().setFixedPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.USD).setValue(BigDecimal.ZERO)})));
        DefaultPlanPhase evergreenPhase = new DefaultPlanPhase();
        evergreenPhase.setPhaseType(PhaseType.EVERGREEN);
        evergreenPhase.setDuration(new DefaultDuration().setUnit(TimeUnit.MONTHS).setNumber(Integer.valueOf(1)));
        evergreenPhase.setRecurring(new DefaultRecurring().setBillingPeriod(BillingPeriod.MONTHLY).setRecurringPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.USD).setValue(BigDecimal.TEN)})));
        DefaultPlan newPlan = new DefaultPlan();
        newPlan.setName("dynamic-monthly");
        newPlan.setPriceListName("DEFAULT");
        newPlan.setProduct((Product)newProduct);
        newPlan.setInitialPhases(new DefaultPlanPhase[]{trialPhase});
        newPlan.setFinalPhase(evergreenPhase);
        newPlan.setRecurringBillingMode(BillingMode.IN_ADVANCE);
        newPlan.initialize((StandaloneCatalog)mutableCatalog);
        mutableCatalog.addPlan((Plan)newPlan);
        String newCatalogStr = XMLWriter.writeXML((Object)((StandaloneCatalog)mutableCatalog), StandaloneCatalog.class);
        StandaloneCatalog newCatalog = (StandaloneCatalog)XMLLoader.getObjectFromStream((InputStream)new ByteArrayInputStream(newCatalogStr.getBytes(Charset.forName("UTF-8"))), StandaloneCatalog.class);
        Assert.assertEquals((int)newCatalog.getPlans().size(), (int)(catalog.getPlans().size() + 1));
        DefaultPlan plan = newCatalog.findPlan("dynamic-monthly");
        Assert.assertEquals((String)plan.getName(), (String)"dynamic-monthly");
        Assert.assertEquals((String)plan.getPriceList().getName(), (String)"DEFAULT");
        Assert.assertEquals((String)plan.getProduct().getName(), (String)"Dynamic");
        Assert.assertEquals((Object)plan.getProduct().getCategory(), (Object)ProductCategory.BASE);
        Assert.assertEquals((int)plan.getInitialPhases().length, (int)1);
        Assert.assertEquals((String)plan.getInitialPhases()[0].getName(), (String)"dynamic-monthly-trial");
        Assert.assertEquals((Object)plan.getInitialPhases()[0].getPhaseType(), (Object)PhaseType.TRIAL);
        Assert.assertEquals((int)plan.getInitialPhases()[0].getFixed().getPrice().getPrices().length, (int)1);
        Assert.assertEquals((Object)plan.getInitialPhases()[0].getFixed().getPrice().getPrices()[0].getCurrency(), (Object)Currency.USD);
        Assert.assertEquals((Object)plan.getInitialPhases()[0].getFixed().getPrice().getPrices()[0].getValue(), (Object)BigDecimal.ZERO);
        Assert.assertEquals((String)plan.getFinalPhase().getName(), (String)"dynamic-monthly-evergreen");
        Assert.assertEquals((Object)plan.getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getBillingPeriod(), (Object)BillingPeriod.MONTHLY);
        Assert.assertEquals((int)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices().length, (int)1);
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices()[0].getCurrency(), (Object)Currency.USD);
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices()[0].getValue(), (Object)BigDecimal.TEN);
    }
}

