/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.io;

import java.math.BigDecimal;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.TierBlockPolicy;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.catalog.api.UsageType;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestXMLReader
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testCatalogLoad() {
        try {
            this.getCatalog("SpyCarBasic.xml");
            this.getCatalog("SpyCarAdvanced.xml");
            this.getCatalog("WeaponsHire.xml");
            this.getCatalog("WeaponsHireSmall.xml");
            this.getCatalog("catalogTest.xml");
            this.getCatalog("UsageExperimental.xml");
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test(groups={"fast"})
    public void testUsageCapacityInAdvance() {
        try {
            StandaloneCatalog catalog = this.getCatalog("UsageExperimental.xml");
            Usage[] usages = this.getUsages(catalog, "capacity-in-advance-monthly");
            Assert.assertEquals((int)usages.length, (int)1);
            Usage usage = usages[0];
            Assert.assertEquals((String)usage.getName(), (String)"capacity-in-advance-monthly-usage1");
            Assert.assertEquals((Object)usage.getBillingPeriod(), (Object)BillingPeriod.MONTHLY);
            Assert.assertEquals((Object)usage.getUsageType(), (Object)UsageType.CAPACITY);
            Assert.assertEquals((Object)usage.getBillingMode(), (Object)BillingMode.IN_ADVANCE);
            Assert.assertEquals((Object)usage.getTierBlockPolicy(), (Object)TierBlockPolicy.ALL_TIERS);
            Assert.assertEquals((int)usage.getBlocks().length, (int)0);
            Assert.assertEquals((int)usage.getTiers().length, (int)0);
            Assert.assertEquals((int)usage.getLimits().length, (int)1);
            Assert.assertEquals((String)usage.getLimits()[0].getUnit().getName(), (String)"members");
            Assert.assertEquals((Object)usage.getLimits()[0].getMax(), (Object)new Double("100"));
            Assert.assertEquals((int)usage.getRecurringPrice().getPrices().length, (int)1);
            Assert.assertEquals((Object)usage.getRecurringPrice().getPrices()[0].getCurrency(), (Object)Currency.BTC);
            Assert.assertEquals((Object)usage.getRecurringPrice().getPrices()[0].getValue(), (Object)new BigDecimal("100.00"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test(groups={"fast"})
    public void testUsageConsumableInAdvancePrepayCredit() {
        try {
            StandaloneCatalog catalog = this.getCatalog("UsageExperimental.xml");
            Usage[] usages = this.getUsages(catalog, "consumable-in-advance-prepay-credit-monthly");
            Assert.assertEquals((int)usages.length, (int)1);
            Usage usage = usages[0];
            Assert.assertEquals((String)usage.getName(), (String)"consumable-in-advance-prepay-credit-monthly-usage1");
            Assert.assertEquals((Object)usage.getBillingPeriod(), (Object)BillingPeriod.MONTHLY);
            Assert.assertEquals((Object)usage.getUsageType(), (Object)UsageType.CONSUMABLE);
            Assert.assertEquals((Object)usage.getBillingMode(), (Object)BillingMode.IN_ADVANCE);
            Assert.assertEquals((int)usage.getLimits().length, (int)0);
            Assert.assertEquals((int)usage.getTiers().length, (int)0);
            Assert.assertEquals((int)usage.getBlocks().length, (int)1);
            Assert.assertEquals((String)usage.getBlocks()[0].getUnit().getName(), (String)"cell-phone-minutes");
            Assert.assertEquals((Object)usage.getBlocks()[0].getSize(), (Object)new Double("1000"));
            Assert.assertEquals((int)usage.getBlocks()[0].getPrice().getPrices().length, (int)1);
            Assert.assertEquals((Object)usage.getBlocks()[0].getPrice().getPrices()[0].getCurrency(), (Object)Currency.BTC);
            Assert.assertEquals((Object)usage.getBlocks()[0].getPrice().getPrices()[0].getValue(), (Object)new BigDecimal("0.10"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test(groups={"fast"})
    public void testUsageConsumableInAdvanceTopUp() {
        try {
            StandaloneCatalog catalog = this.getCatalog("UsageExperimental.xml");
            Usage[] usages = this.getUsages(catalog, "consumable-in-advance-topup");
            Assert.assertEquals((int)usages.length, (int)1);
            Usage usage = usages[0];
            Assert.assertEquals((String)usage.getName(), (String)"consumable-in-advance-topup-usage1");
            Assert.assertEquals((Object)usage.getBillingPeriod(), (Object)BillingPeriod.NO_BILLING_PERIOD);
            Assert.assertEquals((Object)usage.getUsageType(), (Object)UsageType.CONSUMABLE);
            Assert.assertEquals((Object)usage.getBillingMode(), (Object)BillingMode.IN_ADVANCE);
            Assert.assertEquals((int)usage.getLimits().length, (int)0);
            Assert.assertEquals((int)usage.getTiers().length, (int)0);
            Assert.assertEquals((int)usage.getBlocks().length, (int)1);
            Assert.assertEquals((String)usage.getBlocks()[0].getUnit().getName(), (String)"fastrack-tokens");
            Assert.assertEquals((Object)usage.getBlocks()[0].getSize(), (Object)new Double("10"));
            Assert.assertEquals((int)usage.getBlocks()[0].getPrice().getPrices().length, (int)1);
            Assert.assertEquals((Object)usage.getBlocks()[0].getPrice().getPrices()[0].getCurrency(), (Object)Currency.BTC);
            Assert.assertEquals((Object)usage.getBlocks()[0].getPrice().getPrices()[0].getValue(), (Object)new BigDecimal("0.10"));
            Assert.assertEquals((Object)usage.getBlocks()[0].getMinTopUpCredit(), (Object)new Double("5"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test(groups={"fast"})
    public void testUsageCapacityInArrear() {
        try {
            StandaloneCatalog catalog = this.getCatalog("UsageExperimental.xml");
            Usage[] usages = this.getUsages(catalog, "capacity-in-arrear");
            Assert.assertEquals((int)usages.length, (int)1);
            Usage usage = usages[0];
            Assert.assertEquals((String)usage.getName(), (String)"capacity-in-arrear-usage1");
            Assert.assertEquals((Object)usage.getBillingPeriod(), (Object)BillingPeriod.MONTHLY);
            Assert.assertEquals((Object)usage.getUsageType(), (Object)UsageType.CAPACITY);
            Assert.assertEquals((Object)usage.getBillingMode(), (Object)BillingMode.IN_ARREAR);
            Assert.assertEquals((int)usage.getLimits().length, (int)0);
            Assert.assertEquals((int)usage.getBlocks().length, (int)0);
            Assert.assertEquals((int)usage.getTiers().length, (int)2);
            Assert.assertEquals((int)usage.getTiers()[0].getLimits().length, (int)2);
            Assert.assertEquals((String)usage.getTiers()[0].getLimits()[0].getUnit().getName(), (String)"bandwith-meg-sec");
            Assert.assertEquals((Object)usage.getTiers()[0].getLimits()[0].getMax(), (Object)new Double("100"));
            Assert.assertEquals((String)usage.getTiers()[0].getLimits()[1].getUnit().getName(), (String)"members");
            Assert.assertEquals((Object)usage.getTiers()[0].getLimits()[1].getMax(), (Object)new Double("500"));
            Assert.assertEquals((int)usage.getTiers()[0].getFixedPrice().getPrices().length, (int)1);
            Assert.assertEquals((Object)usage.getTiers()[0].getFixedPrice().getPrices()[0].getCurrency(), (Object)Currency.BTC);
            Assert.assertEquals((Object)usage.getTiers()[0].getFixedPrice().getPrices()[0].getValue(), (Object)new BigDecimal("0.007"));
            Assert.assertEquals((int)usage.getTiers()[0].getRecurringPrice().getPrices().length, (int)1);
            Assert.assertEquals((Object)usage.getTiers()[0].getRecurringPrice().getPrices()[0].getCurrency(), (Object)Currency.BTC);
            Assert.assertEquals((Object)usage.getTiers()[0].getRecurringPrice().getPrices()[0].getValue(), (Object)new BigDecimal("0.8"));
            Assert.assertEquals((String)usage.getTiers()[1].getLimits()[0].getUnit().getName(), (String)"bandwith-meg-sec");
            Assert.assertEquals((Object)usage.getTiers()[1].getLimits()[0].getMax(), (Object)new Double("100"));
            Assert.assertEquals((String)usage.getTiers()[1].getLimits()[1].getUnit().getName(), (String)"members");
            Assert.assertEquals((Object)usage.getTiers()[1].getLimits()[1].getMax(), (Object)new Double("1000"));
            Assert.assertEquals((int)usage.getTiers()[1].getFixedPrice().getPrices().length, (int)1);
            Assert.assertEquals((Object)usage.getTiers()[1].getFixedPrice().getPrices()[0].getCurrency(), (Object)Currency.BTC);
            Assert.assertEquals((Object)usage.getTiers()[1].getFixedPrice().getPrices()[0].getValue(), (Object)new BigDecimal("0.4"));
            Assert.assertEquals((int)usage.getTiers()[1].getRecurringPrice().getPrices().length, (int)1);
            Assert.assertEquals((Object)usage.getTiers()[1].getRecurringPrice().getPrices()[0].getCurrency(), (Object)Currency.BTC);
            Assert.assertEquals((Object)usage.getTiers()[1].getRecurringPrice().getPrices()[0].getValue(), (Object)new BigDecimal("1.2"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test(groups={"fast"})
    public void testUsageConsumableInArrear() {
        try {
            StandaloneCatalog catalog = this.getCatalog("UsageExperimental.xml");
            Usage[] usages = this.getUsages(catalog, "consumable-in-arrear");
            Assert.assertEquals((int)usages.length, (int)1);
            Usage usage = usages[0];
            Assert.assertEquals((String)usage.getName(), (String)"consumable-in-arrear-usage1");
            Assert.assertEquals((Object)usage.getBillingPeriod(), (Object)BillingPeriod.MONTHLY);
            Assert.assertEquals((Object)usage.getUsageType(), (Object)UsageType.CONSUMABLE);
            Assert.assertEquals((Object)usage.getBillingMode(), (Object)BillingMode.IN_ARREAR);
            Assert.assertEquals((int)usage.getLimits().length, (int)0);
            Assert.assertEquals((int)usage.getBlocks().length, (int)0);
            Assert.assertEquals((int)usage.getTiers().length, (int)1);
            Assert.assertEquals((int)usage.getTiers()[0].getTieredBlocks().length, (int)2);
            Assert.assertEquals((String)usage.getTiers()[0].getTieredBlocks()[0].getUnit().getName(), (String)"cell-phone-minutes");
            Assert.assertEquals((Object)usage.getTiers()[0].getTieredBlocks()[0].getSize(), (Object)new Double("1000"));
            Assert.assertEquals((Object)usage.getTiers()[0].getTieredBlocks()[0].getMax(), (Object)new Double("10000"));
            Assert.assertEquals((int)usage.getTiers()[0].getTieredBlocks()[0].getPrice().getPrices().length, (int)1);
            Assert.assertEquals((Object)usage.getTiers()[0].getTieredBlocks()[0].getPrice().getPrices()[0].getCurrency(), (Object)Currency.BTC);
            Assert.assertEquals((Object)usage.getTiers()[0].getTieredBlocks()[0].getPrice().getPrices()[0].getValue(), (Object)new BigDecimal("0.5"));
            Assert.assertEquals((String)usage.getTiers()[0].getTieredBlocks()[1].getUnit().getName(), (String)"Mbytes");
            Assert.assertEquals((Object)usage.getTiers()[0].getTieredBlocks()[1].getSize(), (Object)new Double("512"));
            Assert.assertEquals((Object)usage.getTiers()[0].getTieredBlocks()[1].getMax(), (Object)new Double("512000"));
            Assert.assertEquals((int)usage.getTiers()[0].getTieredBlocks()[1].getPrice().getPrices().length, (int)1);
            Assert.assertEquals((Object)usage.getTiers()[0].getTieredBlocks()[1].getPrice().getPrices()[0].getCurrency(), (Object)Currency.BTC);
            Assert.assertEquals((Object)usage.getTiers()[0].getTieredBlocks()[1].getPrice().getPrices()[0].getValue(), (Object)new BigDecimal("0.3"));
        }
        catch (Exception e) {
            Assert.fail((String)e.toString());
        }
    }

    private Usage[] getUsages(StandaloneCatalog catalog, String planName) throws CatalogApiException {
        DefaultPlan plan = catalog.findPlan(planName);
        Assert.assertNotNull((Object)plan);
        PlanPhase phase = plan.getFinalPhase();
        Assert.assertNotNull((Object)phase);
        Usage[] usages = phase.getUsages();
        return usages;
    }
}

