/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.caching;

import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.caching.PriceOverridePattern;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPriceOverridePattern
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testWithLegacyCustomPlanNameDelimiter1() throws CatalogApiException {
        PriceOverridePattern priceOverridePattern = new PriceOverridePattern(false);
        String legacyOverridddenPlanName = "foo-12345";
        String[] parts = priceOverridePattern.getPlanParts("foo-12345");
        Assert.assertEquals((int)parts.length, (int)2);
        Assert.assertEquals((String)parts[0], (String)"foo");
        Assert.assertEquals((String)parts[1], (String)"12345");
    }

    @Test(groups={"fast"})
    public void testWithLegacyCustomPlanNameDelimiter2() throws CatalogApiException {
        PriceOverridePattern priceOverridePattern = new PriceOverridePattern(false);
        String legacyOverridddenPlanName = "foo-12345!8765432";
        String[] parts = priceOverridePattern.getPlanParts("foo-12345!8765432");
        Assert.assertEquals((int)parts.length, (int)2);
        Assert.assertEquals((String)parts[0], (String)"foo");
        Assert.assertEquals((String)parts[1], (String)"12345");
    }

    @Test(groups={"fast"})
    public void testWithNonLegacyCustomPlanNameDelimiter1() throws CatalogApiException {
        PriceOverridePattern priceOverridePattern = new PriceOverridePattern(true);
        String legacyOverridddenPlanName = "foo:12345";
        String[] parts = priceOverridePattern.getPlanParts("foo:12345");
        Assert.assertEquals((int)parts.length, (int)2);
        Assert.assertEquals((String)parts[0], (String)"foo");
        Assert.assertEquals((String)parts[1], (String)"12345");
    }

    @Test(groups={"fast"})
    public void testWithNonLegacyCustomPlanNameDelimiter2() throws CatalogApiException {
        PriceOverridePattern priceOverridePattern = new PriceOverridePattern(true);
        String legacyOverridddenPlanName = "foo:12345!8765432";
        String[] parts = priceOverridePattern.getPlanParts("foo:12345!8765432");
        Assert.assertEquals((int)parts.length, (int)2);
        Assert.assertEquals((String)parts[0], (String)"foo");
        Assert.assertEquals((String)parts[1], (String)"12345");
    }
}

