/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.caching;

import com.google.common.collect.ImmutableList;
import com.google.common.io.CharStreams;
import com.google.common.io.Resources;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultVersionedCatalog;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.StandaloneCatalogWithPriceOverride;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.VersionedCatalog;
import org.killbill.billing.catalog.caching.DefaultCatalogCache;
import org.killbill.xmlloader.UriAccessor;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class TestDefaultCatalogCache
extends CatalogTestSuiteNoDB {
    private InternalTenantContext multiTenantContext;
    private InternalTenantContext otherMultiTenantContext;

    @BeforeMethod(groups={"fast"})
    protected void beforeMethod() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        this.cacheControllerDispatcher.clearAll();
        this.multiTenantContext = (InternalTenantContext)Mockito.mock(InternalTenantContext.class);
        Mockito.when((Object)this.multiTenantContext.getAccountRecordId()).thenReturn((Object)456L);
        Mockito.when((Object)this.multiTenantContext.getTenantRecordId()).thenReturn((Object)99L);
        this.otherMultiTenantContext = (InternalTenantContext)Mockito.mock(InternalCallContext.class);
        Mockito.when((Object)this.otherMultiTenantContext.getAccountRecordId()).thenReturn((Object)123L);
        Mockito.when((Object)this.otherMultiTenantContext.getTenantRecordId()).thenReturn((Object)112233L);
        ((DefaultCatalogCache)this.catalogCache).setDefaultCatalog();
    }

    @Test(groups={"fast"})
    public void testMissingDefaultCatalog() throws CatalogApiException {
        this.catalogCache.loadDefaultCatalog(null);
        Assert.assertEquals((String)this.catalogCache.getCatalog(true, true, false, (InternalTenantContext)this.internalCallContext).getCatalogName(), (String)"EmptyCatalog");
    }

    @Test(groups={"fast"})
    public void testDefaultCatalog() throws CatalogApiException {
        this.catalogCache.loadDefaultCatalog(Resources.getResource((String)"org/killbill/billing/catalog/SpyCarBasic.xml").toExternalForm());
        VersionedCatalog result = this.catalogCache.getCatalog(true, true, false, (InternalTenantContext)this.internalCallContext);
        Assert.assertNotNull((Object)result);
        StaticCatalog catalogVersion = (StaticCatalog)result.getVersions().get(result.getVersions().size() - 1);
        Collection products = catalogVersion.getProducts();
        Assert.assertEquals((int)products.size(), (int)3);
        DefaultVersionedCatalog resultForMultiTenantContext = new DefaultVersionedCatalog();
        for (StaticCatalog cur : result.getVersions()) {
            resultForMultiTenantContext.add((StandaloneCatalog)new StandaloneCatalogWithPriceOverride(cur, this.priceOverride, this.multiTenantContext.getTenantRecordId(), this.internalCallContextFactory));
        }
        Assert.assertEquals((String)this.catalogCache.getCatalog(true, true, false, this.multiTenantContext).getCatalogName(), (String)resultForMultiTenantContext.getCatalogName());
        Assert.assertEquals((int)this.catalogCache.getCatalog(true, true, false, this.multiTenantContext).getVersions().size(), (int)resultForMultiTenantContext.getVersions().size());
        for (int i = 0; i < this.catalogCache.getCatalog(true, true, false, this.multiTenantContext).getVersions().size(); ++i) {
            Assert.assertEquals((Object)((StandaloneCatalogWithPriceOverride)this.catalogCache.getCatalog(true, true, false, this.multiTenantContext).getVersions().get(i)).getTenantRecordId(), (Object)((StandaloneCatalogWithPriceOverride)resultForMultiTenantContext.getVersions().get(i)).getTenantRecordId());
        }
    }

    @Test(groups={"fast"})
    public void testExistingTenantCatalog() throws CatalogApiException, URISyntaxException, IOException {
        InternalCallContext differentMultiTenantContext = (InternalCallContext)Mockito.mock(InternalCallContext.class);
        Mockito.when((Object)differentMultiTenantContext.getTenantRecordId()).thenReturn((Object)55667788L);
        final AtomicBoolean shouldThrow = new AtomicBoolean(false);
        final Long multiTenantRecordId = this.multiTenantContext.getTenantRecordId();
        final Long otherMultiTenantRecordId = this.otherMultiTenantContext.getTenantRecordId();
        InputStream tenantInputCatalog = UriAccessor.accessUri((URI)new URI(Resources.getResource((String)"org/killbill/billing/catalog/SpyCarAdvanced.xml").toExternalForm()));
        final String tenantCatalogXML = CharStreams.toString((Readable)new InputStreamReader(tenantInputCatalog, "UTF-8"));
        InputStream otherTenantInputCatalog = UriAccessor.accessUri((URI)new URI(Resources.getResource((String)"org/killbill/billing/catalog/SpyCarBasic.xml").toExternalForm()));
        final String otherTenantCatalogXML = CharStreams.toString((Readable)new InputStreamReader(otherTenantInputCatalog, "UTF-8"));
        Mockito.when((Object)this.tenantInternalApi.getTenantCatalogs((InternalTenantContext)Mockito.any(InternalTenantContext.class))).thenAnswer((Answer)new Answer<List<String>>(){

            public List<String> answer(InvocationOnMock invocation) throws Throwable {
                if (shouldThrow.get()) {
                    throw new RuntimeException();
                }
                InternalTenantContext internalContext = (InternalTenantContext)invocation.getArguments()[0];
                if (multiTenantRecordId.equals(internalContext.getTenantRecordId())) {
                    return ImmutableList.of((Object)tenantCatalogXML);
                }
                if (otherMultiTenantRecordId.equals(internalContext.getTenantRecordId())) {
                    return ImmutableList.of((Object)otherTenantCatalogXML);
                }
                return ImmutableList.of();
            }
        });
        VersionedCatalog differentResult = this.catalogCache.getCatalog(true, true, false, (InternalTenantContext)differentMultiTenantContext);
        Assert.assertNotNull((Object)differentResult);
        Assert.assertEquals((String)differentResult.getCatalogName(), (String)"EmptyCatalog");
        shouldThrow.set(true);
        differentResult = this.catalogCache.getCatalog(true, true, false, (InternalTenantContext)differentMultiTenantContext);
        Assert.assertNotNull((Object)differentResult);
        Assert.assertEquals((String)differentResult.getCatalogName(), (String)"EmptyCatalog");
        shouldThrow.set(false);
        this.catalogCache.loadDefaultCatalog(Resources.getResource((String)"org/killbill/billing/catalog/SpyCarBasic.xml").toExternalForm());
        VersionedCatalog result = this.catalogCache.getCatalog(true, true, false, this.multiTenantContext);
        Assert.assertNotNull((Object)result);
        StaticCatalog catalogVersion = (StaticCatalog)result.getVersions().get(result.getVersions().size() - 1);
        Collection products = catalogVersion.getProducts();
        Assert.assertEquals((int)products.size(), (int)6);
        VersionedCatalog otherResult = this.catalogCache.getCatalog(true, true, false, this.otherMultiTenantContext);
        Assert.assertNotNull((Object)otherResult);
        StaticCatalog othercatalogVersion = (StaticCatalog)otherResult.getVersions().get(result.getVersions().size() - 1);
        Collection otherProducts = othercatalogVersion.getProducts();
        Assert.assertEquals((int)otherProducts.size(), (int)3);
        shouldThrow.set(true);
        VersionedCatalog result2 = this.catalogCache.getCatalog(true, true, false, this.multiTenantContext);
        Assert.assertEquals((Object)result2, (Object)result);
        InternalCallContext sameMultiTenantContext = (InternalCallContext)Mockito.mock(InternalCallContext.class);
        Mockito.when((Object)sameMultiTenantContext.getAccountRecordId()).thenReturn((Object)9102L);
        Mockito.when((Object)sameMultiTenantContext.getTenantRecordId()).thenReturn((Object)multiTenantRecordId);
        Assert.assertEquals((Object)this.catalogCache.getCatalog(true, true, false, (InternalTenantContext)sameMultiTenantContext), (Object)result);
        Assert.assertEquals((Object)this.catalogCache.getCatalog(true, true, false, this.otherMultiTenantContext), (Object)otherResult);
    }
}

