/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.math.BigDecimal;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultDuration;
import org.killbill.billing.catalog.DefaultFixed;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.DefaultTier;
import org.killbill.billing.catalog.DefaultTieredBlock;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.MockCatalog;
import org.killbill.billing.catalog.MockInternationalPrice;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.MockRecurring;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.catalog.api.UsageType;
import org.killbill.xmlloader.ValidationErrors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestPlanPhase
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testValidation() {
        MockCatalog catalog = new MockCatalog();
        DefaultPlanPhase pp = MockPlanPhase.createUSDMonthlyEvergreen(null, "1.00").setPlan((Plan)MockPlan.createBicycleNoTrialEvergreen1USD());
        pp.initialize((StandaloneCatalog)catalog);
        ValidationErrors errors = pp.validate((StandaloneCatalog)catalog, new ValidationErrors());
        errors.log(log);
        Assert.assertEquals((int)errors.size(), (int)1);
        pp = MockPlanPhase.createUSDMonthlyEvergreen("1.00", null).setRecurring(new MockRecurring(BillingPeriod.NO_BILLING_PERIOD, MockInternationalPrice.createUSD("1.00")).setPhase((PlanPhase)pp)).setPlan((Plan)MockPlan.createBicycleNoTrialEvergreen1USD());
        pp.initialize((StandaloneCatalog)catalog);
        errors = pp.validate((StandaloneCatalog)catalog, new ValidationErrors());
        errors.log(log);
        Assert.assertEquals((int)errors.size(), (int)1);
    }

    @Test(groups={"fast"})
    public void testPhaseNames() throws CatalogApiException {
        String planName = "Foo";
        String planNameExt = "Foo-";
        DefaultPlan p = MockPlan.createBicycleNoTrialEvergreen1USD().setName("Foo");
        DefaultPlanPhase ppDiscount = MockPlanPhase.create1USDMonthlyEvergreen().setPhaseType(PhaseType.DISCOUNT).setPlan((Plan)p);
        DefaultPlanPhase ppTrial = MockPlanPhase.create30DayTrial().setPhaseType(PhaseType.TRIAL).setPlan((Plan)p);
        DefaultPlanPhase ppEvergreen = MockPlanPhase.create1USDMonthlyEvergreen().setPhaseType(PhaseType.EVERGREEN).setPlan((Plan)p);
        DefaultPlanPhase ppFixedTerm = MockPlanPhase.create1USDMonthlyEvergreen().setPhaseType(PhaseType.FIXEDTERM).setPlan((Plan)p);
        String ppnDiscount = DefaultPlanPhase.phaseName((String)p.getName(), (PhaseType)ppDiscount.getPhaseType());
        String ppnTrial = DefaultPlanPhase.phaseName((String)p.getName(), (PhaseType)ppTrial.getPhaseType());
        String ppnEvergreen = DefaultPlanPhase.phaseName((String)p.getName(), (PhaseType)ppEvergreen.getPhaseType());
        String ppnFixedTerm = DefaultPlanPhase.phaseName((String)p.getName(), (PhaseType)ppFixedTerm.getPhaseType());
        Assert.assertEquals((String)ppnTrial, (String)"Foo-trial");
        Assert.assertEquals((String)ppnEvergreen, (String)"Foo-evergreen");
        Assert.assertEquals((String)ppnFixedTerm, (String)"Foo-fixedterm");
        Assert.assertEquals((String)ppnDiscount, (String)"Foo-discount");
        Assert.assertEquals((String)DefaultPlanPhase.planName((String)ppnDiscount), (String)"Foo");
        Assert.assertEquals((String)DefaultPlanPhase.planName((String)ppnTrial), (String)"Foo");
        Assert.assertEquals((String)DefaultPlanPhase.planName((String)ppnEvergreen), (String)"Foo");
        Assert.assertEquals((String)DefaultPlanPhase.planName((String)ppnFixedTerm), (String)"Foo");
    }

    @Test(groups={"fast"})
    public void testEqualsWithDifferentUsageSection() {
        DefaultPlanPhase trialPhase = new DefaultPlanPhase();
        trialPhase.setPhaseType(PhaseType.TRIAL);
        trialPhase.setDuration(new DefaultDuration().setUnit(TimeUnit.DAYS).setNumber(Integer.valueOf(14)));
        trialPhase.setFixed(new DefaultFixed().setFixedPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.USD).setValue(BigDecimal.ZERO)})));
        DefaultUsage usage = new DefaultUsage();
        usage.setName("usage");
        usage.setBillingMode(BillingMode.IN_ARREAR);
        usage.setUsageType(UsageType.CONSUMABLE);
        DefaultTieredBlock block = new DefaultTieredBlock();
        block.setUnit(new DefaultUnit().setName("unit"));
        block.setSize(12.0);
        DefaultTier tier = new DefaultTier();
        tier.setBlocks(new DefaultTieredBlock[]{block});
        usage.setTiers(new DefaultTier[]{tier});
        trialPhase.setUsages(new DefaultUsage[]{usage});
        DefaultPlanPhase trialPhase2 = new DefaultPlanPhase();
        trialPhase2.setPhaseType(trialPhase.getPhaseType());
        trialPhase2.setDuration((DefaultDuration)trialPhase.getDuration());
        trialPhase2.setFixed((DefaultFixed)trialPhase.getFixed());
        trialPhase2.setUsages(null);
        Assert.assertNotEquals((Object)trialPhase, (Object)trialPhase2, (String)"Phases should be different as their usage section differs");
    }
}

