/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.math.BigDecimal;
import java.net.URISyntaxException;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.MockCatalog;
import org.killbill.billing.catalog.MockInternationalPrice;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.xmlloader.ValidationErrors;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestInternationalPrice
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testZeroValue() throws URISyntaxException, CatalogApiException {
        MockCatalog c = new MockCatalog();
        c.setSupportedCurrencies(new Currency[]{Currency.GBP, Currency.EUR, Currency.USD, Currency.BRL, Currency.MXN});
        MockInternationalPrice p0 = new MockInternationalPrice(new DefaultPrice[0]);
        p0.setPrices(new DefaultPrice[0]);
        p0.initialize(c);
        MockInternationalPrice p1 = new MockInternationalPrice(new DefaultPrice[0]);
        p1.setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.GBP).setValue(new BigDecimal(1)), new DefaultPrice().setCurrency(Currency.EUR).setValue(new BigDecimal(1)), new DefaultPrice().setCurrency(Currency.USD).setValue(new BigDecimal(1)), new DefaultPrice().setCurrency(Currency.BRL).setValue(new BigDecimal(1)), new DefaultPrice().setCurrency(Currency.MXN).setValue(new BigDecimal(1))});
        p1.initialize(c);
        Assert.assertEquals((Object)p0.getPrice(Currency.GBP), (Object)new BigDecimal(0));
        Assert.assertEquals((Object)p0.getPrice(Currency.EUR), (Object)new BigDecimal(0));
        Assert.assertEquals((Object)p0.getPrice(Currency.USD), (Object)new BigDecimal(0));
        Assert.assertEquals((Object)p0.getPrice(Currency.BRL), (Object)new BigDecimal(0));
        Assert.assertEquals((Object)p0.getPrice(Currency.MXN), (Object)new BigDecimal(0));
        Assert.assertEquals((Object)p1.getPrice(Currency.GBP), (Object)new BigDecimal(1));
        Assert.assertEquals((Object)p1.getPrice(Currency.EUR), (Object)new BigDecimal(1));
        Assert.assertEquals((Object)p1.getPrice(Currency.USD), (Object)new BigDecimal(1));
        Assert.assertEquals((Object)p1.getPrice(Currency.BRL), (Object)new BigDecimal(1));
        Assert.assertEquals((Object)p1.getPrice(Currency.MXN), (Object)new BigDecimal(1));
    }

    @Test(groups={"fast"})
    public void testPriceInitialization() throws URISyntaxException, CatalogApiException {
        MockCatalog c = new MockCatalog();
        c.setSupportedCurrencies(new Currency[]{Currency.GBP, Currency.EUR, Currency.USD, Currency.BRL, Currency.MXN});
        ((DefaultInternationalPrice)((Plan)c.getPlans().iterator().next()).getFinalPhase().getRecurring().getRecurringPrice()).setPrices(new DefaultPrice[0]);
        c.setUnits(new DefaultUnit[0]);
        c.initialize(c);
        Assert.assertEquals((Object)((Plan)c.getPlans().iterator().next()).getFinalPhase().getRecurring().getRecurringPrice().getPrice(Currency.GBP), (Object)new BigDecimal(0));
    }

    @Test(groups={"fast"})
    public void testNegativeValuePrices() {
        MockCatalog c = new MockCatalog();
        c.setSupportedCurrencies(new Currency[]{Currency.GBP, Currency.EUR, Currency.USD, Currency.BRL, Currency.MXN});
        MockInternationalPrice p1 = new MockInternationalPrice(new DefaultPrice[0]);
        p1.setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.GBP).setValue(new BigDecimal(-1)), new DefaultPrice().setCurrency(Currency.EUR).setValue(new BigDecimal(-1)), new DefaultPrice().setCurrency(Currency.USD).setValue(new BigDecimal(-1)), new DefaultPrice().setCurrency(Currency.BRL).setValue(new BigDecimal(1)), new DefaultPrice().setCurrency(Currency.MXN).setValue(new BigDecimal(1))});
        ValidationErrors errors = p1.validate(c, new ValidationErrors());
        errors.log(log);
        Assert.assertEquals((int)errors.size(), (int)3);
    }
}

