/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.collect.ImmutableList;
import com.google.common.io.Resources;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.nio.charset.Charset;
import java.util.List;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.CatalogUpdater;
import org.killbill.billing.catalog.DefaultDuration;
import org.killbill.billing.catalog.DefaultFixed;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultMutableStaticCatalog;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.DefaultRecurring;
import org.killbill.billing.catalog.PriceListDefault;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.StandaloneCatalogWithPriceOverride;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.SimplePlanDescriptor;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.TimeUnit;
import org.killbill.billing.catalog.api.user.DefaultSimplePlanDescriptor;
import org.killbill.xmlloader.XMLLoader;
import org.killbill.xmlloader.XMLWriter;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCatalogUpdater
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testEmptyDefaultCatalog() throws Exception {
        DateTime now = this.clock.getUTCNow();
        CatalogUpdater catalogUpdater = new CatalogUpdater(now, null);
        String catalogXML = catalogUpdater.getCatalogXML((InternalTenantContext)this.internalCallContext);
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromStream((InputStream)new ByteArrayInputStream(catalogXML.getBytes(Charset.forName("UTF-8"))), StandaloneCatalog.class);
        Assert.assertEquals((int)catalog.getPlans().size(), (int)0);
    }

    @Test(groups={"fast"}, description="https://github.com/killbill/killbill/issues/842")
    public void testCreateAmbiguousPlan() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        DefaultSimplePlanDescriptor desc = new DefaultSimplePlanDescriptor("foo-monthly-12345", "Foo", ProductCategory.BASE, Currency.EUR, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(0), TimeUnit.UNLIMITED, (List)ImmutableList.of());
        CatalogUpdater catalogUpdater = new CatalogUpdater(now, new Currency[]{desc.getCurrency()});
        catalogUpdater.addSimplePlanDescriptor((SimplePlanDescriptor)desc);
        StandaloneCatalog catalog = catalogUpdater.getCatalog();
        Assert.assertEquals((int)catalog.getPlans().size(), (int)1);
        StandaloneCatalogWithPriceOverride standaloneCatalogWithPriceOverride = new StandaloneCatalogWithPriceOverride((StaticCatalog)catalog, this.priceOverride, this.internalCallContext.getTenantRecordId(), this.internalCallContextFactory);
        DefaultPlan plan = catalog.findPlan("foo-monthly-12345");
        Assert.assertEquals((String)plan.getName(), (String)"foo-monthly-12345");
        Plan plan2 = standaloneCatalogWithPriceOverride.findPlan("foo-monthly-12345");
        Assert.assertEquals((String)plan2.getName(), (String)"foo-monthly-12345");
        PlanPhase planPhase = catalog.findPhase("foo-monthly-12345-evergreen");
        Assert.assertEquals((String)planPhase.getName(), (String)"foo-monthly-12345-evergreen");
        PlanPhase phase2 = standaloneCatalogWithPriceOverride.findPhase("foo-monthly-12345-evergreen");
        Assert.assertEquals((String)phase2.getName(), (String)"foo-monthly-12345-evergreen");
    }

    @Test(groups={"fast"})
    public void testAddNoTrialPlanOnFirstCatalog() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        DefaultSimplePlanDescriptor desc = new DefaultSimplePlanDescriptor("foo-monthly", "Foo", ProductCategory.BASE, Currency.EUR, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(0), TimeUnit.UNLIMITED, (List)ImmutableList.of());
        CatalogUpdater catalogUpdater = new CatalogUpdater(now, new Currency[]{desc.getCurrency()});
        catalogUpdater.addSimplePlanDescriptor((SimplePlanDescriptor)desc);
        StandaloneCatalog catalog = catalogUpdater.getCatalog();
        Assert.assertEquals((int)catalog.getProducts().size(), (int)1);
        Product product = (Product)catalog.getProducts().iterator().next();
        Assert.assertEquals((String)product.getName(), (String)"Foo");
        Assert.assertEquals((Object)product.getCategory(), (Object)ProductCategory.BASE);
        Assert.assertEquals((int)catalog.getPlans().size(), (int)1);
        DefaultPlan plan = catalog.findPlan("foo-monthly");
        Assert.assertEquals((String)plan.getName(), (String)"foo-monthly");
        Assert.assertEquals((int)plan.getInitialPhases().length, (int)0);
        Assert.assertEquals((Object)plan.getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
        Assert.assertNull((Object)plan.getFinalPhase().getFixed());
        Assert.assertEquals((String)plan.getFinalPhase().getName(), (String)"foo-monthly-evergreen");
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getBillingPeriod(), (Object)BillingPeriod.MONTHLY);
        Assert.assertEquals((int)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices().length, (int)1);
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices()[0].getValue(), (Object)BigDecimal.TEN);
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices()[0].getCurrency(), (Object)Currency.EUR);
        Assert.assertEquals((int)catalog.getPriceLists().getAllPriceLists().size(), (int)1);
        PriceList priceList = (PriceList)catalog.getPriceLists().getAllPriceLists().get(0);
        Assert.assertEquals((String)priceList.getName(), (String)new PriceListDefault().getName());
        Assert.assertEquals((int)priceList.getPlans().size(), (int)1);
        Assert.assertEquals((String)((Plan)priceList.getPlans().iterator().next()).getName(), (String)"foo-monthly");
    }

    @Test(groups={"fast"})
    public void testAddTrialPlanOnFirstCatalog() throws CatalogApiException {
        DateTime now = this.clock.getUTCNow();
        DefaultSimplePlanDescriptor desc = new DefaultSimplePlanDescriptor("foo-monthly", "Foo", ProductCategory.BASE, Currency.EUR, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(14), TimeUnit.DAYS, (List)ImmutableList.of());
        CatalogUpdater catalogUpdater = new CatalogUpdater(now, new Currency[]{desc.getCurrency()});
        catalogUpdater.addSimplePlanDescriptor((SimplePlanDescriptor)desc);
        StandaloneCatalog catalog = catalogUpdater.getCatalog();
        Assert.assertEquals((int)catalog.getProducts().size(), (int)1);
        Product product = (Product)catalog.getProducts().iterator().next();
        Assert.assertEquals((String)product.getName(), (String)"Foo");
        Assert.assertEquals((Object)product.getCategory(), (Object)ProductCategory.BASE);
        Assert.assertEquals((int)catalog.getPlans().size(), (int)1);
        DefaultPlan plan = catalog.findPlan("foo-monthly");
        Assert.assertEquals((String)plan.getName(), (String)"foo-monthly");
        Assert.assertEquals((int)plan.getInitialPhases().length, (int)1);
        Assert.assertEquals((Object)plan.getInitialPhases()[0].getPhaseType(), (Object)PhaseType.TRIAL);
        Assert.assertEquals((int)plan.getInitialPhases()[0].getFixed().getPrice().getPrices().length, (int)1);
        Assert.assertEquals((Object)plan.getInitialPhases()[0].getFixed().getPrice().getPrices()[0].getCurrency(), (Object)Currency.EUR);
        Assert.assertEquals((Object)plan.getInitialPhases()[0].getFixed().getPrice().getPrices()[0].getValue(), (Object)BigDecimal.ZERO);
        Assert.assertEquals((String)plan.getInitialPhases()[0].getName(), (String)"foo-monthly-trial");
        Assert.assertEquals((Object)plan.getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
        Assert.assertNull((Object)plan.getFinalPhase().getFixed());
        Assert.assertEquals((String)plan.getFinalPhase().getName(), (String)"foo-monthly-evergreen");
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getBillingPeriod(), (Object)BillingPeriod.MONTHLY);
        Assert.assertEquals((int)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices().length, (int)1);
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices()[0].getValue(), (Object)BigDecimal.TEN);
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices()[0].getCurrency(), (Object)Currency.EUR);
        Assert.assertEquals((int)catalog.getPriceLists().getAllPriceLists().size(), (int)1);
        PriceList priceList = (PriceList)catalog.getPriceLists().getAllPriceLists().get(0);
        Assert.assertEquals((String)priceList.getName(), (String)new PriceListDefault().getName());
        Assert.assertEquals((int)priceList.getPlans().size(), (int)1);
        Assert.assertEquals((String)((Plan)priceList.getPlans().iterator().next()).getName(), (String)"foo-monthly");
    }

    @Test(groups={"fast"})
    public void testAddPlanOnExistingCatalog() throws Exception {
        StandaloneCatalog originalCatalog = this.getCatalog("SpyCarBasic.xml");
        Assert.assertEquals((int)originalCatalog.getPriceLists().getAllPriceLists().size(), (int)1);
        Assert.assertEquals((String)((PriceList)originalCatalog.getPriceLists().getAllPriceLists().get(0)).getName(), (String)new PriceListDefault().getName());
        Assert.assertEquals((int)((PriceList)originalCatalog.getPriceLists().getAllPriceLists().get(0)).getPlans().size(), (int)3);
        CatalogUpdater catalogUpdater = new CatalogUpdater(originalCatalog);
        DefaultSimplePlanDescriptor desc = new DefaultSimplePlanDescriptor("standard-annual", "Standard", ProductCategory.BASE, Currency.USD, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(0), TimeUnit.UNLIMITED, (List)ImmutableList.of());
        catalogUpdater.addSimplePlanDescriptor((SimplePlanDescriptor)desc);
        StandaloneCatalog catalog = catalogUpdater.getCatalog();
        DefaultPlan plan = catalog.findPlan("standard-annual");
        Assert.assertEquals((String)plan.getName(), (String)"standard-annual");
        Assert.assertEquals((int)plan.getInitialPhases().length, (int)0);
        Assert.assertEquals((Object)plan.getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
        Assert.assertNull((Object)plan.getFinalPhase().getFixed());
        Assert.assertEquals((String)plan.getFinalPhase().getName(), (String)"standard-annual-evergreen");
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getBillingPeriod(), (Object)BillingPeriod.MONTHLY);
        Assert.assertEquals((int)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices().length, (int)1);
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices()[0].getValue(), (Object)BigDecimal.TEN);
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices()[0].getCurrency(), (Object)Currency.USD);
        Assert.assertEquals((int)catalog.getPriceLists().getAllPriceLists().size(), (int)1);
        PriceList priceList = (PriceList)catalog.getPriceLists().getAllPriceLists().get(0);
        Assert.assertEquals((String)priceList.getName(), (String)new PriceListDefault().getName());
        Assert.assertEquals((int)priceList.getPlans().size(), (int)4);
    }

    @Test(groups={"fast"})
    public void testAddExistingPlanWithNewCurrency() throws Exception {
        StandaloneCatalog originalCatalog = this.getCatalog("SpyCarBasic.xml");
        Assert.assertEquals((int)originalCatalog.getPriceLists().getAllPriceLists().size(), (int)1);
        Assert.assertEquals((String)((PriceList)originalCatalog.getPriceLists().getAllPriceLists().get(0)).getName(), (String)new PriceListDefault().getName());
        Assert.assertEquals((int)((PriceList)originalCatalog.getPriceLists().getAllPriceLists().get(0)).getPlans().size(), (int)3);
        CatalogUpdater catalogUpdater = new CatalogUpdater(originalCatalog);
        DefaultSimplePlanDescriptor desc = new DefaultSimplePlanDescriptor("standard-monthly", "Standard", ProductCategory.BASE, Currency.EUR, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(30), TimeUnit.DAYS, (List)ImmutableList.of());
        catalogUpdater.addSimplePlanDescriptor((SimplePlanDescriptor)desc);
        StandaloneCatalog catalog = catalogUpdater.getCatalog();
        DefaultPlan plan = catalog.findPlan("standard-monthly");
        Assert.assertEquals((String)plan.getName(), (String)"standard-monthly");
        Assert.assertEquals((int)plan.getInitialPhases().length, (int)1);
        Assert.assertEquals((Object)plan.getInitialPhases()[0].getPhaseType(), (Object)PhaseType.TRIAL);
        Assert.assertEquals((int)plan.getInitialPhases()[0].getFixed().getPrice().getPrices().length, (int)0);
        Assert.assertEquals((Object)plan.getInitialPhases()[0].getFixed().getPrice().getPrice(Currency.EUR), (Object)BigDecimal.ZERO);
        Assert.assertEquals((String)plan.getInitialPhases()[0].getName(), (String)"standard-monthly-trial");
        Assert.assertEquals((Object)plan.getFinalPhase().getPhaseType(), (Object)PhaseType.EVERGREEN);
        Assert.assertNull((Object)plan.getFinalPhase().getFixed());
        Assert.assertEquals((String)plan.getFinalPhase().getName(), (String)"standard-monthly-evergreen");
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getBillingPeriod(), (Object)BillingPeriod.MONTHLY);
        Assert.assertEquals((int)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrices().length, (int)3);
        Assert.assertEquals((Object)plan.getFinalPhase().getRecurring().getRecurringPrice().getPrice(Currency.EUR), (Object)BigDecimal.TEN);
    }

    @Test(groups={"fast"})
    public void testInvalidPlanDescriptors() throws Exception {
        StandaloneCatalog originalCatalog = this.enhanceOriginalCatalogForInvalidTestCases("org/killbill/billing/catalog/SpyCarBasic.xml");
        Assert.assertEquals((int)originalCatalog.getPriceLists().getAllPriceLists().size(), (int)1);
        Assert.assertEquals((String)((PriceList)originalCatalog.getPriceLists().getAllPriceLists().get(0)).getName(), (String)new PriceListDefault().getName());
        Assert.assertEquals((int)((PriceList)originalCatalog.getPriceLists().getAllPriceLists().get(0)).getPlans().size(), (int)5);
        CatalogUpdater catalogUpdater = new CatalogUpdater(originalCatalog);
        DefaultSimplePlanDescriptor desc = new DefaultSimplePlanDescriptor("standard-monthly", "Standard", ProductCategory.BASE, Currency.EUR, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(0), TimeUnit.DAYS, (List)ImmutableList.of());
        this.addBadSimplePlanDescriptor(catalogUpdater, (SimplePlanDescriptor)desc);
        desc = new DefaultSimplePlanDescriptor("standard-monthly", "Standard", ProductCategory.BASE, Currency.EUR, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(14), TimeUnit.DAYS, (List)ImmutableList.of());
        this.addBadSimplePlanDescriptor(catalogUpdater, (SimplePlanDescriptor)desc);
        desc = new DefaultSimplePlanDescriptor("standard-monthly", "Standard", ProductCategory.BASE, Currency.EUR, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(30), TimeUnit.MONTHS, (List)ImmutableList.of());
        this.addBadSimplePlanDescriptor(catalogUpdater, (SimplePlanDescriptor)desc);
        desc = new DefaultSimplePlanDescriptor("standard-monthly", "Standard", ProductCategory.BASE, Currency.EUR, BigDecimal.TEN, BillingPeriod.ANNUAL, Integer.valueOf(30), TimeUnit.DAYS, (List)ImmutableList.of());
        this.addBadSimplePlanDescriptor(catalogUpdater, (SimplePlanDescriptor)desc);
        desc = new DefaultSimplePlanDescriptor("dynamic-monthly", "Dynamic", ProductCategory.BASE, Currency.EUR, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(30), TimeUnit.MONTHS, (List)ImmutableList.of());
        this.addBadSimplePlanDescriptor(catalogUpdater, (SimplePlanDescriptor)desc);
        desc = new DefaultSimplePlanDescriptor("superdynamic-fixedterm", "SuperDynamic", ProductCategory.BASE, Currency.EUR, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(30), TimeUnit.DAYS, (List)ImmutableList.of());
        this.addBadSimplePlanDescriptor(catalogUpdater, (SimplePlanDescriptor)desc);
        desc = new DefaultSimplePlanDescriptor("standard-monthly", "Standard", ProductCategory.BASE, Currency.USD, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(30), TimeUnit.DAYS, (List)ImmutableList.of());
        this.addBadSimplePlanDescriptor(catalogUpdater, (SimplePlanDescriptor)desc);
    }

    @Test(groups={"fast"})
    public void testPlanWithNonFinalFixedTermPhase() throws Exception {
        StandaloneCatalog catalog = this.getCatalog("SpyCarBasic.xml");
        DefaultMutableStaticCatalog mutableCatalog = new DefaultMutableStaticCatalog(catalog);
        DefaultProduct newProduct = new DefaultProduct();
        newProduct.setName("Something");
        newProduct.setCatagory(ProductCategory.BASE);
        newProduct.initialize((StandaloneCatalog)mutableCatalog);
        mutableCatalog.addProduct((Product)newProduct);
        DefaultPlanPhase trialPhase = new DefaultPlanPhase();
        trialPhase.setPhaseType(PhaseType.TRIAL);
        trialPhase.setDuration(new DefaultDuration().setUnit(TimeUnit.DAYS).setNumber(Integer.valueOf(14)));
        trialPhase.setFixed(new DefaultFixed().setFixedPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.USD).setValue(BigDecimal.ZERO)})));
        DefaultPlanPhase fixedTermPhase = new DefaultPlanPhase();
        fixedTermPhase.setPhaseType(PhaseType.FIXEDTERM);
        fixedTermPhase.setDuration(new DefaultDuration().setUnit(TimeUnit.MONTHS).setNumber(Integer.valueOf(3)));
        fixedTermPhase.setRecurring(new DefaultRecurring().setBillingPeriod(BillingPeriod.MONTHLY).setRecurringPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.USD).setValue(BigDecimal.TEN)})));
        DefaultPlanPhase evergreenPhase = new DefaultPlanPhase();
        evergreenPhase.setPhaseType(PhaseType.EVERGREEN);
        evergreenPhase.setDuration(new DefaultDuration().setUnit(TimeUnit.MONTHS).setNumber(Integer.valueOf(1)));
        evergreenPhase.setRecurring(new DefaultRecurring().setBillingPeriod(BillingPeriod.MONTHLY).setRecurringPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.USD).setValue(BigDecimal.TEN)})));
        DefaultPlan newPlan = new DefaultPlan();
        newPlan.setName("something-with-fixed-term");
        newPlan.setPriceListName("DEFAULT");
        newPlan.setProduct((Product)newProduct);
        newPlan.setInitialPhases(new DefaultPlanPhase[]{trialPhase, fixedTermPhase});
        newPlan.setFinalPhase(fixedTermPhase);
        newPlan.initialize((StandaloneCatalog)mutableCatalog);
        mutableCatalog.addPlan((Plan)newPlan);
        String newCatalogStr = XMLWriter.writeXML((Object)((StandaloneCatalog)mutableCatalog), StandaloneCatalog.class);
        StandaloneCatalog newCatalog = (StandaloneCatalog)XMLLoader.getObjectFromStream((InputStream)new ByteArrayInputStream(newCatalogStr.getBytes(Charset.forName("UTF-8"))), StandaloneCatalog.class);
        DefaultPlan targetPlan = newCatalog.findPlan("something-with-fixed-term");
        Assert.assertEquals((int)targetPlan.getInitialPhases().length, (int)2);
        Assert.assertEquals((Object)targetPlan.getInitialPhases()[1].getPhaseType(), (Object)PhaseType.FIXEDTERM);
    }

    @Test(groups={"fast"})
    public void testVerifyXML() throws Exception {
        StandaloneCatalog originalCatalog = this.getCatalog("SpyCarBasic.xml");
        Assert.assertEquals((int)originalCatalog.getPriceLists().getAllPriceLists().size(), (int)1);
        Assert.assertEquals((String)((PriceList)originalCatalog.getPriceLists().getAllPriceLists().get(0)).getName(), (String)new PriceListDefault().getName());
        Assert.assertEquals((int)((PriceList)originalCatalog.getPriceLists().getAllPriceLists().get(0)).getPlans().size(), (int)3);
        CatalogUpdater catalogUpdater = new CatalogUpdater(originalCatalog);
        DefaultSimplePlanDescriptor desc = new DefaultSimplePlanDescriptor("dynamic-annual", "Dynamic", ProductCategory.BASE, Currency.USD, BigDecimal.TEN, BillingPeriod.MONTHLY, Integer.valueOf(14), TimeUnit.DAYS, (List)ImmutableList.of());
        catalogUpdater.addSimplePlanDescriptor((SimplePlanDescriptor)desc);
        String expectedXML = "<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<catalog>\n    <effectiveDate>2013-02-08T00:00:00Z</effectiveDate>\n    <catalogName>SpyCarBasic</catalogName>\n    <recurringBillingMode>IN_ADVANCE</recurringBillingMode>\n    <currencies>\n        <currency>USD</currency>\n        <currency>GBP</currency>\n    </currencies>\n    <units/>\n    <products>\n        <product name=\"Dynamic\" prettyName=\"Dynamic\">\n            <category>BASE</category>\n            <included/>\n            <available/>\n            <limits/>\n        </product>\n        <product name=\"Sports\" prettyName=\"Sports\">\n            <category>BASE</category>\n            <included/>\n            <available/>\n            <limits/>\n        </product>\n        <product name=\"Standard\" prettyName=\"Standard\">\n            <category>BASE</category>\n            <included/>\n            <available/>\n            <limits/>\n        </product>\n        <product name=\"Super\" prettyName=\"Super\">\n            <category>BASE</category>\n            <included/>\n            <available/>\n            <limits/>\n        </product>\n    </products>\n    <rules>\n        <changePolicy>\n            <changePolicyCase>\n                <policy>IMMEDIATE</policy>\n            </changePolicyCase>\n        </changePolicy>\n        <changeAlignment>\n            <changeAlignmentCase>\n                <alignment>START_OF_BUNDLE</alignment>\n            </changeAlignmentCase>\n        </changeAlignment>\n        <cancelPolicy>\n            <cancelPolicyCase>\n                <policy>IMMEDIATE</policy>\n            </cancelPolicyCase>\n        </cancelPolicy>\n        <createAlignment>\n            <createAlignmentCase>\n                <alignment>START_OF_BUNDLE</alignment>\n            </createAlignmentCase>\n        </createAlignment>\n        <billingAlignment>\n            <billingAlignmentCase>\n                <alignment>ACCOUNT</alignment>\n            </billingAlignmentCase>\n        </billingAlignment>\n        <priceList>\n            <priceListCase>\n                <toPriceList>DEFAULT</toPriceList>\n            </priceListCase>\n        </priceList>\n    </rules>\n    <plans>\n        <plan name=\"dynamic-annual\" prettyName=\"dynamic-annual\">\n            <product>Dynamic</product>\n            <recurringBillingMode>IN_ADVANCE</recurringBillingMode>\n            <initialPhases>\n                <phase type=\"TRIAL\">\n                    <duration>\n                        <unit>DAYS</unit>\n                        <number>14</number>\n                    </duration>\n                    <fixed type=\"ONE_TIME\">\n                        <fixedPrice>\n                            <price>\n<currency>USD</currency>\n<value>0</value>\n                            </price>\n                        </fixedPrice>\n                    </fixed>\n                    <usages/>\n                </phase>\n            </initialPhases>\n            <finalPhase type=\"EVERGREEN\">\n                <duration>\n                    <unit>UNLIMITED</unit>\n                    <number>-1</number>\n                </duration>\n                <recurring>\n                    <billingPeriod>MONTHLY</billingPeriod>\n                    <recurringPrice>\n                        <price>\n                            <currency>USD</currency>\n                            <value>10</value>\n                        </price>\n                    </recurringPrice>\n                </recurring>\n                <usages/>\n            </finalPhase>\n            <plansAllowedInBundle>-1</plansAllowedInBundle>\n        </plan>\n        <plan name=\"sports-monthly\" prettyName=\"sports-monthly\">\n            <product>Sports</product>\n            <recurringBillingMode>IN_ADVANCE</recurringBillingMode>\n            <initialPhases>\n                <phase type=\"TRIAL\">\n                    <duration>\n                        <unit>DAYS</unit>\n                        <number>30</number>\n                    </duration>\n                    <fixed type=\"ONE_TIME\">\n                        <fixedPrice/>\n                    </fixed>\n                    <usages/>\n                </phase>\n            </initialPhases>\n            <finalPhase type=\"EVERGREEN\">\n                <duration>\n                    <unit>UNLIMITED</unit>\n                    <number>-1</number>\n                </duration>\n                <recurring>\n                    <billingPeriod>MONTHLY</billingPeriod>\n                    <recurringPrice>\n                        <price>\n                            <currency>GBP</currency>\n                            <value>375.00</value>\n                        </price>\n                        <price>\n                            <currency>USD</currency>\n                            <value>500.00</value>\n                        </price>\n                    </recurringPrice>\n                </recurring>\n                <usages/>\n            </finalPhase>\n            <plansAllowedInBundle>-1</plansAllowedInBundle>\n        </plan>\n        <plan name=\"standard-monthly\" prettyName=\"standard-monthly\">\n            <product>Standard</product>\n            <recurringBillingMode>IN_ADVANCE</recurringBillingMode>\n            <initialPhases>\n                <phase type=\"TRIAL\">\n                    <duration>\n                        <unit>DAYS</unit>\n                        <number>30</number>\n                    </duration>\n                    <fixed type=\"ONE_TIME\">\n                        <fixedPrice/>\n                    </fixed>\n                    <usages/>\n                </phase>\n            </initialPhases>\n            <finalPhase type=\"EVERGREEN\">\n                <duration>\n                    <unit>UNLIMITED</unit>\n                    <number>-1</number>\n                </duration>\n                <recurring>\n                    <billingPeriod>MONTHLY</billingPeriod>\n                    <recurringPrice>\n                        <price>\n                            <currency>GBP</currency>\n                            <value>75.00</value>\n                        </price>\n                        <price>\n                            <currency>USD</currency>\n                            <value>100.00</value>\n                        </price>\n                    </recurringPrice>\n                </recurring>\n                <usages/>\n            </finalPhase>\n            <plansAllowedInBundle>-1</plansAllowedInBundle>\n        </plan>\n        <plan name=\"super-monthly\" prettyName=\"super-monthly\">\n            <product>Super</product>\n            <recurringBillingMode>IN_ADVANCE</recurringBillingMode>\n            <initialPhases>\n                <phase type=\"TRIAL\">\n                    <duration>\n                        <unit>DAYS</unit>\n                        <number>30</number>\n                    </duration>\n                    <fixed type=\"ONE_TIME\">\n                        <fixedPrice/>\n                    </fixed>\n                    <usages/>\n                </phase>\n            </initialPhases>\n            <finalPhase type=\"EVERGREEN\">\n                <duration>\n                    <unit>UNLIMITED</unit>\n                    <number>-1</number>\n                </duration>\n                <recurring>\n                    <billingPeriod>MONTHLY</billingPeriod>\n                    <recurringPrice>\n                        <price>\n                            <currency>GBP</currency>\n                            <value>750.00</value>\n                        </price>\n                        <price>\n                            <currency>USD</currency>\n                            <value>1000.00</value>\n                        </price>\n                    </recurringPrice>\n                </recurring>\n                <usages/>\n            </finalPhase>\n            <plansAllowedInBundle>-1</plansAllowedInBundle>\n        </plan>\n    </plans>\n    <priceLists>\n        <defaultPriceList name=\"DEFAULT\" prettyName=\"DEFAULT\">\n            <plans>\n                <plan>dynamic-annual</plan>\n                <plan>sports-monthly</plan>\n                <plan>standard-monthly</plan>\n                <plan>super-monthly</plan>\n            </plans>\n        </defaultPriceList>\n    </priceLists>\n</catalog>\n";
        Assert.assertEquals((String)catalogUpdater.getCatalogXML((InternalTenantContext)this.internalCallContext), (String)"<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>\n<catalog>\n    <effectiveDate>2013-02-08T00:00:00Z</effectiveDate>\n    <catalogName>SpyCarBasic</catalogName>\n    <recurringBillingMode>IN_ADVANCE</recurringBillingMode>\n    <currencies>\n        <currency>USD</currency>\n        <currency>GBP</currency>\n    </currencies>\n    <units/>\n    <products>\n        <product name=\"Dynamic\" prettyName=\"Dynamic\">\n            <category>BASE</category>\n            <included/>\n            <available/>\n            <limits/>\n        </product>\n        <product name=\"Sports\" prettyName=\"Sports\">\n            <category>BASE</category>\n            <included/>\n            <available/>\n            <limits/>\n        </product>\n        <product name=\"Standard\" prettyName=\"Standard\">\n            <category>BASE</category>\n            <included/>\n            <available/>\n            <limits/>\n        </product>\n        <product name=\"Super\" prettyName=\"Super\">\n            <category>BASE</category>\n            <included/>\n            <available/>\n            <limits/>\n        </product>\n    </products>\n    <rules>\n        <changePolicy>\n            <changePolicyCase>\n                <policy>IMMEDIATE</policy>\n            </changePolicyCase>\n        </changePolicy>\n        <changeAlignment>\n            <changeAlignmentCase>\n                <alignment>START_OF_BUNDLE</alignment>\n            </changeAlignmentCase>\n        </changeAlignment>\n        <cancelPolicy>\n            <cancelPolicyCase>\n                <policy>IMMEDIATE</policy>\n            </cancelPolicyCase>\n        </cancelPolicy>\n        <createAlignment>\n            <createAlignmentCase>\n                <alignment>START_OF_BUNDLE</alignment>\n            </createAlignmentCase>\n        </createAlignment>\n        <billingAlignment>\n            <billingAlignmentCase>\n                <alignment>ACCOUNT</alignment>\n            </billingAlignmentCase>\n        </billingAlignment>\n        <priceList>\n            <priceListCase>\n                <toPriceList>DEFAULT</toPriceList>\n            </priceListCase>\n        </priceList>\n    </rules>\n    <plans>\n        <plan name=\"dynamic-annual\" prettyName=\"dynamic-annual\">\n            <product>Dynamic</product>\n            <recurringBillingMode>IN_ADVANCE</recurringBillingMode>\n            <initialPhases>\n                <phase type=\"TRIAL\">\n                    <duration>\n                        <unit>DAYS</unit>\n                        <number>14</number>\n                    </duration>\n                    <fixed type=\"ONE_TIME\">\n                        <fixedPrice>\n                            <price>\n<currency>USD</currency>\n<value>0</value>\n                            </price>\n                        </fixedPrice>\n                    </fixed>\n                    <usages/>\n                </phase>\n            </initialPhases>\n            <finalPhase type=\"EVERGREEN\">\n                <duration>\n                    <unit>UNLIMITED</unit>\n                    <number>-1</number>\n                </duration>\n                <recurring>\n                    <billingPeriod>MONTHLY</billingPeriod>\n                    <recurringPrice>\n                        <price>\n                            <currency>USD</currency>\n                            <value>10</value>\n                        </price>\n                    </recurringPrice>\n                </recurring>\n                <usages/>\n            </finalPhase>\n            <plansAllowedInBundle>-1</plansAllowedInBundle>\n        </plan>\n        <plan name=\"sports-monthly\" prettyName=\"sports-monthly\">\n            <product>Sports</product>\n            <recurringBillingMode>IN_ADVANCE</recurringBillingMode>\n            <initialPhases>\n                <phase type=\"TRIAL\">\n                    <duration>\n                        <unit>DAYS</unit>\n                        <number>30</number>\n                    </duration>\n                    <fixed type=\"ONE_TIME\">\n                        <fixedPrice/>\n                    </fixed>\n                    <usages/>\n                </phase>\n            </initialPhases>\n            <finalPhase type=\"EVERGREEN\">\n                <duration>\n                    <unit>UNLIMITED</unit>\n                    <number>-1</number>\n                </duration>\n                <recurring>\n                    <billingPeriod>MONTHLY</billingPeriod>\n                    <recurringPrice>\n                        <price>\n                            <currency>GBP</currency>\n                            <value>375.00</value>\n                        </price>\n                        <price>\n                            <currency>USD</currency>\n                            <value>500.00</value>\n                        </price>\n                    </recurringPrice>\n                </recurring>\n                <usages/>\n            </finalPhase>\n            <plansAllowedInBundle>-1</plansAllowedInBundle>\n        </plan>\n        <plan name=\"standard-monthly\" prettyName=\"standard-monthly\">\n            <product>Standard</product>\n            <recurringBillingMode>IN_ADVANCE</recurringBillingMode>\n            <initialPhases>\n                <phase type=\"TRIAL\">\n                    <duration>\n                        <unit>DAYS</unit>\n                        <number>30</number>\n                    </duration>\n                    <fixed type=\"ONE_TIME\">\n                        <fixedPrice/>\n                    </fixed>\n                    <usages/>\n                </phase>\n            </initialPhases>\n            <finalPhase type=\"EVERGREEN\">\n                <duration>\n                    <unit>UNLIMITED</unit>\n                    <number>-1</number>\n                </duration>\n                <recurring>\n                    <billingPeriod>MONTHLY</billingPeriod>\n                    <recurringPrice>\n                        <price>\n                            <currency>GBP</currency>\n                            <value>75.00</value>\n                        </price>\n                        <price>\n                            <currency>USD</currency>\n                            <value>100.00</value>\n                        </price>\n                    </recurringPrice>\n                </recurring>\n                <usages/>\n            </finalPhase>\n            <plansAllowedInBundle>-1</plansAllowedInBundle>\n        </plan>\n        <plan name=\"super-monthly\" prettyName=\"super-monthly\">\n            <product>Super</product>\n            <recurringBillingMode>IN_ADVANCE</recurringBillingMode>\n            <initialPhases>\n                <phase type=\"TRIAL\">\n                    <duration>\n                        <unit>DAYS</unit>\n                        <number>30</number>\n                    </duration>\n                    <fixed type=\"ONE_TIME\">\n                        <fixedPrice/>\n                    </fixed>\n                    <usages/>\n                </phase>\n            </initialPhases>\n            <finalPhase type=\"EVERGREEN\">\n                <duration>\n                    <unit>UNLIMITED</unit>\n                    <number>-1</number>\n                </duration>\n                <recurring>\n                    <billingPeriod>MONTHLY</billingPeriod>\n                    <recurringPrice>\n                        <price>\n                            <currency>GBP</currency>\n                            <value>750.00</value>\n                        </price>\n                        <price>\n                            <currency>USD</currency>\n                            <value>1000.00</value>\n                        </price>\n                    </recurringPrice>\n                </recurring>\n                <usages/>\n            </finalPhase>\n            <plansAllowedInBundle>-1</plansAllowedInBundle>\n        </plan>\n    </plans>\n    <priceLists>\n        <defaultPriceList name=\"DEFAULT\" prettyName=\"DEFAULT\">\n            <plans>\n                <plan>dynamic-annual</plan>\n                <plan>sports-monthly</plan>\n                <plan>standard-monthly</plan>\n                <plan>super-monthly</plan>\n            </plans>\n        </defaultPriceList>\n    </priceLists>\n</catalog>\n");
        System.err.println(catalogUpdater.getCatalogXML((InternalTenantContext)this.internalCallContext));
    }

    private StandaloneCatalog enhanceOriginalCatalogForInvalidTestCases(String catalogName) throws Exception {
        StandaloneCatalog catalog = (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)catalogName).toExternalForm(), StandaloneCatalog.class);
        DefaultMutableStaticCatalog mutableCatalog = new DefaultMutableStaticCatalog(catalog);
        DefaultProduct newProduct1 = new DefaultProduct();
        newProduct1.setName("Dynamic");
        newProduct1.setCatagory(ProductCategory.BASE);
        newProduct1.initialize((StandaloneCatalog)mutableCatalog);
        mutableCatalog.addProduct((Product)newProduct1);
        DefaultPlanPhase discountPhase1 = new DefaultPlanPhase();
        discountPhase1.setPhaseType(PhaseType.DISCOUNT);
        discountPhase1.setDuration(new DefaultDuration().setUnit(TimeUnit.DAYS).setNumber(Integer.valueOf(14)));
        discountPhase1.setRecurring(new DefaultRecurring().setBillingPeriod(BillingPeriod.MONTHLY).setRecurringPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.USD).setValue(BigDecimal.TEN)})));
        DefaultPlanPhase evergreenPhase1 = new DefaultPlanPhase();
        evergreenPhase1.setPhaseType(PhaseType.EVERGREEN);
        evergreenPhase1.setDuration(new DefaultDuration().setUnit(TimeUnit.MONTHS).setNumber(Integer.valueOf(1)));
        evergreenPhase1.setRecurring(new DefaultRecurring().setBillingPeriod(BillingPeriod.MONTHLY).setRecurringPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.USD).setValue(BigDecimal.TEN)})));
        DefaultPlan newPlan1 = new DefaultPlan();
        newPlan1.setName("dynamic-monthly");
        newPlan1.setPriceListName("DEFAULT");
        newPlan1.setProduct((Product)newProduct1);
        newPlan1.setInitialPhases(new DefaultPlanPhase[]{discountPhase1});
        newPlan1.setFinalPhase(evergreenPhase1);
        newPlan1.initialize((StandaloneCatalog)mutableCatalog);
        mutableCatalog.addPlan((Plan)newPlan1);
        DefaultProduct newProduct2 = new DefaultProduct();
        newProduct2.setName("SuperDynamic");
        newProduct2.setCatagory(ProductCategory.BASE);
        newProduct2.initialize((StandaloneCatalog)mutableCatalog);
        mutableCatalog.addProduct((Product)newProduct2);
        DefaultPlanPhase fixedterm2 = new DefaultPlanPhase();
        fixedterm2.setPhaseType(PhaseType.FIXEDTERM);
        fixedterm2.setDuration(new DefaultDuration().setUnit(TimeUnit.MONTHS).setNumber(Integer.valueOf(3)));
        fixedterm2.setRecurring(new DefaultRecurring().setBillingPeriod(BillingPeriod.MONTHLY).setRecurringPrice(new DefaultInternationalPrice().setPrices(new DefaultPrice[]{new DefaultPrice().setCurrency(Currency.USD).setValue(BigDecimal.TEN)})));
        DefaultPlan newPlan2 = new DefaultPlan();
        newPlan2.setName("superdynamic-fixedterm");
        newPlan2.setPriceListName("DEFAULT");
        newPlan2.setProduct((Product)newProduct2);
        newPlan2.setFinalPhase(fixedterm2);
        newPlan2.initialize((StandaloneCatalog)mutableCatalog);
        mutableCatalog.addPlan((Plan)newPlan2);
        String newCatalogStr = XMLWriter.writeXML((Object)((StandaloneCatalog)mutableCatalog), StandaloneCatalog.class);
        return (StandaloneCatalog)XMLLoader.getObjectFromStream((InputStream)new ByteArrayInputStream(newCatalogStr.getBytes(Charset.forName("UTF-8"))), StandaloneCatalog.class);
    }

    private void addBadSimplePlanDescriptor(CatalogUpdater catalogUpdater, SimplePlanDescriptor desc) {
        try {
            catalogUpdater.addSimplePlanDescriptor(desc);
            Assert.fail((String)("Should have failed to add invalid desc " + desc));
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_FAILED_SIMPLE_PLAN_VALIDATION.getCode());
        }
    }
}

