/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import javax.annotation.Nullable;
import org.killbill.billing.catalog.DefaultDuration;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.MockFixed;
import org.killbill.billing.catalog.MockInternationalPrice;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockRecurring;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.TimeUnit;

public class MockPlanPhase
extends DefaultPlanPhase {
    public static MockPlanPhase create1USDMonthlyEvergreen() {
        return (MockPlanPhase)new MockPlanPhase(BillingPeriod.MONTHLY, PhaseType.EVERGREEN, new DefaultDuration().setUnit(TimeUnit.UNLIMITED).setNumber(Integer.valueOf(-1)), MockInternationalPrice.create1USD(), null).setPlan((Plan)MockPlan.createBicycleNoTrialEvergreen1USD());
    }

    public static MockPlanPhase createUSDMonthlyEvergreen(String reccuringUSDPrice, String fixedPrice) {
        return new MockPlanPhase(BillingPeriod.MONTHLY, PhaseType.EVERGREEN, new DefaultDuration().setUnit(TimeUnit.UNLIMITED).setNumber(Integer.valueOf(-1)), reccuringUSDPrice == null ? null : MockInternationalPrice.createUSD(reccuringUSDPrice), fixedPrice == null ? null : MockInternationalPrice.createUSD(fixedPrice));
    }

    public static MockPlanPhase createUSDMonthlyFixedTerm(String reccuringUSDPrice, String fixedPrice, int durationInMonths) {
        return new MockPlanPhase(BillingPeriod.MONTHLY, PhaseType.FIXEDTERM, new DefaultDuration().setUnit(TimeUnit.MONTHS).setNumber(Integer.valueOf(durationInMonths)), reccuringUSDPrice == null ? null : MockInternationalPrice.createUSD(reccuringUSDPrice), fixedPrice == null ? null : MockInternationalPrice.createUSD(fixedPrice));
    }

    public static MockPlanPhase create30DayTrial() {
        return MockPlanPhase.createTrial(30);
    }

    public static MockPlanPhase createTrial(int days) {
        return new MockPlanPhase(BillingPeriod.NO_BILLING_PERIOD, PhaseType.TRIAL, new DefaultDuration().setUnit(TimeUnit.DAYS).setNumber(Integer.valueOf(days)), null, MockInternationalPrice.create1USD());
    }

    public MockPlanPhase(BillingPeriod billingPeriod, PhaseType type, DefaultDuration duration, DefaultInternationalPrice recurringPrice, DefaultInternationalPrice fixedPrice) {
        this.setPhaseType(type);
        this.setDuration(duration);
        this.setFixed(new MockFixed(fixedPrice));
        this.setRecurring(new MockRecurring(billingPeriod, recurringPrice).setPhase((PlanPhase)this));
    }

    public MockPlanPhase() {
        this(new MockInternationalPrice(new DefaultPrice[0]), null);
    }

    public MockPlanPhase(@Nullable MockInternationalPrice recurringPrice, @Nullable MockInternationalPrice fixedPrice) {
        this(recurringPrice, fixedPrice, BillingPeriod.MONTHLY);
    }

    public MockPlanPhase(@Nullable MockInternationalPrice recurringPrice, @Nullable MockInternationalPrice fixedPrice, BillingPeriod billingPeriod) {
        this(recurringPrice, fixedPrice, billingPeriod, PhaseType.EVERGREEN);
    }

    public MockPlanPhase(@Nullable MockInternationalPrice recurringPrice, @Nullable MockInternationalPrice fixedPrice, BillingPeriod billingPeriod, PhaseType phaseType) {
        this.setPhaseType(phaseType);
        this.setDuration(new DefaultDuration().setNumber(Integer.valueOf(-1)).setUnit(TimeUnit.UNLIMITED));
        this.setPlan((Plan)new MockPlan(this));
        this.setFixed(new MockFixed(fixedPrice));
        this.setRecurring(new MockRecurring(billingPeriod, recurringPrice));
    }

    public MockPlanPhase(MockPlan mockPlan) {
        this.setPhaseType(PhaseType.EVERGREEN);
        this.setDuration(new DefaultDuration().setNumber(Integer.valueOf(-1)).setUnit(TimeUnit.UNLIMITED));
        this.setPlan((Plan)mockPlan);
        this.setFixed(new MockFixed(null));
        this.setRecurring(new MockRecurring(BillingPeriod.MONTHLY, new MockInternationalPrice(new DefaultPrice[0])));
    }

    public MockPlanPhase(Plan plan, PhaseType phaseType) {
        this.setPhaseType(phaseType);
        this.setDuration(new DefaultDuration().setNumber(Integer.valueOf(-1)).setUnit(TimeUnit.UNLIMITED));
        this.setPlan(plan);
        this.setFixed(new MockFixed(null));
        this.setRecurring(new MockRecurring(BillingPeriod.MONTHLY, new MockInternationalPrice(new DefaultPrice[0])));
    }
}

