/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.Date;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.MockPlanPhase;
import org.killbill.billing.catalog.MockProduct;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.Product;

public class MockPlan
extends DefaultPlan {
    public static MockPlan createBicycleTrialEvergreen1USD(int trialDurationInDays) {
        return new MockPlan("1-BicycleTrialEvergreen1USD", MockProduct.createBicycle(), new DefaultPlanPhase[]{MockPlanPhase.createTrial(trialDurationInDays)}, MockPlanPhase.create1USDMonthlyEvergreen(), -1);
    }

    public static MockPlan createBicycleTrialEvergreen1USD() {
        return new MockPlan("1-BicycleTrialEvergreen1USD", MockProduct.createBicycle(), new DefaultPlanPhase[]{MockPlanPhase.create30DayTrial()}, MockPlanPhase.create1USDMonthlyEvergreen(), -1);
    }

    public static MockPlan createSportsCarTrialEvergreen100USD() {
        return new MockPlan("4-SportsCarTrialEvergreen100USD", MockProduct.createSportsCar(), new DefaultPlanPhase[]{MockPlanPhase.create30DayTrial()}, MockPlanPhase.createUSDMonthlyEvergreen("100.00", null), -1);
    }

    public static MockPlan createPickupTrialEvergreen10USD() {
        return new MockPlan("3-PickupTrialEvergreen10USD", MockProduct.createPickup(), new DefaultPlanPhase[]{MockPlanPhase.create30DayTrial()}, MockPlanPhase.createUSDMonthlyEvergreen("10.00", null), -1);
    }

    public static MockPlan createJetTrialEvergreen1000USD() {
        return new MockPlan("5-JetTrialEvergreen1000USD", MockProduct.createJet(), new DefaultPlanPhase[]{MockPlanPhase.create30DayTrial()}, MockPlanPhase.create1USDMonthlyEvergreen(), -1);
    }

    public static MockPlan createJetTrialFixedTermEvergreen1000USD() {
        return new MockPlan("6-JetTrialEvergreen1000USD", MockProduct.createJet(), new DefaultPlanPhase[]{MockPlanPhase.create30DayTrial(), MockPlanPhase.createUSDMonthlyFixedTerm("500.00", null, 6)}, MockPlanPhase.create1USDMonthlyEvergreen(), -1);
    }

    public static MockPlan createHornMonthlyNoTrial1USD() {
        return new MockPlan("7-Horn1USD", MockProduct.createHorn(), new DefaultPlanPhase[0], MockPlanPhase.create1USDMonthlyEvergreen(), -1);
    }

    public MockPlan() {
        this("1-BicycleTrialEvergreen1USD", MockProduct.createBicycle(), new DefaultPlanPhase[]{MockPlanPhase.create30DayTrial()}, MockPlanPhase.create1USDMonthlyEvergreen(), -1);
    }

    public MockPlan(String name, DefaultProduct product, DefaultPlanPhase[] planPhases, DefaultPlanPhase finalPhase, int plansAllowedInBundle) {
        this.root = new StandaloneCatalog(new Date());
        this.setName(name);
        this.setProduct((Product)product);
        this.setFinalPhase(finalPhase);
        this.setInitialPhases(planPhases);
        this.setPlansAllowedInBundle(plansAllowedInBundle);
        this.setRecurringBillingMode(BillingMode.IN_ADVANCE);
        this.setPriceListName("DEFAULT");
        finalPhase.setPlan((Plan)this);
        for (DefaultPlanPhase pp : planPhases) {
            pp.setPlan((Plan)this);
        }
    }

    public static MockPlan createBicycleNoTrialEvergreen1USD() {
        return new MockPlan("2-BicycleNoTrialEvergreen1USD", MockProduct.createBicycle(), new DefaultPlanPhase[0], MockPlanPhase.createUSDMonthlyEvergreen("1.0", null), -1);
    }

    public MockPlan(MockPlanPhase mockPlanPhase) {
        this.root = new StandaloneCatalog(new Date());
        this.setName("Test");
        this.setProduct((Product)MockProduct.createBicycle());
        this.setFinalPhase(mockPlanPhase);
        this.setRecurringBillingMode(BillingMode.IN_ADVANCE);
        mockPlanPhase.setPlan((Plan)this);
    }

    public MockPlan(String planName) {
        this.root = new StandaloneCatalog(new Date());
        this.setName(planName);
        this.setProduct((Product)new MockProduct());
        this.setFinalPhase(new MockPlanPhase(this));
        this.setInitialPhases(null);
        this.setRecurringBillingMode(BillingMode.IN_ADVANCE);
        this.setPlansAllowedInBundle(1);
    }

    public static Collection<Plan> createAll() {
        return ImmutableList.of((Object)((Object)MockPlan.createBicycleTrialEvergreen1USD()), (Object)((Object)MockPlan.createBicycleNoTrialEvergreen1USD()), (Object)((Object)MockPlan.createPickupTrialEvergreen10USD()), (Object)((Object)MockPlan.createSportsCarTrialEvergreen100USD()), (Object)((Object)MockPlan.createJetTrialEvergreen1000USD()), (Object)((Object)MockPlan.createJetTrialFixedTermEvergreen1000USD()), (Object)((Object)MockPlan.createHornMonthlyNoTrial1USD()));
    }
}

