/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultPriceListSet;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.MockPlan;
import org.killbill.billing.catalog.MockProduct;
import org.killbill.billing.catalog.PriceListDefault;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingAlignment;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanAlignmentCreate;
import org.killbill.billing.catalog.api.PlanChangeResult;
import org.killbill.billing.catalog.rules.DefaultPlanRules;

public class MockCatalog
extends StandaloneCatalog {
    private PlanChangeResult planChange;
    private BillingAlignment billingAlignment;
    private PlanAlignmentCreate planCreateAlignment;

    public MockCatalog() {
        this.setUnits(new DefaultUnit[0]);
        this.setEffectiveDate(new Date());
        this.setProducts(MockProduct.createAll());
        this.setPlans(MockPlan.createAll());
        this.populateRules();
        this.populatePriceLists();
        this.initialize(this);
    }

    public void populateRules() {
        this.setPlanRules(new DefaultPlanRules());
    }

    public void populatePriceLists() {
        Collection plans = this.getPlans();
        DefaultPriceList[] priceList = new DefaultPriceList[plans.size() - 1];
        int i = 1;
        Iterator it = plans.iterator();
        Plan initialPlan = (Plan)it.next();
        while (it.hasNext()) {
            Plan plan = (Plan)it.next();
            priceList[i - 1] = new DefaultPriceList(new DefaultPlan[]{(DefaultPlan)plan}, plan.getName() + "-pl");
            ++i;
        }
        DefaultPriceListSet set = new DefaultPriceListSet((DefaultPriceList)new PriceListDefault(new DefaultPlan[]{(DefaultPlan)initialPlan}), priceList);
        this.setPriceLists(set);
    }

    public DefaultProduct getCurrentProduct(int idx) {
        return (DefaultProduct)this.getProducts().toArray()[idx];
    }

    public void setPlanChange(PlanChangeResult planChange) {
        this.planChange = planChange;
    }

    public void setBillingAlignment(BillingAlignment billingAlignment) {
        this.billingAlignment = billingAlignment;
    }

    public void setPlanCreateAlignment(PlanAlignmentCreate planCreateAlignment) {
        this.planCreateAlignment = planCreateAlignment;
    }
}

