/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.io.Resources;
import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.killbill.billing.GuicyKillbillTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.caching.PriceOverridePattern;
import org.killbill.billing.catalog.dao.CatalogOverrideDao;
import org.killbill.billing.catalog.glue.TestCatalogModuleWithEmbeddedDB;
import org.killbill.billing.catalog.override.PriceOverride;
import org.killbill.xmlloader.XMLLoader;
import org.skife.jdbi.v2.IDBI;
import org.testng.annotations.BeforeClass;

public class CatalogTestSuiteWithEmbeddedDB
extends GuicyKillbillTestSuiteWithEmbeddedDB {
    @Inject
    protected CatalogOverrideDao catalogOverrideDao;
    @Inject
    protected IDBI dbi;
    @Inject
    protected PriceOverride priceOverride;
    @Inject
    PriceOverridePattern priceOverridePattern;

    @BeforeClass(groups={"slow"})
    protected void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        Injector injector = Guice.createInjector((Module[])new Module[]{new TestCatalogModuleWithEmbeddedDB(this.configSource, this.clock)});
        injector.injectMembers((Object)this);
    }

    protected StandaloneCatalog getCatalog(String name) throws Exception {
        return (StandaloneCatalog)XMLLoader.getObjectFromString((String)Resources.getResource((String)("org/killbill/billing/catalog/" + name)).toExternalForm(), StandaloneCatalog.class);
    }
}

