/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.rules;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.rules.DefaultCaseStandardNaming;
import org.killbill.xmlloader.ValidationErrors;

public abstract class DefaultCasePhase<T>
extends DefaultCaseStandardNaming<T>
implements Externalizable {
    @XmlElement(required=false)
    protected PhaseType phaseType;

    public T getResult(PlanPhaseSpecifier specifier, StaticCatalog c) throws CatalogApiException {
        if ((this.phaseType == null || specifier.getPhaseType() == this.phaseType) && this.satisfiesCase(new PlanSpecifier(specifier), c)) {
            return this.getResult();
        }
        return null;
    }

    public static <K> K getResult(DefaultCasePhase<K>[] cases, PlanPhaseSpecifier planSpec, StaticCatalog catalog) throws CatalogApiException {
        if (cases != null) {
            for (DefaultCasePhase<K> cp : cases) {
                K result = cp.getResult(planSpec, catalog);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    @Override
    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        return errors;
    }

    @Override
    public void initialize(StandaloneCatalog catalog) {
        super.initialize(catalog);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
    }

    public DefaultCasePhase<T> setPhaseType(PhaseType phaseType) {
        this.phaseType = phaseType;
        return this;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultCasePhase)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultCasePhase that = (DefaultCasePhase)o;
        return this.phaseType == that.phaseType;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.phaseType != null ? this.phaseType.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.phaseType != null);
        if (this.phaseType != null) {
            out.writeUTF(this.phaseType.name());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.phaseType = in.readBoolean() ? PhaseType.valueOf((String)in.readUTF()) : null;
    }
}

