/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.rules;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.api.rules.CaseChange;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public abstract class DefaultCaseChange<T>
extends ValidatingConfig<StandaloneCatalog>
implements CaseChange,
Externalizable {
    @XmlElement(required=false)
    protected PhaseType phaseType;
    @XmlElement(required=false)
    @XmlIDREF
    private DefaultProduct fromProduct;
    @XmlElement(required=false)
    private ProductCategory fromProductCategory;
    @XmlElement(required=false)
    private BillingPeriod fromBillingPeriod;
    @XmlElement(required=false)
    @XmlIDREF
    private DefaultPriceList fromPriceList;
    @XmlElement(required=false)
    @XmlIDREF
    private DefaultProduct toProduct;
    @XmlElement(required=false)
    private ProductCategory toProductCategory;
    @XmlElement(required=false)
    private BillingPeriod toBillingPeriod;
    @XmlElement(required=false)
    @XmlIDREF
    private DefaultPriceList toPriceList;

    protected abstract T getResult();

    public T getResult(PlanPhaseSpecifier from, PlanSpecifier to, StaticCatalog catalog) throws CatalogApiException {
        PriceList inToPriceList;
        ProductCategory inToProductCategory;
        BillingPeriod inToBillingPeriod;
        Product inToProduct;
        PriceList inFromPriceList;
        ProductCategory inFromProductCategory;
        BillingPeriod inFromBillingPeriod;
        Product inFromProduct;
        if (from.getPlanName() != null) {
            Plan plan = catalog.findCurrentPlan(from.getPlanName());
            inFromProduct = plan.getProduct();
            inFromBillingPeriod = plan.getRecurringBillingPeriod();
            inFromProductCategory = plan.getProduct().getCategory();
            inFromPriceList = catalog.findCurrentPricelist(plan.getPriceListName());
        } else {
            inFromProduct = catalog.findCurrentProduct(from.getProductName());
            inFromBillingPeriod = from.getBillingPeriod();
            inFromProductCategory = inFromProduct.getCategory();
            PriceList priceList = inFromPriceList = from.getPriceListName() != null ? catalog.findCurrentPricelist(from.getPriceListName()) : null;
        }
        if (to.getPlanName() != null) {
            Plan plan = catalog.findCurrentPlan(to.getPlanName());
            inToProduct = plan.getProduct();
            inToBillingPeriod = plan.getRecurringBillingPeriod();
            inToProductCategory = plan.getProduct().getCategory();
            inToPriceList = catalog.findCurrentPricelist(plan.getPriceListName());
        } else {
            inToProduct = catalog.findCurrentProduct(to.getProductName());
            inToBillingPeriod = to.getBillingPeriod();
            inToProductCategory = inToProduct.getCategory();
            PriceList priceList = inToPriceList = to.getPriceListName() != null ? catalog.findCurrentPricelist(to.getPriceListName()) : null;
        }
        if (!(this.phaseType != null && from.getPhaseType() != this.phaseType || this.fromProduct != null && !this.fromProduct.equals(inFromProduct) || this.fromProductCategory != null && !this.fromProductCategory.equals((Object)inFromProductCategory) || this.fromBillingPeriod != null && !this.fromBillingPeriod.equals((Object)inFromBillingPeriod) || this.toProduct != null && !this.toProduct.equals(inToProduct) || this.toProductCategory != null && !this.toProductCategory.equals((Object)inToProductCategory) || this.toBillingPeriod != null && !this.toBillingPeriod.equals((Object)inToBillingPeriod) || this.fromPriceList != null && !this.fromPriceList.equals(inFromPriceList) || this.toPriceList != null && !this.toPriceList.equals(inToPriceList))) {
            return this.getResult();
        }
        return null;
    }

    public static <K> K getResult(DefaultCaseChange<K>[] cases, PlanPhaseSpecifier from, PlanSpecifier to, StaticCatalog catalog) throws CatalogApiException {
        if (cases != null) {
            for (DefaultCaseChange<K> cc : cases) {
                K result = cc.getResult(from, to, catalog);
                if (result == null) continue;
                return result;
            }
        }
        return null;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        return errors;
    }

    public void initialize(StandaloneCatalog catalog) {
        super.initialize((Object)catalog);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
    }

    public DefaultCaseChange<T> setPhaseType(PhaseType phaseType) {
        this.phaseType = phaseType;
        return this;
    }

    public DefaultCaseChange<T> setFromProduct(Product fromProduct) {
        this.fromProduct = (DefaultProduct)fromProduct;
        return this;
    }

    public DefaultCaseChange<T> setFromProductCategory(ProductCategory fromProductCategory) {
        this.fromProductCategory = fromProductCategory;
        return this;
    }

    public DefaultCaseChange<T> setFromBillingPeriod(BillingPeriod fromBillingPeriod) {
        this.fromBillingPeriod = fromBillingPeriod;
        return this;
    }

    public DefaultCaseChange<T> setFromPriceList(DefaultPriceList fromPriceList) {
        this.fromPriceList = fromPriceList;
        return this;
    }

    public DefaultCaseChange<T> setToProduct(Product toProduct) {
        this.toProduct = (DefaultProduct)toProduct;
        return this;
    }

    public DefaultCaseChange<T> setToProductCategory(ProductCategory toProductCategory) {
        this.toProductCategory = toProductCategory;
        return this;
    }

    public DefaultCaseChange<T> setToBillingPeriod(BillingPeriod toBillingPeriod) {
        this.toBillingPeriod = toBillingPeriod;
        return this;
    }

    public DefaultCaseChange<T> setToPriceList(DefaultPriceList toPriceList) {
        this.toPriceList = toPriceList;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultCaseChange)) {
            return false;
        }
        DefaultCaseChange that = (DefaultCaseChange)o;
        if (this.fromBillingPeriod != that.fromBillingPeriod) {
            return false;
        }
        if (this.fromPriceList != null ? !this.fromPriceList.equals(that.fromPriceList) : that.fromPriceList != null) {
            return false;
        }
        if (this.fromProduct != null ? !this.fromProduct.equals(that.fromProduct) : that.fromProduct != null) {
            return false;
        }
        if (this.fromProductCategory != that.fromProductCategory) {
            return false;
        }
        if (this.phaseType != that.phaseType) {
            return false;
        }
        if (this.toBillingPeriod != that.toBillingPeriod) {
            return false;
        }
        if (this.toPriceList != null ? !this.toPriceList.equals(that.toPriceList) : that.toPriceList != null) {
            return false;
        }
        if (this.toProduct != null ? !this.toProduct.equals(that.toProduct) : that.toProduct != null) {
            return false;
        }
        return this.toProductCategory == that.toProductCategory;
    }

    public int hashCode() {
        int result = this.phaseType != null ? this.phaseType.hashCode() : 0;
        result = 31 * result + (this.fromProduct != null ? this.fromProduct.hashCode() : 0);
        result = 31 * result + (this.fromProductCategory != null ? this.fromProductCategory.hashCode() : 0);
        result = 31 * result + (this.fromBillingPeriod != null ? this.fromBillingPeriod.hashCode() : 0);
        result = 31 * result + (this.fromPriceList != null ? this.fromPriceList.hashCode() : 0);
        result = 31 * result + (this.toProduct != null ? this.toProduct.hashCode() : 0);
        result = 31 * result + (this.toProductCategory != null ? this.toProductCategory.hashCode() : 0);
        result = 31 * result + (this.toBillingPeriod != null ? this.toBillingPeriod.hashCode() : 0);
        result = 31 * result + (this.toPriceList != null ? this.toPriceList.hashCode() : 0);
        return result;
    }

    public PhaseType getPhaseType() {
        return this.phaseType;
    }

    public Product getFromProduct() {
        return this.fromProduct;
    }

    public ProductCategory getFromProductCategory() {
        return this.fromProductCategory;
    }

    public BillingPeriod getFromBillingPeriod() {
        return this.fromBillingPeriod;
    }

    public PriceList getFromPriceList() {
        return this.fromPriceList;
    }

    public Product getToProduct() {
        return this.toProduct;
    }

    public ProductCategory getToProductCategory() {
        return this.toProductCategory;
    }

    public BillingPeriod getToBillingPeriod() {
        return this.toBillingPeriod;
    }

    public PriceList getToPriceList() {
        return this.toPriceList;
    }

    public String toString() {
        return "DefaultCaseChange{phaseType=" + this.phaseType + ", fromProduct=" + this.fromProduct + ", fromProductCategory=" + this.fromProductCategory + ", fromBillingPeriod=" + this.fromBillingPeriod + ", fromPriceList=" + this.fromPriceList + ", toProduct=" + this.toProduct + ", toProductCategory=" + this.toProductCategory + ", toBillingPeriod=" + this.toBillingPeriod + ", toPriceList=" + this.toPriceList + '}';
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.phaseType != null);
        if (this.phaseType != null) {
            out.writeUTF(this.phaseType.name());
        }
        out.writeObject(this.fromProduct);
        out.writeBoolean(this.fromProductCategory != null);
        if (this.fromProductCategory != null) {
            out.writeUTF(this.fromProductCategory.name());
        }
        out.writeBoolean(this.fromBillingPeriod != null);
        if (this.fromBillingPeriod != null) {
            out.writeUTF(this.fromBillingPeriod.name());
        }
        out.writeObject(this.fromPriceList);
        out.writeObject(this.toProduct);
        out.writeBoolean(this.toProductCategory != null);
        if (this.toProductCategory != null) {
            out.writeUTF(this.toProductCategory.name());
        }
        out.writeBoolean(this.toBillingPeriod != null);
        if (this.toBillingPeriod != null) {
            out.writeUTF(this.toBillingPeriod.name());
        }
        out.writeObject(this.toPriceList);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.phaseType = in.readBoolean() ? PhaseType.valueOf((String)in.readUTF()) : null;
        this.fromProduct = (DefaultProduct)in.readObject();
        this.fromProductCategory = in.readBoolean() ? ProductCategory.valueOf((String)in.readUTF()) : null;
        this.fromBillingPeriod = in.readBoolean() ? BillingPeriod.valueOf((String)in.readUTF()) : null;
        this.fromPriceList = (DefaultPriceList)in.readObject();
        this.toProduct = (DefaultProduct)in.readObject();
        this.toProductCategory = in.readBoolean() ? ProductCategory.valueOf((String)in.readUTF()) : null;
        this.toBillingPeriod = in.readBoolean() ? BillingPeriod.valueOf((String)in.readUTF()) : null;
        this.toPriceList = (DefaultPriceList)in.readObject();
    }
}

