/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.rules;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingActionPolicy;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.rules.CaseCancelPolicy;
import org.killbill.billing.catalog.rules.DefaultCasePhase;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

public class DefaultCaseCancelPolicy
extends DefaultCasePhase<BillingActionPolicy>
implements CaseCancelPolicy,
Externalizable {
    @XmlElement(required=true)
    private BillingActionPolicy policy;

    @Override
    protected BillingActionPolicy getResult() {
        return this.policy;
    }

    public DefaultCaseCancelPolicy setPolicy(BillingActionPolicy policy) {
        this.policy = policy;
        return this;
    }

    @Override
    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.policy == BillingActionPolicy.START_OF_TERM) {
            errors.add((Object)new ValidationError("Default catalog START_OF_TERM has not been implemented, such policy can be used during cancellation by overriding policy", DefaultCaseCancelPolicy.class, ""));
        }
        return errors;
    }

    public BillingActionPolicy getBillingActionPolicy() {
        return this.policy;
    }

    public PhaseType getPhaseType() {
        return this.phaseType;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultCaseCancelPolicy)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        DefaultCaseCancelPolicy that = (DefaultCaseCancelPolicy)o;
        return this.policy == that.policy;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
        return result;
    }

    public String toString() {
        return "DefaultCaseCancelPolicy{policy =" + this.policy + ", phaseType =" + this.getPhaseType() + ", product=" + this.getProduct() + ", productCategory=" + this.getProductCategory() + ", billingPeriod=" + this.getBillingPeriod() + ", priceList=" + this.getPriceList() + '}';
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeBoolean(this.policy != null);
        if (this.policy != null) {
            out.writeUTF(this.policy.name());
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.policy = in.readBoolean() ? BillingActionPolicy.valueOf((String)in.readUTF()) : null;
    }
}

