/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.provider;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import javax.inject.Inject;
import org.killbill.billing.catalog.plugin.api.CatalogPluginApi;
import org.killbill.billing.osgi.api.OSGIServiceDescriptor;
import org.killbill.billing.osgi.api.OSGIServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCatalogProviderPluginRegistry
implements OSGIServiceRegistration<CatalogPluginApi> {
    private static final Logger log = LoggerFactory.getLogger(DefaultCatalogProviderPluginRegistry.class);
    private final Map<String, CatalogPluginApi> pluginsByName = new ConcurrentHashMap<String, CatalogPluginApi>();

    @Inject
    public DefaultCatalogProviderPluginRegistry() {
    }

    public void registerService(OSGIServiceDescriptor desc, CatalogPluginApi service) {
        log.info("Registering service='{}'", (Object)desc.getRegistrationName());
        this.pluginsByName.put(desc.getRegistrationName(), service);
    }

    public void unregisterService(String serviceName) {
        log.info("Unregistering service='{}'", (Object)serviceName);
        this.pluginsByName.remove(serviceName);
    }

    public CatalogPluginApi getServiceForName(String serviceName) {
        if (serviceName == null) {
            throw new IllegalArgumentException("Null catalog plugin API name");
        }
        CatalogPluginApi plugin = this.pluginsByName.get(serviceName);
        return plugin;
    }

    public Set<String> getAllServices() {
        return this.pluginsByName.keySet();
    }

    public Class<CatalogPluginApi> getServiceType() {
        return CatalogPluginApi.class;
    }
}

