/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.override;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.joda.time.DateTime;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultPlan;
import org.killbill.billing.catalog.DefaultPlanPhase;
import org.killbill.billing.catalog.DefaultPlanPhasePriceOverride;
import org.killbill.billing.catalog.DefaultTierPriceOverride;
import org.killbill.billing.catalog.DefaultTieredBlockPriceOverride;
import org.killbill.billing.catalog.DefaultUsagePriceOverride;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.Tier;
import org.killbill.billing.catalog.api.TierPriceOverride;
import org.killbill.billing.catalog.api.TieredBlock;
import org.killbill.billing.catalog.api.TieredBlockPriceOverride;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.catalog.api.UsagePriceOverride;
import org.killbill.billing.catalog.caching.OverriddenPlanCache;
import org.killbill.billing.catalog.dao.CatalogOverrideDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanDefinitionModelDao;
import org.killbill.billing.catalog.override.PriceOverride;

public class DefaultPriceOverride
implements PriceOverride {
    private static final AtomicLong DRY_RUN_PLAN_IDX = new AtomicLong(0L);
    public static final Pattern CUSTOM_PLAN_NAME_PATTERN = Pattern.compile("(.*)-(\\d+)$");
    private final CatalogOverrideDao overrideDao;
    private final OverriddenPlanCache overriddenPlanCache;

    @Inject
    public DefaultPriceOverride(CatalogOverrideDao overrideDao, OverriddenPlanCache overriddenPlanCache) {
        this.overrideDao = overrideDao;
        this.overriddenPlanCache = overriddenPlanCache;
    }

    @Override
    public DefaultPlan getOrCreateOverriddenPlan(StandaloneCatalog standaloneCatalog, Plan parentPlan, DateTime catalogEffectiveDate, List<PlanPhasePriceOverride> overrides, @Nullable InternalCallContext context) throws CatalogApiException {
        String planName;
        PlanPhasePriceOverride[] resolvedOverride = new PlanPhasePriceOverride[parentPlan.getAllPhases().length];
        int index = 0;
        for (final PlanPhase curPhase : parentPlan.getAllPhases()) {
            PlanPhasePriceOverride curOverride = (PlanPhasePriceOverride)Iterables.tryFind(overrides, (Predicate)new Predicate<PlanPhasePriceOverride>(){

                public boolean apply(PlanPhasePriceOverride input) {
                    if (input.getPhaseName() != null) {
                        return input.getPhaseName().equals(curPhase.getName());
                    }
                    PlanPhaseSpecifier curPlanPhaseSpecifier = input.getPlanPhaseSpecifier();
                    return curPlanPhaseSpecifier.getPhaseType().equals((Object)curPhase.getPhaseType());
                }
            }).orNull();
            if (curOverride != null) {
                List<UsagePriceOverride> resolvedUsageOverrides = this.getResolvedUsageOverrides(curPhase.getUsages(), curOverride.getUsagePriceOverrides());
                resolvedOverride[index++] = new DefaultPlanPhasePriceOverride(curPhase.getName(), curOverride.getCurrency(), curOverride.getFixedPrice(), curOverride.getRecurringPrice(), resolvedUsageOverrides);
                continue;
            }
            resolvedOverride[index++] = null;
        }
        for (int i = 0; i < resolvedOverride.length; ++i) {
            String error;
            PlanPhasePriceOverride curOverride = resolvedOverride[i];
            if (curOverride == null) continue;
            DefaultPlanPhase curPhase = (DefaultPlanPhase)parentPlan.getAllPhases()[i];
            if (curPhase.getFixed() == null && curOverride.getFixedPrice() != null) {
                error = String.format("There is no existing fixed price for the phase %s", curPhase.getName());
                throw new CatalogApiException(ErrorCode.CAT_INVALID_INVALID_PRICE_OVERRIDE, new Object[]{parentPlan.getName(), error});
            }
            if (curPhase.getRecurring() != null || curOverride.getRecurringPrice() == null) continue;
            error = String.format("There is no existing recurring price for the phase %s", curPhase.getName());
            throw new CatalogApiException(ErrorCode.CAT_INVALID_INVALID_PRICE_OVERRIDE, new Object[]{parentPlan.getName(), error});
        }
        if (context != null) {
            CatalogOverridePlanDefinitionModelDao overriddenPlan = this.overrideDao.getOrCreateOverridePlanDefinition(parentPlan, catalogEffectiveDate, resolvedOverride, context);
            planName = new StringBuffer(parentPlan.getName()).append("-").append(overriddenPlan.getRecordId()).toString();
        } else {
            planName = new StringBuffer(parentPlan.getName()).append("-dryrun-").append(DRY_RUN_PLAN_IDX.incrementAndGet()).toString();
        }
        DefaultPlan result = new DefaultPlan(standaloneCatalog, planName, (DefaultPlan)parentPlan, resolvedOverride);
        result.initialize(standaloneCatalog);
        if (context == null) {
            this.overriddenPlanCache.addDryRunPlan(planName, result);
        }
        return result;
    }

    public List<UsagePriceOverride> getResolvedUsageOverrides(Usage[] usages, List<UsagePriceOverride> usagePriceOverrides) throws CatalogApiException {
        ArrayList<UsagePriceOverride> resolvedUsageOverrides = new ArrayList<UsagePriceOverride>();
        for (final Usage curUsage : usages) {
            UsagePriceOverride curOverride = (UsagePriceOverride)Iterables.tryFind(usagePriceOverrides, (Predicate)new Predicate<UsagePriceOverride>(){

                public boolean apply(UsagePriceOverride input) {
                    return input.getName() != null && input.getName().equals(curUsage.getName());
                }
            }).orNull();
            if (curOverride != null) {
                List<TierPriceOverride> tierPriceOverrides = this.getResolvedTierOverrides(curUsage.getTiers(), curOverride.getTierPriceOverrides());
                resolvedUsageOverrides.add(new DefaultUsagePriceOverride(curUsage.getName(), curUsage.getUsageType(), tierPriceOverrides));
                continue;
            }
            resolvedUsageOverrides.add(null);
        }
        return resolvedUsageOverrides;
    }

    public List<TierPriceOverride> getResolvedTierOverrides(Tier[] tiers, List<TierPriceOverride> tierPriceOverrides) throws CatalogApiException {
        ArrayList<TierPriceOverride> resolvedTierOverrides = new ArrayList<TierPriceOverride>();
        for (final Tier curTier : tiers) {
            TierPriceOverride curOverride = (TierPriceOverride)Iterables.tryFind(tierPriceOverrides, (Predicate)new Predicate<TierPriceOverride>(){

                public boolean apply(TierPriceOverride input) {
                    if (input.getTieredBlockPriceOverrides() != null) {
                        for (TieredBlockPriceOverride blockPriceOverride : input.getTieredBlockPriceOverrides()) {
                            String unitName = blockPriceOverride.getUnitName();
                            Double max = blockPriceOverride.getMax();
                            Double size = blockPriceOverride.getSize();
                            for (int i = 0; i < curTier.getTieredBlocks().length; ++i) {
                                TieredBlock curTieredBlock = curTier.getTieredBlocks()[i];
                                if (!unitName.equals(curTieredBlock.getUnit().getName()) || Double.compare(size, curTieredBlock.getSize()) != 0 || Double.compare(max, curTieredBlock.getMax()) != 0) continue;
                                return true;
                            }
                        }
                    }
                    return false;
                }
            }).orNull();
            if (curOverride != null) {
                List<TieredBlockPriceOverride> tieredBlockPriceOverrides = this.getResolvedTieredBlockPriceOverrides(curTier.getTieredBlocks(), curOverride.getTieredBlockPriceOverrides());
                resolvedTierOverrides.add(new DefaultTierPriceOverride(tieredBlockPriceOverrides));
                continue;
            }
            resolvedTierOverrides.add(null);
        }
        return resolvedTierOverrides;
    }

    public List<TieredBlockPriceOverride> getResolvedTieredBlockPriceOverrides(TieredBlock[] tieredBlocks, List<TieredBlockPriceOverride> tieredBlockPriceOverrides) throws CatalogApiException {
        ArrayList<TieredBlockPriceOverride> resolvedTieredBlockPriceOverrides = new ArrayList<TieredBlockPriceOverride>();
        for (final TieredBlock curTieredBlock : tieredBlocks) {
            TieredBlockPriceOverride curOverride = (TieredBlockPriceOverride)Iterables.tryFind(tieredBlockPriceOverrides, (Predicate)new Predicate<TieredBlockPriceOverride>(){

                public boolean apply(TieredBlockPriceOverride input) {
                    return input.getUnitName() != null && input.getSize() != null && input.getMax() != null && input.getUnitName().equals(curTieredBlock.getUnit().getName()) && Double.compare(input.getSize(), curTieredBlock.getSize()) == 0 && Double.compare(input.getMax(), curTieredBlock.getMax()) == 0;
                }
            }).orNull();
            if (curOverride != null) {
                resolvedTieredBlockPriceOverrides.add(new DefaultTieredBlockPriceOverride(curTieredBlock.getUnit().getName(), curOverride.getSize(), curOverride.getPrice(), curOverride.getCurrency(), curOverride.getMax()));
                continue;
            }
            resolvedTieredBlockPriceOverrides.add(null);
        }
        return resolvedTieredBlockPriceOverrides;
    }

    @Override
    public DefaultPlan getOverriddenPlan(String planName, StandaloneCatalog catalog, InternalTenantContext context) throws CatalogApiException {
        return this.overriddenPlanCache.getOverriddenPlan(planName, catalog, context);
    }
}

