/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import com.google.inject.Inject;
import java.util.ArrayList;
import java.util.List;
import org.joda.time.DateTime;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.Tier;
import org.killbill.billing.catalog.api.TierPriceOverride;
import org.killbill.billing.catalog.api.TieredBlockPriceOverride;
import org.killbill.billing.catalog.api.Usage;
import org.killbill.billing.catalog.api.UsagePriceOverride;
import org.killbill.billing.catalog.dao.CatalogOverrideBlockDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideBlockDefinitionSqlDao;
import org.killbill.billing.catalog.dao.CatalogOverrideDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseDefinitionSqlDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseUsageModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePhaseUsageSqlDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanDefinitionSqlDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanPhaseModelDao;
import org.killbill.billing.catalog.dao.CatalogOverridePlanPhaseSqlDao;
import org.killbill.billing.catalog.dao.CatalogOverrideTierBlockModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideTierBlockSqlDao;
import org.killbill.billing.catalog.dao.CatalogOverrideTierDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideTierDefinitionSqlDao;
import org.killbill.billing.catalog.dao.CatalogOverrideUsageDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideUsageDefinitionSqlDao;
import org.killbill.billing.catalog.dao.CatalogOverrideUsageTierModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideUsageTierSqlDao;
import org.killbill.clock.Clock;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.IDBI;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;

public class DefaultCatalogOverrideDao
implements CatalogOverrideDao {
    private final IDBI dbi;
    private final Clock clock;

    @Inject
    public DefaultCatalogOverrideDao(IDBI dbi, Clock clock) {
        this.dbi = dbi;
        this.clock = clock;
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverridePlanDefinitionModelDao.class));
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverridePhaseDefinitionModelDao.class));
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverridePlanPhaseModelDao.class));
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverrideBlockDefinitionModelDao.class));
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverrideTierBlockModelDao.class));
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverrideTierDefinitionModelDao.class));
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverrideUsageDefinitionModelDao.class));
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverrideUsageTierModelDao.class));
        ((DBI)dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverridePhaseUsageModelDao.class));
    }

    @Override
    public CatalogOverridePlanDefinitionModelDao getOrCreateOverridePlanDefinition(final Plan parentPlan, final DateTime catalogEffectiveDate, final PlanPhasePriceOverride[] resolvedOverride, final InternalCallContext context) {
        return (CatalogOverridePlanDefinitionModelDao)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<CatalogOverridePlanDefinitionModelDao>(){

            public CatalogOverridePlanDefinitionModelDao inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverridePhaseDefinitionModelDao[] overridePhaseDefinitionModelDaos = new CatalogOverridePhaseDefinitionModelDao[resolvedOverride.length];
                for (int i = 0; i < resolvedOverride.length; ++i) {
                    CatalogOverridePhaseDefinitionModelDao createdOverridePhaseDefinitionModelDao;
                    PlanPhasePriceOverride curOverride = resolvedOverride[i];
                    if (curOverride == null) continue;
                    PlanPhase parentPlanPhase = parentPlan.getAllPhases()[i];
                    overridePhaseDefinitionModelDaos[i] = createdOverridePhaseDefinitionModelDao = DefaultCatalogOverrideDao.this.getOrCreateOverridePhaseDefinitionFromTransaction(parentPlanPhase, curOverride.getPhaseName(), curOverride.getCurrency(), catalogEffectiveDate, curOverride, handle, context);
                }
                CatalogOverridePlanDefinitionSqlDao sqlDao = (CatalogOverridePlanDefinitionSqlDao)handle.attach(CatalogOverridePlanDefinitionSqlDao.class);
                Long targetPlanDefinitionRecordId = DefaultCatalogOverrideDao.this.getOverridePlanDefinitionFromTransaction(overridePhaseDefinitionModelDaos, handle, context);
                if (targetPlanDefinitionRecordId != null) {
                    return sqlDao.getByRecordId(targetPlanDefinitionRecordId, (InternalTenantContext)context);
                }
                CatalogOverridePlanDefinitionModelDao inputPlanDef = new CatalogOverridePlanDefinitionModelDao(parentPlan.getName(), true, catalogEffectiveDate);
                sqlDao.create(inputPlanDef, context);
                Long recordId = sqlDao.getLastInsertId();
                CatalogOverridePlanDefinitionModelDao resultPlanDef = sqlDao.getByRecordId(recordId, (InternalTenantContext)context);
                for (short i = 0; i < overridePhaseDefinitionModelDaos.length; i = (short)((short)(i + 1))) {
                    if (overridePhaseDefinitionModelDaos[i] == null) continue;
                    DefaultCatalogOverrideDao.this.createCatalogOverridePlanPhaseFromTransaction(i, overridePhaseDefinitionModelDaos[i], resultPlanDef, handle, context);
                }
                return resultPlanDef;
            }
        });
    }

    private Long getOverridePlanDefinitionFromTransaction(CatalogOverridePhaseDefinitionModelDao[] overridePhaseDefinitionModelDaos, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverridePlanPhaseSqlDao sqlDao = (CatalogOverridePlanPhaseSqlDao)inTransactionHandle.attach(CatalogOverridePlanPhaseSqlDao.class);
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < overridePhaseDefinitionModelDaos.length; ++i) {
            CatalogOverridePhaseDefinitionModelDao cur = overridePhaseDefinitionModelDaos[i];
            if (cur == null) continue;
            keys.add(this.getConcatenatedKey(i, cur.getRecordId()).toString());
        }
        return keys.size() > 0 ? sqlDao.getTargetPlanDefinition(keys, keys.size(), (InternalTenantContext)context) : null;
    }

    private void createCatalogOverridePlanPhaseFromTransaction(short phaseNum, CatalogOverridePhaseDefinitionModelDao phaseDef, CatalogOverridePlanDefinitionModelDao planDef, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverridePlanPhaseSqlDao sqlDao = (CatalogOverridePlanPhaseSqlDao)inTransactionHandle.attach(CatalogOverridePlanPhaseSqlDao.class);
        CatalogOverridePlanPhaseModelDao modelDao = new CatalogOverridePlanPhaseModelDao(phaseNum, phaseDef.getRecordId(), planDef.getRecordId());
        sqlDao.create(modelDao, context);
    }

    private CatalogOverridePhaseDefinitionModelDao getOrCreateOverridePhaseDefinitionFromTransaction(PlanPhase parentPlanPhase, String parentPhaseName, Currency currency, DateTime catalogEffectiveDate, PlanPhasePriceOverride override, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverridePhaseDefinitionSqlDao sqlDao = (CatalogOverridePhaseDefinitionSqlDao)inTransactionHandle.attach(CatalogOverridePhaseDefinitionSqlDao.class);
        if (override.getUsagePriceOverrides() == null || override.getUsagePriceOverrides() != null && this.isUsageOverrideListHasOnlyNull(override.getUsagePriceOverrides())) {
            return this.getOrCreatePhaseDefinitionFromTransactionWithoutUsageOverrides(parentPhaseName, catalogEffectiveDate, override, inTransactionHandle, context);
        }
        CatalogOverrideUsageDefinitionModelDao[] overrideUsageDefinitionModelDaos = new CatalogOverrideUsageDefinitionModelDao[override.getUsagePriceOverrides().size()];
        List resolvedUsageOverrides = override.getUsagePriceOverrides();
        for (int i = 0; i < resolvedUsageOverrides.size(); ++i) {
            CatalogOverrideUsageDefinitionModelDao createdOverrideUsageDefinitionModelDao;
            UsagePriceOverride curOverride = (UsagePriceOverride)resolvedUsageOverrides.get(i);
            if (curOverride == null) continue;
            Usage parentUsage = parentPlanPhase.getUsages()[i];
            overrideUsageDefinitionModelDaos[i] = createdOverrideUsageDefinitionModelDao = this.getOrCreateOverrideUsageDefinitionFromTransaction(parentUsage, currency, catalogEffectiveDate, curOverride, inTransactionHandle, context);
        }
        List<Long> targetPhaseDefinitionRecordIds = this.getOverridePhaseDefinitionFromTransaction(overrideUsageDefinitionModelDaos, inTransactionHandle, context);
        List<CatalogOverridePhaseDefinitionModelDao> results = sqlDao.getByAttributes(parentPhaseName, override.getCurrency().name(), override.getFixedPrice(), override.getRecurringPrice(), (InternalTenantContext)context);
        for (CatalogOverridePhaseDefinitionModelDao phase : results) {
            if (targetPhaseDefinitionRecordIds == null || !targetPhaseDefinitionRecordIds.contains(phase.getRecordId())) continue;
            return phase;
        }
        CatalogOverridePhaseDefinitionModelDao inputPhaseDef = new CatalogOverridePhaseDefinitionModelDao(parentPhaseName, override.getCurrency().name(), override.getFixedPrice(), override.getRecurringPrice(), catalogEffectiveDate);
        sqlDao.create(inputPhaseDef, context);
        Long recordId = sqlDao.getLastInsertId();
        CatalogOverridePhaseDefinitionModelDao resultPhaseDef = sqlDao.getByRecordId(recordId, (InternalTenantContext)context);
        for (short i = 0; i < overrideUsageDefinitionModelDaos.length; i = (short)((short)(i + 1))) {
            if (overrideUsageDefinitionModelDaos[i] == null) continue;
            this.createCatalogOverridePhaseUsageFromTransaction(i, overrideUsageDefinitionModelDaos[i], resultPhaseDef, inTransactionHandle, context);
        }
        return resultPhaseDef;
    }

    private CatalogOverridePhaseDefinitionModelDao getOrCreatePhaseDefinitionFromTransactionWithoutUsageOverrides(String parentPhaseName, DateTime catalogEffectiveDate, PlanPhasePriceOverride override, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverridePhaseDefinitionSqlDao sqlDao = (CatalogOverridePhaseDefinitionSqlDao)inTransactionHandle.attach(CatalogOverridePhaseDefinitionSqlDao.class);
        List<CatalogOverridePhaseDefinitionModelDao> resultPhases = sqlDao.getByAttributes(parentPhaseName, override.getCurrency().name(), override.getFixedPrice(), override.getRecurringPrice(), (InternalTenantContext)context);
        for (CatalogOverridePhaseDefinitionModelDao resultPhase : resultPhases) {
            if (resultPhase == null || this.getOverriddenPhaseUsages(resultPhase.getRecordId(), (InternalTenantContext)context).size() != 0) continue;
            return resultPhase;
        }
        CatalogOverridePhaseDefinitionModelDao phaseDef = new CatalogOverridePhaseDefinitionModelDao(parentPhaseName, override.getCurrency().name(), override.getFixedPrice(), override.getRecurringPrice(), catalogEffectiveDate);
        sqlDao.create(phaseDef, context);
        Long recordId = sqlDao.getLastInsertId();
        return sqlDao.getByRecordId(recordId, (InternalTenantContext)context);
    }

    private List<Long> getOverridePhaseDefinitionFromTransaction(CatalogOverrideUsageDefinitionModelDao[] overrideUsageDefinitionModelDaos, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverridePhaseUsageSqlDao sqlDao = (CatalogOverridePhaseUsageSqlDao)inTransactionHandle.attach(CatalogOverridePhaseUsageSqlDao.class);
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < overrideUsageDefinitionModelDaos.length; ++i) {
            CatalogOverrideUsageDefinitionModelDao cur = overrideUsageDefinitionModelDaos[i];
            if (cur == null) continue;
            keys.add(this.getConcatenatedKey(i, cur.getRecordId()).toString());
        }
        return keys.size() > 0 ? sqlDao.getTargetPhaseDefinition(keys, keys.size(), (InternalTenantContext)context) : null;
    }

    private void createCatalogOverridePhaseUsageFromTransaction(short usageNum, CatalogOverrideUsageDefinitionModelDao usageDef, CatalogOverridePhaseDefinitionModelDao phaseDef, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverridePhaseUsageSqlDao sqlDao = (CatalogOverridePhaseUsageSqlDao)inTransactionHandle.attach(CatalogOverridePhaseUsageSqlDao.class);
        CatalogOverridePhaseUsageModelDao modelDao = new CatalogOverridePhaseUsageModelDao(usageNum, usageDef.getRecordId(), phaseDef.getRecordId());
        sqlDao.create(modelDao, context);
    }

    private CatalogOverrideUsageDefinitionModelDao getOrCreateOverrideUsageDefinitionFromTransaction(Usage parentUsage, Currency currency, DateTime catalogEffectiveDate, UsagePriceOverride override, Handle inTransactionHandle, InternalCallContext context) {
        List resolvedTierOverrides = override.getTierPriceOverrides();
        CatalogOverrideTierDefinitionModelDao[] overrideTierDefinitionModelDaos = new CatalogOverrideTierDefinitionModelDao[resolvedTierOverrides.size()];
        for (int i = 0; i < resolvedTierOverrides.size(); ++i) {
            Object createdOverrideTierDefinitionModelDao;
            TierPriceOverride curOverride = (TierPriceOverride)resolvedTierOverrides.get(i);
            if (curOverride == null) continue;
            Tier parentTier = parentUsage.getTiers()[i];
            overrideTierDefinitionModelDaos[i] = createdOverrideTierDefinitionModelDao = this.getOrCreateOverrideTierDefinitionFromTransaction(parentTier, curOverride, currency, catalogEffectiveDate, inTransactionHandle, context);
        }
        CatalogOverrideUsageDefinitionSqlDao sqlDao = (CatalogOverrideUsageDefinitionSqlDao)inTransactionHandle.attach(CatalogOverrideUsageDefinitionSqlDao.class);
        List<Long> targetUsageDefinitionRecordIds = this.getOverrideUsageDefinitionFromTransaction(overrideTierDefinitionModelDaos, inTransactionHandle, context);
        List<CatalogOverrideUsageDefinitionModelDao> results = sqlDao.getByAttributes(parentUsage.getName(), (InternalTenantContext)context);
        for (CatalogOverrideUsageDefinitionModelDao usage : results) {
            if (targetUsageDefinitionRecordIds == null || !targetUsageDefinitionRecordIds.contains(usage.getRecordId())) continue;
            return usage;
        }
        CatalogOverrideUsageDefinitionModelDao inputUsageDef = new CatalogOverrideUsageDefinitionModelDao(parentUsage.getName(), parentUsage.getUsageType().name(), currency.name(), null, null, catalogEffectiveDate);
        sqlDao.create(inputUsageDef, context);
        Long recordId = sqlDao.getLastInsertId();
        CatalogOverrideUsageDefinitionModelDao resultUsageDef = sqlDao.getByRecordId(recordId, (InternalTenantContext)context);
        for (short i = 0; i < overrideTierDefinitionModelDaos.length; i = (short)((short)(i + 1))) {
            if (overrideTierDefinitionModelDaos[i] == null) continue;
            this.createCatalogOverrideUsageTierFromTransaction(i, overrideTierDefinitionModelDaos[i], resultUsageDef, inTransactionHandle, context);
        }
        return resultUsageDef;
    }

    private List<Long> getOverrideUsageDefinitionFromTransaction(CatalogOverrideTierDefinitionModelDao[] overrideTierDefinitionModelDaos, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverrideUsageTierSqlDao sqlDao = (CatalogOverrideUsageTierSqlDao)inTransactionHandle.attach(CatalogOverrideUsageTierSqlDao.class);
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < overrideTierDefinitionModelDaos.length; ++i) {
            CatalogOverrideTierDefinitionModelDao cur = overrideTierDefinitionModelDaos[i];
            if (cur == null) continue;
            keys.add(this.getConcatenatedKey(i, cur.getRecordId()).toString());
        }
        return keys.size() > 0 ? sqlDao.getTargetUsageDefinition(keys, keys.size(), (InternalTenantContext)context) : null;
    }

    private void createCatalogOverrideUsageTierFromTransaction(short tierNum, CatalogOverrideTierDefinitionModelDao tierDef, CatalogOverrideUsageDefinitionModelDao usageDef, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverrideUsageTierSqlDao sqlDao = (CatalogOverrideUsageTierSqlDao)inTransactionHandle.attach(CatalogOverrideUsageTierSqlDao.class);
        CatalogOverrideUsageTierModelDao modelDao = new CatalogOverrideUsageTierModelDao(tierNum, tierDef.getRecordId(), usageDef.getRecordId());
        sqlDao.create(modelDao, context);
    }

    private CatalogOverrideTierDefinitionModelDao getOrCreateOverrideTierDefinitionFromTransaction(Tier parentTier, TierPriceOverride tierPriceOverride, Currency currency, DateTime catalogEffectiveDate, Handle inTransactionHandle, InternalCallContext context) {
        List resolvedTierBlockOverrides = tierPriceOverride.getTieredBlockPriceOverrides();
        CatalogOverrideBlockDefinitionModelDao[] overrideBlockDefinitionModelDaos = new CatalogOverrideBlockDefinitionModelDao[resolvedTierBlockOverrides.size()];
        for (int i = 0; i < resolvedTierBlockOverrides.size(); ++i) {
            CatalogOverrideBlockDefinitionModelDao createdOverrideBlockDefinitionModelDao;
            TieredBlockPriceOverride curOverride = (TieredBlockPriceOverride)resolvedTierBlockOverrides.get(i);
            if (curOverride == null) continue;
            overrideBlockDefinitionModelDaos[i] = createdOverrideBlockDefinitionModelDao = this.getOrCreateOverriddenBlockDefinitionFromTransaction(curOverride, catalogEffectiveDate, currency.name(), inTransactionHandle, context);
        }
        CatalogOverrideTierDefinitionSqlDao sqlDao = (CatalogOverrideTierDefinitionSqlDao)inTransactionHandle.attach(CatalogOverrideTierDefinitionSqlDao.class);
        Long targetTierDefinitionRecordId = this.getOverrideTierDefinitionFromTransaction(overrideBlockDefinitionModelDaos, inTransactionHandle, context);
        if (targetTierDefinitionRecordId != null) {
            return sqlDao.getByRecordId(targetTierDefinitionRecordId, (InternalTenantContext)context);
        }
        CatalogOverrideTierDefinitionModelDao inputTierDef = new CatalogOverrideTierDefinitionModelDao(currency.name(), null, null, catalogEffectiveDate);
        sqlDao.create(inputTierDef, context);
        Long recordId = sqlDao.getLastInsertId();
        CatalogOverrideTierDefinitionModelDao resultTierDef = sqlDao.getByRecordId(recordId, (InternalTenantContext)context);
        for (short i = 0; i < overrideBlockDefinitionModelDaos.length; i = (short)((short)(i + 1))) {
            if (overrideBlockDefinitionModelDaos[i] == null) continue;
            this.createCatalogOverrideTierBlockFromTransaction(i, overrideBlockDefinitionModelDaos[i], resultTierDef, inTransactionHandle, context);
        }
        return resultTierDef;
    }

    private void createCatalogOverrideTierBlockFromTransaction(short blockNum, CatalogOverrideBlockDefinitionModelDao blockDef, CatalogOverrideTierDefinitionModelDao tierDef, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverrideTierBlockSqlDao sqlDao = (CatalogOverrideTierBlockSqlDao)inTransactionHandle.attach(CatalogOverrideTierBlockSqlDao.class);
        CatalogOverrideTierBlockModelDao modelDao = new CatalogOverrideTierBlockModelDao(blockNum, blockDef.getRecordId(), tierDef.getRecordId());
        sqlDao.create(modelDao, context);
    }

    private Long getOverrideTierDefinitionFromTransaction(CatalogOverrideBlockDefinitionModelDao[] overrideBlockDefinitionModelDaos, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverrideTierBlockSqlDao sqlDao = (CatalogOverrideTierBlockSqlDao)inTransactionHandle.attach(CatalogOverrideTierBlockSqlDao.class);
        ArrayList<String> keys = new ArrayList<String>();
        for (int i = 0; i < overrideBlockDefinitionModelDaos.length; ++i) {
            CatalogOverrideBlockDefinitionModelDao cur = overrideBlockDefinitionModelDaos[i];
            if (cur == null) continue;
            keys.add(this.getConcatenatedKey(i, cur.getRecordId()).toString());
        }
        return keys.size() > 0 ? sqlDao.getTargetTierDefinition(keys, keys.size(), (InternalTenantContext)context) : null;
    }

    private CatalogOverrideBlockDefinitionModelDao getOrCreateOverriddenBlockDefinitionFromTransaction(TieredBlockPriceOverride tieredBlockPriceOverride, DateTime catalogEffectiveDate, String currency, Handle inTransactionHandle, InternalCallContext context) {
        CatalogOverrideBlockDefinitionSqlDao sqlDao = (CatalogOverrideBlockDefinitionSqlDao)inTransactionHandle.attach(CatalogOverrideBlockDefinitionSqlDao.class);
        CatalogOverrideBlockDefinitionModelDao result = sqlDao.getByAttributes(tieredBlockPriceOverride.getUnitName(), currency, tieredBlockPriceOverride.getPrice(), tieredBlockPriceOverride.getMax(), tieredBlockPriceOverride.getSize(), (InternalTenantContext)context);
        if (result == null) {
            CatalogOverrideBlockDefinitionModelDao blockDef = new CatalogOverrideBlockDefinitionModelDao(tieredBlockPriceOverride.getUnitName(), currency, tieredBlockPriceOverride.getPrice(), tieredBlockPriceOverride.getSize(), tieredBlockPriceOverride.getMax(), catalogEffectiveDate);
            sqlDao.create(blockDef, context);
            Long recordId = sqlDao.getLastInsertId();
            result = sqlDao.getByRecordId(recordId, (InternalTenantContext)context);
        }
        return result;
    }

    @Override
    public List<CatalogOverridePhaseDefinitionModelDao> getOverriddenPlanPhases(final Long planDefRecordId, final InternalTenantContext context) {
        return (List)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<List<CatalogOverridePhaseDefinitionModelDao>>(){

            public List<CatalogOverridePhaseDefinitionModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverridePhaseDefinitionSqlDao sqlDao = (CatalogOverridePhaseDefinitionSqlDao)handle.attach(CatalogOverridePhaseDefinitionSqlDao.class);
                return sqlDao.getOverriddenPlanPhases(planDefRecordId, context);
            }
        });
    }

    @Override
    public List<CatalogOverrideUsageDefinitionModelDao> getOverriddenPhaseUsages(final Long phaseDefRecordId, final InternalTenantContext context) {
        return (List)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<List<CatalogOverrideUsageDefinitionModelDao>>(){

            public List<CatalogOverrideUsageDefinitionModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverrideUsageDefinitionSqlDao sqlDao = (CatalogOverrideUsageDefinitionSqlDao)handle.attach(CatalogOverrideUsageDefinitionSqlDao.class);
                return sqlDao.getOverriddenPhaseUsages(phaseDefRecordId, context);
            }
        });
    }

    @Override
    public List<CatalogOverrideTierDefinitionModelDao> getOverriddenUsageTiers(final Long usageDefRecordId, final InternalTenantContext context) {
        return (List)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<List<CatalogOverrideTierDefinitionModelDao>>(){

            public List<CatalogOverrideTierDefinitionModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverrideTierDefinitionSqlDao sqlDao = (CatalogOverrideTierDefinitionSqlDao)handle.attach(CatalogOverrideTierDefinitionSqlDao.class);
                return sqlDao.getOverriddenUsageTiers(usageDefRecordId, context);
            }
        });
    }

    @Override
    public List<CatalogOverrideBlockDefinitionModelDao> getOverriddenTierBlocks(final Long tierDefRecordId, final InternalTenantContext context) {
        return (List)this.dbi.inTransaction((TransactionCallback)new TransactionCallback<List<CatalogOverrideBlockDefinitionModelDao>>(){

            public List<CatalogOverrideBlockDefinitionModelDao> inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverrideBlockDefinitionSqlDao sqlDao = (CatalogOverrideBlockDefinitionSqlDao)handle.attach(CatalogOverrideBlockDefinitionSqlDao.class);
                return sqlDao.getOverriddenTierBlocks(tierDefRecordId, context);
            }
        });
    }

    private boolean isUsageOverrideListHasOnlyNull(List<UsagePriceOverride> usagePriceOverrides) {
        for (UsagePriceOverride override : usagePriceOverrides) {
            if (override == null) continue;
            return false;
        }
        return true;
    }

    private StringBuffer getConcatenatedKey(int index, Long recordId) {
        StringBuffer key = new StringBuffer();
        key.append(index);
        key.append(",");
        key.append(recordId);
        return key;
    }
}

