/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultLimit;
import org.killbill.billing.catalog.DefaultTieredBlock;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingMode;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Tier;
import org.killbill.billing.catalog.api.TierPriceOverride;
import org.killbill.billing.catalog.api.TieredBlock;
import org.killbill.billing.catalog.api.TieredBlockPriceOverride;
import org.killbill.billing.catalog.api.UsageType;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultTier
extends ValidatingConfig<StandaloneCatalog>
implements Tier,
Externalizable {
    @XmlElementWrapper(name="limits", required=false)
    @XmlElement(name="limit", required=false)
    private DefaultLimit[] limits;
    @XmlElementWrapper(name="blocks", required=false)
    @XmlElement(name="tieredBlock", required=false)
    private DefaultTieredBlock[] blocks;
    @XmlElement(required=false)
    private DefaultInternationalPrice fixedPrice;
    @XmlElement(required=false)
    private DefaultInternationalPrice recurringPrice;
    private BillingMode billingMode;
    private UsageType usageType;
    private PlanPhase phase;

    public DefaultTier() {
    }

    public DefaultTier(Tier in, TierPriceOverride override, Currency currency) {
        this.limits = (DefaultLimit[])in.getLimits();
        this.blocks = new DefaultTieredBlock[in.getTieredBlocks().length];
        for (int i = 0; i < in.getTieredBlocks().length; ++i) {
            if (override != null && override.getTieredBlockPriceOverrides() != null) {
                final TieredBlock curTieredBlock = in.getTieredBlocks()[i];
                TieredBlockPriceOverride overriddenTierBlock = (TieredBlockPriceOverride)Iterables.tryFind((Iterable)override.getTieredBlockPriceOverrides(), (Predicate)new Predicate<TieredBlockPriceOverride>(){

                    public boolean apply(TieredBlockPriceOverride input) {
                        return input != null && input.getUnitName().equals(curTieredBlock.getUnit().getName()) && Double.compare(input.getSize(), curTieredBlock.getSize()) == 0 && Double.compare(input.getMax(), curTieredBlock.getMax()) == 0;
                    }
                }).orNull();
                this.blocks[i] = overriddenTierBlock != null ? new DefaultTieredBlock(in.getTieredBlocks()[i], overriddenTierBlock, currency) : (DefaultTieredBlock)in.getTieredBlocks()[i];
                continue;
            }
            this.blocks[i] = (DefaultTieredBlock)in.getTieredBlocks()[i];
        }
    }

    public DefaultLimit[] getLimits() {
        return this.limits;
    }

    public DefaultTieredBlock[] getTieredBlocks() {
        return this.blocks;
    }

    public InternationalPrice getFixedPrice() {
        return this.fixedPrice;
    }

    public InternationalPrice getRecurringPrice() {
        return this.recurringPrice;
    }

    public DefaultTier setLimits(DefaultLimit[] limits) {
        this.limits = limits;
        return this;
    }

    public DefaultTier setBlocks(DefaultTieredBlock[] blocks) {
        this.blocks = blocks;
        return this;
    }

    public void setBillingMode(BillingMode billingMode) {
        this.billingMode = billingMode;
    }

    public void setUsageType(UsageType usageType) {
        this.usageType = usageType;
    }

    public DefaultTier setPhase(PlanPhase phase) {
        this.phase = phase;
        return this;
    }

    public DefaultTier setFixedPrice(DefaultInternationalPrice fixedPrice) {
        this.fixedPrice = fixedPrice;
        return this;
    }

    public DefaultTier setRecurringPrice(DefaultInternationalPrice recurringPrice) {
        this.recurringPrice = recurringPrice;
        return this;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.billingMode == BillingMode.IN_ARREAR && this.usageType == UsageType.CAPACITY && this.limits.length == 0) {
            errors.add((Object)new ValidationError(String.format("Usage [IN_ARREAR CAPACITY] section of phase %s needs to define some limits", this.phase.getName()), DefaultUsage.class, ""));
        }
        if (this.billingMode == BillingMode.IN_ARREAR && this.usageType == UsageType.CONSUMABLE && this.blocks.length == 0) {
            errors.add((Object)new ValidationError(String.format("Usage [IN_ARREAR CONSUMABLE] section of phase %s needs to define some blocks", this.phase.getName()), DefaultUsage.class, ""));
        }
        this.validateCollection(catalog, errors, this.limits);
        return errors;
    }

    public void initialize(StandaloneCatalog catalog) {
        super.initialize((Object)catalog);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
        for (DefaultLimit defaultLimit : this.limits) {
            defaultLimit.initialize(catalog);
        }
        for (ValidatingConfig validatingConfig : this.blocks) {
            validatingConfig.initialize(catalog);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultTier)) {
            return false;
        }
        DefaultTier that = (DefaultTier)o;
        if (this.billingMode != that.billingMode) {
            return false;
        }
        if (!Arrays.equals(this.blocks, that.blocks)) {
            return false;
        }
        if (this.fixedPrice != null ? !this.fixedPrice.equals(that.fixedPrice) : that.fixedPrice != null) {
            return false;
        }
        if (!Arrays.equals(this.limits, that.limits)) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.recurringPrice != null ? !this.recurringPrice.equals(that.recurringPrice) : that.recurringPrice != null) {
            return false;
        }
        return this.usageType == that.usageType;
    }

    public int hashCode() {
        int result = this.limits != null ? Arrays.hashCode(this.limits) : 0;
        result = 31 * result + (this.blocks != null ? Arrays.hashCode(this.blocks) : 0);
        result = 31 * result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
        result = 31 * result + (this.recurringPrice != null ? this.recurringPrice.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.limits);
        out.writeObject(this.blocks);
        out.writeObject(this.fixedPrice);
        out.writeObject(this.recurringPrice);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.limits = (DefaultLimit[])in.readObject();
        this.blocks = (DefaultTieredBlock[])in.readObject();
        this.fixedPrice = (DefaultInternationalPrice)in.readObject();
        this.recurringPrice = (DefaultInternationalPrice)in.readObject();
    }
}

