/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Arrays;
import java.util.Collection;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlElementWrapper;
import javax.xml.bind.annotation.XmlID;
import javax.xml.bind.annotation.XmlIDREF;
import org.killbill.billing.catalog.CatalogEntityCollection;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultLimit;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Limit;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultProduct
extends ValidatingConfig<StandaloneCatalog>
implements Product,
Externalizable {
    @XmlAttribute(required=true)
    @XmlID
    private String name;
    @XmlAttribute(required=false)
    private String prettyName;
    @XmlElement(required=true)
    private ProductCategory category;
    @XmlElementWrapper(name="included", required=false)
    @XmlIDREF
    @XmlElement(type=DefaultProduct.class, name="addonProduct", required=false)
    private CatalogEntityCollection<Product> included = new CatalogEntityCollection();
    @XmlElementWrapper(name="available", required=false)
    @XmlIDREF
    @XmlElement(type=DefaultProduct.class, name="addonProduct", required=false)
    private CatalogEntityCollection<Product> available = new CatalogEntityCollection();
    @XmlElementWrapper(name="limits", required=false)
    @XmlElement(name="limit", required=false)
    private DefaultLimit[] limits;
    private String catalogName;

    public String getCatalogName() {
        return this.catalogName;
    }

    public ProductCategory getCategory() {
        return this.category;
    }

    public Collection<Product> getIncluded() {
        return this.included.getEntries();
    }

    public Collection<Product> getAvailable() {
        return this.available.getEntries();
    }

    public CatalogEntityCollection<Product> getCatalogEntityCollectionAvailable() {
        return this.available;
    }

    public DefaultProduct() {
        this.limits = new DefaultLimit[0];
    }

    public DefaultProduct(String name, ProductCategory category) {
        this.category = category;
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getPrettyName() {
        return this.prettyName;
    }

    public boolean isIncluded(DefaultProduct addon) {
        for (Product p : this.included.getEntries()) {
            if (addon != p) continue;
            return true;
        }
        return false;
    }

    public boolean isAvailable(DefaultProduct addon) {
        for (Product p : this.included.getEntries()) {
            if (addon != p) continue;
            return true;
        }
        return false;
    }

    public DefaultLimit[] getLimits() {
        return this.limits;
    }

    protected Limit findLimit(String unit) {
        for (DefaultLimit limit : this.limits) {
            if (!limit.getUnit().getName().equals(unit)) continue;
            return limit;
        }
        return null;
    }

    public boolean compliesWithLimits(String unit, double value) {
        Limit l = this.findLimit(unit);
        if (l == null) {
            return true;
        }
        return l.compliesWith(value);
    }

    public void initialize(StandaloneCatalog catalog) {
        super.initialize((Object)catalog);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
        for (DefaultLimit cur : this.limits) {
            cur.initialize(catalog);
        }
        if (this.prettyName == null) {
            this.prettyName = this.name;
        }
        this.catalogName = catalog.getCatalogName();
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.catalogName == null || !this.catalogName.equals(catalog.getCatalogName())) {
            errors.add((Object)new ValidationError(String.format("Invalid catalogName for product '%s'", this.name), DefaultProduct.class, ""));
        }
        return errors;
    }

    public DefaultProduct setName(String name) {
        this.name = name;
        return this;
    }

    public DefaultProduct setPrettyName(String prettyName) {
        this.prettyName = prettyName;
        return this;
    }

    public DefaultProduct setCatagory(ProductCategory category) {
        this.category = category;
        return this;
    }

    public DefaultProduct setCategory(ProductCategory category) {
        this.category = category;
        return this;
    }

    public DefaultProduct setIncluded(Collection<Product> included) {
        this.included = new CatalogEntityCollection<Product>(included);
        return this;
    }

    public DefaultProduct setAvailable(Collection<Product> available) {
        this.available = new CatalogEntityCollection<Product>(available);
        return this;
    }

    public DefaultProduct setCatalogName(String catalogName) {
        this.catalogName = catalogName;
        return this;
    }

    public String toString() {
        return "DefaultProduct{name='" + this.name + '\'' + ", category=" + this.category + ", included=" + this.included + ", available=" + this.available + ", limits=" + Arrays.toString(this.limits) + ", catalogName='" + this.catalogName + '\'' + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultProduct)) {
            return false;
        }
        DefaultProduct product = (DefaultProduct)o;
        if (this.name != null ? !this.name.equals(product.name) : product.name != null) {
            return false;
        }
        if (this.category != product.category) {
            return false;
        }
        if (this.included != null ? !this.included.equals(product.included) : product.included != null) {
            return false;
        }
        if (this.available != null ? !this.available.equals(product.available) : product.available != null) {
            return false;
        }
        if (!Arrays.equals(this.limits, product.limits)) {
            return false;
        }
        return this.catalogName != null ? this.catalogName.equals(product.catalogName) : product.catalogName == null;
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.category != null ? this.category.hashCode() : 0);
        result = 31 * result + (this.included != null ? this.included.hashCode() : 0);
        result = 31 * result + (this.available != null ? this.available.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.limits);
        result = 31 * result + (this.catalogName != null ? this.catalogName.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.catalogName != null);
        if (this.catalogName != null) {
            out.writeUTF(this.catalogName);
        }
        out.writeBoolean(this.name != null);
        if (this.name != null) {
            out.writeUTF(this.name);
        }
        out.writeBoolean(this.prettyName != null);
        if (this.prettyName != null) {
            out.writeUTF(this.prettyName);
        }
        out.writeBoolean(this.category != null);
        if (this.category != null) {
            out.writeUTF(this.category.name());
        }
        out.writeObject(this.included);
        out.writeObject(this.available);
        out.writeObject(this.limits);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.catalogName = in.readBoolean() ? in.readUTF() : null;
        this.name = in.readBoolean() ? in.readUTF() : null;
        this.prettyName = in.readBoolean() ? in.readUTF() : null;
        this.category = in.readBoolean() ? ProductCategory.valueOf((String)in.readUTF()) : null;
        this.included = (CatalogEntityCollection)in.readObject();
        this.available = (CatalogEntityCollection)in.readObject();
        this.limits = (DefaultLimit[])in.readObject();
    }
}

