/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Plan;
import org.killbill.billing.catalog.api.PriceList;
import org.killbill.billing.catalog.api.PriceListSet;
import org.killbill.billing.catalog.api.Product;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultPriceListSet
extends ValidatingConfig<StandaloneCatalog>
implements PriceListSet,
Externalizable {
    @XmlElement(required=true, name="defaultPriceList")
    private DefaultPriceList defaultPricelist;
    @XmlElement(required=false, name="childPriceList")
    private DefaultPriceList[] childPriceLists;

    public DefaultPriceListSet() {
    }

    public DefaultPriceListSet(DefaultPriceList defaultPricelist, DefaultPriceList[] childPriceLists) {
        this.defaultPricelist = defaultPricelist;
        this.childPriceLists = childPriceLists != null ? childPriceLists : new DefaultPriceList[]{};
    }

    public Plan getPlanFrom(Product product, BillingPeriod period, String priceListName) throws CatalogApiException {
        Collection<Plan> plans = null;
        DefaultPriceList pl = this.findPriceListFrom(priceListName);
        if (pl != null) {
            plans = pl.findPlans(product, period);
        }
        if (plans.size() == 0) {
            plans = this.defaultPricelist.findPlans(product, period);
        }
        switch (plans.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return plans.iterator().next();
            }
        }
        throw new CatalogApiException(ErrorCode.CAT_MULTIPLE_MATCHING_PLANS_FOR_PRICELIST, new Object[]{priceListName, product.getName(), period});
    }

    public DefaultPriceList findPriceListFrom(String priceListName) throws CatalogApiException {
        if (priceListName == null) {
            throw new CatalogApiException(ErrorCode.CAT_NULL_PRICE_LIST_NAME, new Object[0]);
        }
        if (this.defaultPricelist.getName().equals(priceListName)) {
            return this.defaultPricelist;
        }
        for (DefaultPriceList pl : this.childPriceLists) {
            if (!pl.getName().equals(priceListName)) continue;
            return pl;
        }
        throw new CatalogApiException(ErrorCode.CAT_PRICE_LIST_NOT_FOUND, new Object[]{priceListName});
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        this.defaultPricelist.validate(catalog, errors);
        for (DefaultPriceList pl : this.childPriceLists) {
            if (pl.getName().equals("DEFAULT")) {
                errors.add((Object)new ValidationError("Pricelists cannot use the reserved name 'DEFAULT'", DefaultPriceListSet.class, pl.getName()));
            }
            pl.validate(catalog, errors);
        }
        return errors;
    }

    public void initialize(StandaloneCatalog catalog) {
        super.initialize((Object)catalog);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
    }

    public DefaultPriceList getDefaultPricelist() {
        return this.defaultPricelist;
    }

    public DefaultPriceList[] getChildPriceLists() {
        return this.childPriceLists;
    }

    public List<PriceList> getAllPriceLists() {
        ArrayList<PriceList> result = new ArrayList<PriceList>(this.childPriceLists.length + 1);
        result.add(this.getDefaultPricelist());
        for (DefaultPriceList list : this.getChildPriceLists()) {
            result.add(list);
        }
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPriceListSet)) {
            return false;
        }
        DefaultPriceListSet that = (DefaultPriceListSet)o;
        if (!Arrays.equals(this.childPriceLists, that.childPriceLists)) {
            return false;
        }
        return !(this.defaultPricelist != null ? !this.defaultPricelist.equals(that.defaultPricelist) : that.defaultPricelist != null);
    }

    public int hashCode() {
        int result = this.defaultPricelist != null ? this.defaultPricelist.hashCode() : 0;
        result = 31 * result + (this.childPriceLists != null ? Arrays.hashCode(this.childPriceLists) : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.defaultPricelist);
        out.writeObject(this.childPriceLists);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.defaultPricelist = (DefaultPriceList)in.readObject();
        this.childPriceLists = (DefaultPriceList[])in.readObject();
    }
}

