/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.Price;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultPrice
extends ValidatingConfig<StandaloneCatalog>
implements Price,
Externalizable {
    @XmlElement(required=true)
    private Currency currency;
    @XmlElement(required=true, nillable=true)
    private BigDecimal value;

    public DefaultPrice() {
    }

    public DefaultPrice(BigDecimal value, Currency currency) {
        this.value = value;
        this.currency = currency;
    }

    public Currency getCurrency() {
        return this.currency;
    }

    public BigDecimal getValue() throws CurrencyValueNull {
        if (this.value == null) {
            throw new CurrencyValueNull(new Object[]{this.currency});
        }
        return this.value;
    }

    public DefaultPrice setCurrency(Currency currency) {
        this.currency = currency;
        return this;
    }

    public DefaultPrice setValue(BigDecimal value) {
        this.value = value;
        return this;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        return errors;
    }

    public void initialize(StandaloneCatalog catalog) {
        super.initialize((Object)catalog);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultPrice)) {
            return false;
        }
        DefaultPrice that = (DefaultPrice)o;
        if (this.currency != that.currency) {
            return false;
        }
        return !(this.value != null ? !this.value.equals(that.value) : that.value != null);
    }

    public int hashCode() {
        int result = this.currency != null ? this.currency.hashCode() : 0;
        result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.currency != null);
        if (this.currency != null) {
            out.writeUTF(this.currency.name());
        }
        out.writeObject(this.value);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.currency = in.readBoolean() ? Currency.valueOf((String)in.readUTF()) : null;
        this.value = (BigDecimal)in.readObject();
    }
}

