/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import java.util.Arrays;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultPrice;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.CurrencyValueNull;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.billing.catalog.api.Price;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultInternationalPrice
extends ValidatingConfig<StandaloneCatalog>
implements InternationalPrice,
Externalizable {
    @XmlElement(name="price", required=false)
    private DefaultPrice[] prices;

    public Price[] getPrices() {
        return this.prices;
    }

    public DefaultInternationalPrice() {
    }

    public DefaultInternationalPrice(DefaultInternationalPrice in, PlanPhasePriceOverride override, boolean fixed) {
        if (in.getPrices().length == 0) {
            this.prices = new DefaultPrice[1];
            this.prices[0] = new DefaultPrice(fixed ? override.getFixedPrice() : override.getRecurringPrice(), override.getCurrency());
        } else {
            this.prices = new DefaultPrice[in.getPrices().length];
            for (int i = 0; i < in.getPrices().length; ++i) {
                DefaultPrice curPrice = (DefaultPrice)in.getPrices()[i];
                this.prices[i] = curPrice.getCurrency().equals((Object)override.getCurrency()) ? new DefaultPrice(fixed ? override.getFixedPrice() : override.getRecurringPrice(), override.getCurrency()) : curPrice;
            }
        }
    }

    public DefaultInternationalPrice(DefaultInternationalPrice in, BigDecimal overriddenPrice, Currency currency) {
        this.prices = in.getPrices() != null ? new DefaultPrice[in.getPrices().length] : null;
        for (int i = 0; i < in.getPrices().length; ++i) {
            DefaultPrice curPrice = (DefaultPrice)in.getPrices()[i];
            this.prices[i] = curPrice.getCurrency().equals((Object)currency) ? new DefaultPrice(overriddenPrice, currency) : curPrice;
        }
    }

    public BigDecimal getPrice(Currency currency) throws CatalogApiException {
        if (this.prices.length == 0) {
            return BigDecimal.ZERO;
        }
        for (DefaultPrice p : this.prices) {
            if (p.getCurrency() != currency) continue;
            return p.getValue();
        }
        throw new CatalogApiException(ErrorCode.CAT_NO_PRICE_FOR_CURRENCY, new Object[]{currency});
    }

    public DefaultInternationalPrice setPrices(DefaultPrice[] prices) {
        this.prices = prices;
        return this;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        Currency[] supportedCurrencies = catalog.getCurrentSupportedCurrencies();
        for (DefaultPrice p : this.prices) {
            Currency currency = p.getCurrency();
            if (!this.currencyIsSupported(currency, supportedCurrencies)) {
                errors.add("Unsupported currency: " + currency, this.getClass(), "");
            }
            try {
                if (!(p.getValue().doubleValue() < 0.0)) continue;
                errors.add("Negative value for price in currency: " + currency, this.getClass(), "");
            }
            catch (CurrencyValueNull currencyValueNull) {
                // empty catch block
            }
        }
        return errors;
    }

    private boolean currencyIsSupported(Currency currency, Currency[] supportedCurrencies) {
        for (Currency c : supportedCurrencies) {
            if (c != currency) continue;
            return true;
        }
        return false;
    }

    public void initialize(StandaloneCatalog root) {
        super.initialize((Object)root);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
    }

    public boolean isZero() {
        for (DefaultPrice price : this.prices) {
            try {
                if (price.getValue().compareTo(BigDecimal.ZERO) == 0) continue;
                return false;
            }
            catch (CurrencyValueNull currencyValueNull) {
                // empty catch block
            }
        }
        return true;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultInternationalPrice)) {
            return false;
        }
        DefaultInternationalPrice that = (DefaultInternationalPrice)o;
        return Arrays.equals(this.prices, that.prices);
    }

    public int hashCode() {
        return this.prices != null ? Arrays.hashCode(this.prices) : 0;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeObject(this.prices);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.prices = (DefaultPrice[])in.readObject();
    }
}

