/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Fixed;
import org.killbill.billing.catalog.api.FixedType;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.PlanPhasePriceOverride;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultFixed
extends ValidatingConfig<StandaloneCatalog>
implements Fixed,
Externalizable {
    @XmlAttribute(required=false)
    private FixedType type;
    @XmlElement(required=false)
    private DefaultInternationalPrice fixedPrice;

    public FixedType getType() {
        return this.type;
    }

    public InternationalPrice getPrice() {
        return this.fixedPrice;
    }

    public DefaultFixed() {
    }

    public DefaultFixed(DefaultFixed in, PlanPhasePriceOverride override) {
        this.type = in.getType();
        this.fixedPrice = in.getPrice() != null ? new DefaultInternationalPrice((DefaultInternationalPrice)in.getPrice(), override, true) : null;
    }

    public void initialize(StandaloneCatalog root) {
        super.initialize((Object)root);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
        if (this.fixedPrice != null) {
            this.fixedPrice.initialize(root);
        }
    }

    public ValidationErrors validate(StandaloneCatalog root, ValidationErrors errors) {
        if (this.type == null) {
            throw new IllegalStateException("fixedPrice should have been automatically been initialized with ONE_TIME ");
        }
        return errors;
    }

    public DefaultFixed setType(FixedType type) {
        this.type = type;
        return this;
    }

    public DefaultFixed setFixedPrice(DefaultInternationalPrice fixedPrice) {
        this.fixedPrice = fixedPrice;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultFixed)) {
            return false;
        }
        DefaultFixed that = (DefaultFixed)o;
        if (this.fixedPrice != null ? !this.fixedPrice.equals(that.fixedPrice) : that.fixedPrice != null) {
            return false;
        }
        return this.type == that.type;
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.fixedPrice != null ? this.fixedPrice.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.type != null);
        if (this.type != null) {
            out.writeUTF(this.type.name());
        }
        out.writeObject(this.fixedPrice);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readBoolean() ? FixedType.valueOf((String)in.readUTF()) : null;
        this.fixedPrice = (DefaultInternationalPrice)in.readObject();
    }
}

