/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import com.google.inject.Inject;
import javax.inject.Named;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.DefaultVersionedCatalog;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.CatalogService;
import org.killbill.billing.catalog.caching.CatalogCache;
import org.killbill.billing.platform.api.KillbillService;
import org.killbill.billing.platform.api.LifecycleHandlerType;
import org.killbill.billing.tenant.api.TenantInternalApi;
import org.killbill.billing.tenant.api.TenantKV;
import org.killbill.billing.util.config.definition.CatalogConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCatalogService
implements KillbillService,
CatalogService {
    private static final Logger log = LoggerFactory.getLogger(DefaultCatalogService.class);
    private final CatalogConfig config;
    private final TenantInternalApi tenantInternalApi;
    private final CatalogCache catalogCache;
    private final TenantInternalApi.CacheInvalidationCallback cacheInvalidationCallback;
    private boolean isInitialized;

    @Inject
    public DefaultCatalogService(CatalogConfig config, TenantInternalApi tenantInternalApi, CatalogCache catalogCache, @Named(value="CatalogInvalidationCallback") TenantInternalApi.CacheInvalidationCallback cacheInvalidationCallback) {
        this.config = config;
        this.catalogCache = catalogCache;
        this.cacheInvalidationCallback = cacheInvalidationCallback;
        this.tenantInternalApi = tenantInternalApi;
        this.isInitialized = false;
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.LOAD_CATALOG)
    public synchronized void loadCatalog() throws KillbillService.ServiceException {
        if (!this.isInitialized) {
            try {
                if (this.config.getCatalogURI() != null && !this.config.getCatalogURI().isEmpty()) {
                    this.catalogCache.loadDefaultCatalog(this.config.getCatalogURI());
                    log.info("Successfully loaded the default catalog {}", (Object)this.config.getCatalogURI());
                }
                this.isInitialized = true;
            }
            catch (Exception e) {
                throw new KillbillService.ServiceException((Throwable)e);
            }
        }
    }

    @LifecycleHandlerType(value=LifecycleHandlerType.LifecycleLevel.INIT_SERVICE)
    public synchronized void initialize() throws KillbillService.ServiceException {
        this.tenantInternalApi.initializeCacheInvalidationCallback(TenantKV.TenantKey.CATALOG, this.cacheInvalidationCallback);
    }

    public String getName() {
        return KillbillService.KILLBILL_SERVICES.CATALOG_SERVICE.getServiceName();
    }

    public int getRegistrationOrdering() {
        return KillbillService.KILLBILL_SERVICES.CATALOG_SERVICE.getRegistrationOrdering();
    }

    @Override
    public DefaultVersionedCatalog getFullCatalog(boolean useDefaultCatalog, boolean filterTemplateCatalog, InternalTenantContext context) throws CatalogApiException {
        return this.getCatalog(useDefaultCatalog, filterTemplateCatalog, false, context);
    }

    @Override
    public DefaultVersionedCatalog getFullCatalogForInternalUse(boolean useDefaultCatalog, boolean filterTemplateCatalog, InternalTenantContext context) throws CatalogApiException {
        return this.getCatalog(useDefaultCatalog, filterTemplateCatalog, true, context);
    }

    private DefaultVersionedCatalog getCatalog(boolean useDefaultCatalog, boolean filterTemplateCatalog, boolean internalUse, InternalTenantContext context) throws CatalogApiException {
        return this.catalogCache.getCatalog(useDefaultCatalog, filterTemplateCatalog, internalUse, context);
    }
}

