/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.math.BigDecimal;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlIDREF;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogSafetyInitializer;
import org.killbill.billing.catalog.DefaultInternationalPrice;
import org.killbill.billing.catalog.DefaultUnit;
import org.killbill.billing.catalog.DefaultUsage;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.Block;
import org.killbill.billing.catalog.api.BlockType;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.Currency;
import org.killbill.billing.catalog.api.InternationalPrice;
import org.killbill.billing.catalog.api.PlanPhase;
import org.killbill.billing.catalog.api.Unit;
import org.killbill.xmlloader.ValidatingConfig;
import org.killbill.xmlloader.ValidationError;
import org.killbill.xmlloader.ValidationErrors;

@XmlAccessorType(value=XmlAccessType.NONE)
public class DefaultBlock
extends ValidatingConfig<StandaloneCatalog>
implements Block,
Externalizable {
    @XmlAttribute(required=false)
    private BlockType type = BlockType.VANILLA;
    @XmlElement(required=true)
    @XmlIDREF
    private DefaultUnit unit;
    @XmlElement(required=true)
    private Double size;
    @XmlElement(required=true)
    private DefaultInternationalPrice prices;
    @XmlElement(required=false)
    private Double minTopUpCredit;
    private PlanPhase phase;

    public BlockType getType() {
        return this.type;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public Double getSize() {
        return this.size;
    }

    public InternationalPrice getPrice() {
        return this.prices;
    }

    public Double getMinTopUpCredit() throws CatalogApiException {
        if (!CatalogSafetyInitializer.DEFAULT_NON_REQUIRED_DOUBLE_FIELD_VALUE.equals(this.minTopUpCredit) && this.type != BlockType.TOP_UP) {
            throw new CatalogApiException(ErrorCode.CAT_NOT_TOP_UP_BLOCK, new Object[]{this.phase.getName()});
        }
        return this.minTopUpCredit;
    }

    public ValidationErrors validate(StandaloneCatalog catalog, ValidationErrors errors) {
        if (this.type == null) {
            throw new IllegalStateException("type should have been automatically been initialized with VANILLA ");
        }
        if (this.type == BlockType.TOP_UP && CatalogSafetyInitializer.DEFAULT_NON_REQUIRED_DOUBLE_FIELD_VALUE.equals(this.minTopUpCredit)) {
            errors.add((Object)new ValidationError(String.format("TOP_UP block needs to define minTopUpCredit for phase %s", this.phase.getName()), DefaultUsage.class, ""));
        }
        return errors;
    }

    public DefaultBlock() {
    }

    public DefaultBlock(DefaultUnit unit, Double size, DefaultInternationalPrice prices, BigDecimal overriddenPrice, Currency currency) {
        this.unit = unit;
        this.size = size;
        this.prices = prices != null ? new DefaultInternationalPrice(prices, overriddenPrice, currency) : null;
    }

    public void initialize(StandaloneCatalog catalog) {
        super.initialize((Object)catalog);
        CatalogSafetyInitializer.initializeNonRequiredNullFieldsWithDefaultValue(this);
    }

    public DefaultBlock setType(BlockType type) {
        this.type = type;
        return this;
    }

    public DefaultBlock setPrices(DefaultInternationalPrice prices) {
        this.prices = prices;
        return this;
    }

    public DefaultBlock setUnit(DefaultUnit unit) {
        this.unit = unit;
        return this;
    }

    public DefaultBlock setSize(Double size) {
        this.size = size;
        return this;
    }

    public DefaultBlock setPrice(DefaultInternationalPrice prices) {
        this.prices = prices;
        return this;
    }

    public DefaultBlock setPhase(PlanPhase phase) {
        this.phase = phase;
        return this;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof DefaultBlock)) {
            return false;
        }
        DefaultBlock that = (DefaultBlock)o;
        if (this.minTopUpCredit != null ? !this.minTopUpCredit.equals(that.minTopUpCredit) : that.minTopUpCredit != null) {
            return false;
        }
        if (this.phase != null ? !this.phase.equals(that.phase) : that.phase != null) {
            return false;
        }
        if (this.prices != null ? !this.prices.equals(that.prices) : that.prices != null) {
            return false;
        }
        if (this.size != null ? !this.size.equals(that.size) : that.size != null) {
            return false;
        }
        if (this.type != that.type) {
            return false;
        }
        return !(this.unit != null ? !this.unit.equals(that.unit) : that.unit != null);
    }

    public int hashCode() {
        int result = this.type != null ? this.type.hashCode() : 0;
        result = 31 * result + (this.unit != null ? this.unit.hashCode() : 0);
        result = 31 * result + (this.size != null ? this.size.hashCode() : 0);
        result = 31 * result + (this.prices != null ? this.prices.hashCode() : 0);
        result = 31 * result + (this.minTopUpCredit != null ? this.minTopUpCredit.hashCode() : 0);
        return result;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.type != null);
        if (this.type != null) {
            out.writeUTF(this.type.name());
        }
        out.writeObject(this.unit);
        out.writeBoolean(this.size != null);
        if (this.size != null) {
            out.writeDouble(this.size);
        }
        out.writeObject(this.prices);
        out.writeBoolean(this.minTopUpCredit != null);
        if (this.minTopUpCredit != null) {
            out.writeDouble(this.minTopUpCredit);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.type = in.readBoolean() ? BlockType.valueOf((String)in.readUTF()) : null;
        this.unit = (DefaultUnit)in.readObject();
        this.size = in.readBoolean() ? Double.valueOf(in.readDouble()) : null;
        this.prices = (DefaultInternationalPrice)in.readObject();
        this.minTopUpCredit = in.readBoolean() ? Double.valueOf(in.readDouble()) : null;
    }
}

