/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.rules;

import javax.xml.bind.annotation.XmlElement;
import org.killbill.billing.ErrorCode;
import org.killbill.billing.catalog.CatalogTestSuiteNoDB;
import org.killbill.billing.catalog.DefaultPriceList;
import org.killbill.billing.catalog.DefaultProduct;
import org.killbill.billing.catalog.MockCatalog;
import org.killbill.billing.catalog.StandaloneCatalog;
import org.killbill.billing.catalog.api.BillingPeriod;
import org.killbill.billing.catalog.api.CatalogApiException;
import org.killbill.billing.catalog.api.PhaseType;
import org.killbill.billing.catalog.api.PlanPhaseSpecifier;
import org.killbill.billing.catalog.api.PlanSpecifier;
import org.killbill.billing.catalog.api.Product;
import org.killbill.billing.catalog.api.ProductCategory;
import org.killbill.billing.catalog.api.StaticCatalog;
import org.killbill.billing.catalog.rules.DefaultCaseChange;
import org.killbill.billing.catalog.rules.Result;
import org.testng.Assert;
import org.testng.annotations.Test;

public class TestCaseChange
extends CatalogTestSuiteNoDB {
    @Test(groups={"fast"})
    public void testBasic() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1, priceList2, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), cat.getCurrentProduct(1).getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.ANNUAL, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, cat.getCurrentProduct(1).getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), cat.getCurrentProduct(1).getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildcardFromProduct() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr = new DefaultCaseChangeResult(null, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1, priceList2, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, cat.getCurrentProduct(1).getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), cat.getCurrentProduct(1).getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.ANNUAL, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, cat.getCurrentProduct(1).getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), cat.getCurrentProduct(1).getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildcardToProduct() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr = new DefaultCaseChangeResult(product1, null, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1, priceList2, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product1.getName(), cat.getCurrentProduct(1).getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.ANNUAL, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, cat.getCurrentProduct(1).getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), cat.getCurrentProduct(1).getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildcardFromProductCategory() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr = new DefaultCaseChangeResult(product1, product2, null, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1, priceList2, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), cat.getCurrentProduct(1).getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.ANNUAL, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, cat.getCurrentProduct(1).getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), cat.getCurrentProduct(1).getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildcardToProductCategory() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, null, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1, priceList2, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), cat.getCurrentProduct(1).getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.ANNUAL, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, cat.getCurrentProduct(1).getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), cat.getCurrentProduct(1).getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildcardFromBillingPeriod() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, null, BillingPeriod.MONTHLY, priceList1, priceList2, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), cat.getCurrentProduct(1).getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.ANNUAL, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, cat.getCurrentProduct(1).getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), cat.getCurrentProduct(1).getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildCardToBillingPeriod() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, null, priceList1, priceList2, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), cat.getCurrentProduct(1).getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.ANNUAL, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, cat.getCurrentProduct(1).getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), cat.getCurrentProduct(1).getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildCardFromPriceList() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, null, priceList2, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), cat.getCurrentProduct(1).getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.ANNUAL, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), cat.getCurrentProduct(1).getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildcardToPriceList() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1, null, PhaseType.EVERGREEN, Result.FOO);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), cat.getCurrentProduct(1).getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.ANNUAL, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, cat.getCurrentProduct(1).getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testWildcardPlanPhase() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1, priceList2, null, Result.FOO);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, cat.getCurrentProduct(1).getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), cat.getCurrentProduct(1).getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.ANNUAL, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionNull(cr, product1.getName(), product2.getName(), ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1.getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, cat.getCurrentProduct(1).getName(), priceList2.getName(), PhaseType.EVERGREEN, cat);
        this.assertionException(cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), cat.getCurrentProduct(1).getName(), PhaseType.EVERGREEN, cat);
        this.assertion(Result.FOO, cr, product1.getName(), product2.getName(), BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1.getName(), priceList2.getName(), PhaseType.TRIAL, cat);
    }

    @Test(groups={"fast"})
    public void testOrder() throws CatalogApiException {
        MockCatalog cat = new MockCatalog();
        DefaultProduct product1 = cat.getCurrentProduct(0);
        DefaultPriceList priceList1 = cat.findCurrentPriceList("DEFAULT");
        DefaultProduct product2 = cat.getCurrentProduct(2);
        DefaultPriceList priceList2 = cat.getPriceLists().getChildPriceLists()[1];
        DefaultCaseChangeResult cr0 = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1, priceList2, PhaseType.EVERGREEN, Result.FOO);
        DefaultCaseChangeResult cr1 = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1, priceList2, PhaseType.EVERGREEN, Result.BAR);
        DefaultCaseChangeResult cr2 = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.MONTHLY, priceList1, priceList2, PhaseType.EVERGREEN, Result.TINKYWINKY);
        DefaultCaseChangeResult cr3 = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1, priceList2, PhaseType.EVERGREEN, Result.DIPSY);
        DefaultCaseChangeResult cr4 = new DefaultCaseChangeResult(product1, product2, ProductCategory.BASE, ProductCategory.BASE, BillingPeriod.MONTHLY, BillingPeriod.ANNUAL, priceList1, priceList2, PhaseType.EVERGREEN, Result.LALA);
        Result r1 = (Result)((Object)DefaultCaseChange.getResult((DefaultCaseChange[])new DefaultCaseChangeResult[]{cr0, cr1, cr2, cr3, cr4}, (PlanPhaseSpecifier)new PlanPhaseSpecifier(product1.getName(), BillingPeriod.MONTHLY, priceList1.getName(), PhaseType.EVERGREEN), (PlanSpecifier)new PlanSpecifier(product2.getName(), BillingPeriod.MONTHLY, priceList2.getName()), (StaticCatalog)cat));
        Assert.assertEquals((Object)((Object)r1), (Object)((Object)Result.FOO));
        Result r2 = (Result)((Object)DefaultCaseChange.getResult((DefaultCaseChange[])new DefaultCaseChangeResult[]{cr0, cr1, cr2, cr3, cr4}, (PlanPhaseSpecifier)new PlanPhaseSpecifier(product1.getName(), BillingPeriod.MONTHLY, priceList1.getName(), PhaseType.EVERGREEN), (PlanSpecifier)new PlanSpecifier(product2.getName(), BillingPeriod.ANNUAL, priceList2.getName()), (StaticCatalog)cat));
        Assert.assertEquals((Object)((Object)r2), (Object)((Object)Result.DIPSY));
    }

    protected void assertionNull(DefaultCaseChangeResult cr, String fromProductName, String toProductName, ProductCategory fromProductCategory, ProductCategory toProductCategory, BillingPeriod fromBp, BillingPeriod toBp, String fromPriceListName, String toPriceListName, PhaseType phaseType, StandaloneCatalog cat) {
        try {
            Assert.assertNull((Object)cr.getResult(new PlanPhaseSpecifier(fromProductName, fromBp, fromPriceListName, phaseType), new PlanSpecifier(toProductName, toBp, toPriceListName), (StaticCatalog)cat));
        }
        catch (CatalogApiException e) {
            Assert.fail((String)"", (Throwable)e);
        }
    }

    protected void assertionException(DefaultCaseChangeResult cr, String fromProductName, String toProductName, BillingPeriod fromBp, BillingPeriod toBp, String fromPriceListName, String toPriceListName, PhaseType phaseType, StandaloneCatalog cat) {
        try {
            cr.getResult(new PlanPhaseSpecifier(fromProductName, fromBp, fromPriceListName, phaseType), new PlanSpecifier(toProductName, toBp, toPriceListName), (StaticCatalog)cat);
            Assert.fail((String)"Expecting an exception");
        }
        catch (CatalogApiException e) {
            Assert.assertEquals((int)e.getCode(), (int)ErrorCode.CAT_PRICE_LIST_NOT_FOUND.getCode());
        }
    }

    protected void assertion(Result result, DefaultCaseChangeResult cr, String fromProductName, String toProductName, BillingPeriod fromBp, BillingPeriod toBp, String fromPriceListName, String toPriceListName, PhaseType phaseType, StandaloneCatalog cat) {
        try {
            Assert.assertEquals((Object)((Object)result), (Object)cr.getResult(new PlanPhaseSpecifier(fromProductName, fromBp, fromPriceListName, phaseType), new PlanSpecifier(toProductName, toBp, toPriceListName), (StaticCatalog)cat));
        }
        catch (CatalogApiException e) {
            Assert.fail((String)"", (Throwable)e);
        }
    }

    protected static class DefaultCaseChangeResult
    extends DefaultCaseChange<Result> {
        @XmlElement(required=true)
        private final Result result;

        public DefaultCaseChangeResult(DefaultProduct from, DefaultProduct to, ProductCategory fromProductCategory, ProductCategory toProductCategory, BillingPeriod fromBP, BillingPeriod toBP, DefaultPriceList fromPriceList, DefaultPriceList toPriceList, PhaseType fromType, Result result) {
            this.setFromProduct((Product)from);
            this.setToProduct((Product)to);
            this.setFromProductCategory(fromProductCategory);
            this.setToProductCategory(toProductCategory);
            this.setFromPriceList(fromPriceList);
            this.setToPriceList(toPriceList);
            this.setFromBillingPeriod(fromBP);
            this.setToBillingPeriod(toBP);
            this.setPhaseType(fromType);
            this.result = result;
        }

        protected Result getResult() {
            return this.result;
        }
    }
}

