/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import java.util.ArrayList;
import java.util.List;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.dao.CatalogOverrideUsageTierModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideUsageTierSqlDao;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCatalogOverrideUsageTierSqlDao
extends CatalogTestSuiteWithEmbeddedDB {
    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeClass();
        ((DBI)this.dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverrideUsageTierModelDao.class));
    }

    @Test(groups={"slow"})
    public void testBasic() throws Exception {
        final CatalogOverrideUsageTierModelDao obj1 = new CatalogOverrideUsageTierModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(3L));
        this.performTestInTransaction(new WithCatalogOverrideUsageTierSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverrideUsageTierSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverrideUsageTierSqlDao.this.internalCallContext);
                Long lastInserted = sqlDao.getLastInsertId();
                CatalogOverrideUsageTierModelDao rehydrated = sqlDao.getByRecordId(lastInserted, (InternalTenantContext)TestCatalogOverrideUsageTierSqlDao.this.internalCallContext);
                Assert.assertEquals((Object)rehydrated.getTierNumber(), (Object)obj1.getTierNumber());
                Assert.assertEquals((Object)rehydrated.getTierDefRecordId(), (Object)obj1.getTierDefRecordId());
                Assert.assertEquals((Object)rehydrated.getTargetUsageDefRecordId(), (Object)obj1.getTargetUsageDefRecordId());
                return null;
            }
        });
    }

    @Test(groups={"slow"})
    public void testGetTargetUsageDefinition() throws Exception {
        final CatalogOverrideUsageTierModelDao obj1 = new CatalogOverrideUsageTierModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(3L));
        final CatalogOverrideUsageTierModelDao obj2 = new CatalogOverrideUsageTierModelDao(Short.valueOf((short)2), Long.valueOf(5L), Long.valueOf(3L));
        final CatalogOverrideUsageTierModelDao obj3 = new CatalogOverrideUsageTierModelDao(Short.valueOf((short)4), Long.valueOf(7L), Long.valueOf(3L));
        final CatalogOverrideUsageTierModelDao nobj1 = new CatalogOverrideUsageTierModelDao(Short.valueOf((short)4), Long.valueOf(7L), Long.valueOf(4L));
        this.performTestInTransaction(new WithCatalogOverrideUsageTierSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverrideUsageTierSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverrideUsageTierSqlDao.this.internalCallContext);
                sqlDao.create(obj2, (InternalCallContext)TestCatalogOverrideUsageTierSqlDao.this.internalCallContext);
                sqlDao.create(obj3, (InternalCallContext)TestCatalogOverrideUsageTierSqlDao.this.internalCallContext);
                sqlDao.create(nobj1, (InternalCallContext)TestCatalogOverrideUsageTierSqlDao.this.internalCallContext);
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("1,2");
                keys.add("2,5");
                keys.add("4,7");
                List targetUsages = sqlDao.getTargetUsageDefinition(keys, Integer.valueOf(keys.size()), (InternalTenantContext)TestCatalogOverrideUsageTierSqlDao.this.internalCallContext);
                Assert.assertEquals((int)targetUsages.size(), (int)1);
                Assert.assertEquals(targetUsages.get(0), (Object)new Long(3L));
                return null;
            }
        });
    }

    @Test(groups={"slow"})
    public void testGetTargetUsageDefWithSameTierOverrideAndDifferentUsagePriceOverride() throws Exception {
        final CatalogOverrideUsageTierModelDao obj1 = new CatalogOverrideUsageTierModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(3L));
        final CatalogOverrideUsageTierModelDao obj2 = new CatalogOverrideUsageTierModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(4L));
        this.performTestInTransaction(new WithCatalogOverrideUsageTierSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverrideUsageTierSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverrideUsageTierSqlDao.this.internalCallContext);
                sqlDao.create(obj2, (InternalCallContext)TestCatalogOverrideUsageTierSqlDao.this.internalCallContext);
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("1,2");
                List targetUsages = sqlDao.getTargetUsageDefinition(keys, Integer.valueOf(keys.size()), (InternalTenantContext)TestCatalogOverrideUsageTierSqlDao.this.internalCallContext);
                Assert.assertEquals((int)targetUsages.size(), (int)2);
                Assert.assertEquals(targetUsages.get(0), (Object)new Long(3L));
                Assert.assertEquals(targetUsages.get(1), (Object)new Long(4L));
                return null;
            }
        });
    }

    private <T> T performTestInTransaction(final WithCatalogOverrideUsageTierSqlDaoTransaction<T> callback) {
        return (T)this.dbi.inTransaction(new TransactionCallback<T>(){

            public T inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverrideUsageTierSqlDao sqlDao = (CatalogOverrideUsageTierSqlDao)handle.attach(CatalogOverrideUsageTierSqlDao.class);
                return callback.doTransaction(sqlDao);
            }
        });
    }

    private static interface WithCatalogOverrideUsageTierSqlDaoTransaction<T> {
        public <T> T doTransaction(CatalogOverrideUsageTierSqlDao var1);
    }
}

