/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.dao.CatalogOverrideUsageDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideUsageDefinitionSqlDao;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCatalogOverrideUsageDefinitionSqlDao
extends CatalogTestSuiteWithEmbeddedDB {
    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeClass();
        ((DBI)this.dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverrideUsageDefinitionModelDao.class));
    }

    @Test(groups={"slow"})
    public void testBasic() throws Exception {
        final CatalogOverrideUsageDefinitionModelDao obj1 = new CatalogOverrideUsageDefinitionModelDao("u1", "CONSUMABLE", "USD", BigDecimal.ONE, null, this.clock.getUTCNow());
        this.performTestInTransaction(new WithCatalogOverrideUsageDefinitionSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverrideUsageDefinitionSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverrideUsageDefinitionSqlDao.this.internalCallContext);
                Long lastInserted = sqlDao.getLastInsertId();
                CatalogOverrideUsageDefinitionModelDao rehydrated = sqlDao.getByRecordId(lastInserted, (InternalTenantContext)TestCatalogOverrideUsageDefinitionSqlDao.this.internalCallContext);
                Assert.assertEquals((String)rehydrated.getParentUsageName(), (String)obj1.getParentUsageName());
                Assert.assertEquals((String)rehydrated.getType(), (String)obj1.getType());
                Assert.assertEquals((String)rehydrated.getCurrency(), (String)obj1.getCurrency());
                Assert.assertEquals((int)rehydrated.getFixedPrice().compareTo(obj1.getFixedPrice()), (int)0);
                return null;
            }
        });
    }

    @Test(groups={"slow"})
    public void testGetByAttributes() throws Exception {
        final CatalogOverrideUsageDefinitionModelDao sameUsageWithDiffBlockPrice1 = new CatalogOverrideUsageDefinitionModelDao("u1", "CONSUMABLE", "USD", null, null, this.clock.getUTCNow());
        final CatalogOverrideUsageDefinitionModelDao sameUsageWithDiffBlockPrice2 = new CatalogOverrideUsageDefinitionModelDao("u1", "CONSUMABLE", "USD", null, null, this.clock.getUTCNow());
        final CatalogOverrideUsageDefinitionModelDao sameUsageWithDiffBlockPrice3 = new CatalogOverrideUsageDefinitionModelDao("u2", "CONSUMABLE", "USD", null, null, this.clock.getUTCNow());
        this.performTestInTransaction(new WithCatalogOverrideUsageDefinitionSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverrideUsageDefinitionSqlDao sqlDao) {
                sqlDao.create(sameUsageWithDiffBlockPrice1, (InternalCallContext)TestCatalogOverrideUsageDefinitionSqlDao.this.internalCallContext);
                sqlDao.create(sameUsageWithDiffBlockPrice2, (InternalCallContext)TestCatalogOverrideUsageDefinitionSqlDao.this.internalCallContext);
                sqlDao.create(sameUsageWithDiffBlockPrice3, (InternalCallContext)TestCatalogOverrideUsageDefinitionSqlDao.this.internalCallContext);
                ArrayList<CatalogOverrideUsageDefinitionModelDao> objList = new ArrayList<CatalogOverrideUsageDefinitionModelDao>();
                objList.add(sameUsageWithDiffBlockPrice1);
                objList.add(sameUsageWithDiffBlockPrice2);
                this.checkRehydrated(objList, sqlDao);
                return null;
            }

            private void checkRehydrated(List<CatalogOverrideUsageDefinitionModelDao> objList, CatalogOverrideUsageDefinitionSqlDao sqlDao) {
                List rehydrated = sqlDao.getByAttributes("u1", (InternalTenantContext)TestCatalogOverrideUsageDefinitionSqlDao.this.internalCallContext);
                Assert.assertEquals((int)rehydrated.size(), (int)2);
                Assert.assertEquals((String)((CatalogOverrideUsageDefinitionModelDao)rehydrated.get(0)).getParentUsageName(), (String)objList.get(0).getParentUsageName());
                Assert.assertEquals((String)((CatalogOverrideUsageDefinitionModelDao)rehydrated.get(0)).getType(), (String)objList.get(0).getType());
                Assert.assertEquals((String)((CatalogOverrideUsageDefinitionModelDao)rehydrated.get(0)).getCurrency(), (String)objList.get(0).getCurrency());
                Assert.assertEquals((String)((CatalogOverrideUsageDefinitionModelDao)rehydrated.get(1)).getParentUsageName(), (String)objList.get(1).getParentUsageName());
                Assert.assertEquals((String)((CatalogOverrideUsageDefinitionModelDao)rehydrated.get(1)).getType(), (String)objList.get(1).getType());
                Assert.assertEquals((String)((CatalogOverrideUsageDefinitionModelDao)rehydrated.get(1)).getCurrency(), (String)objList.get(1).getCurrency());
            }
        });
    }

    private <T> T performTestInTransaction(final WithCatalogOverrideUsageDefinitionSqlDaoTransaction<T> callback) {
        return (T)this.dbi.inTransaction(new TransactionCallback<T>(){

            public T inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverrideUsageDefinitionSqlDao sqlDao = (CatalogOverrideUsageDefinitionSqlDao)handle.attach(CatalogOverrideUsageDefinitionSqlDao.class);
                return callback.doTransaction(sqlDao);
            }
        });
    }

    private static interface WithCatalogOverrideUsageDefinitionSqlDaoTransaction<T> {
        public <T> T doTransaction(CatalogOverrideUsageDefinitionSqlDao var1);
    }
}

