/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import java.math.BigDecimal;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.dao.CatalogOverrideTierDefinitionModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideTierDefinitionSqlDao;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCatalogOverrideTierDefinitionSqlDao
extends CatalogTestSuiteWithEmbeddedDB {
    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeClass();
        ((DBI)this.dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverrideTierDefinitionModelDao.class));
    }

    @Test(groups={"slow"})
    public void testBasic() throws Exception {
        final CatalogOverrideTierDefinitionModelDao obj1 = new CatalogOverrideTierDefinitionModelDao("USD", BigDecimal.ONE, null, this.clock.getUTCNow());
        this.performTestInTransaction(new WithCatalogOverrideTierDefinitionSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverrideTierDefinitionSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverrideTierDefinitionSqlDao.this.internalCallContext);
                Long lastInserted = sqlDao.getLastInsertId();
                CatalogOverrideTierDefinitionModelDao rehydrated = sqlDao.getByRecordId(lastInserted, (InternalTenantContext)TestCatalogOverrideTierDefinitionSqlDao.this.internalCallContext);
                Assert.assertEquals((int)rehydrated.getFixedPrice().compareTo(obj1.getFixedPrice()), (int)0);
                Assert.assertEquals((String)rehydrated.getCurrency(), (String)obj1.getCurrency());
                return null;
            }
        });
    }

    private <T> T performTestInTransaction(final WithCatalogOverrideTierDefinitionSqlDaoTransaction<T> callback) {
        return (T)this.dbi.inTransaction(new TransactionCallback<T>(){

            public T inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverrideTierDefinitionSqlDao sqlDao = (CatalogOverrideTierDefinitionSqlDao)handle.attach(CatalogOverrideTierDefinitionSqlDao.class);
                return callback.doTransaction(sqlDao);
            }
        });
    }

    private static interface WithCatalogOverrideTierDefinitionSqlDaoTransaction<T> {
        public <T> T doTransaction(CatalogOverrideTierDefinitionSqlDao var1);
    }
}

