/*
 * Decompiled with CFR 0.152.
 */
package org.killbill.billing.catalog.dao;

import java.util.ArrayList;
import org.killbill.billing.callcontext.InternalCallContext;
import org.killbill.billing.callcontext.InternalTenantContext;
import org.killbill.billing.catalog.CatalogTestSuiteWithEmbeddedDB;
import org.killbill.billing.catalog.dao.CatalogOverrideTierBlockModelDao;
import org.killbill.billing.catalog.dao.CatalogOverrideTierBlockSqlDao;
import org.killbill.commons.jdbi.mapper.LowerToCamelBeanMapperFactory;
import org.skife.jdbi.v2.DBI;
import org.skife.jdbi.v2.Handle;
import org.skife.jdbi.v2.ResultSetMapperFactory;
import org.skife.jdbi.v2.TransactionCallback;
import org.skife.jdbi.v2.TransactionStatus;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class TestCatalogOverrideTierBlockSqlDao
extends CatalogTestSuiteWithEmbeddedDB {
    @Override
    @BeforeClass(groups={"slow"})
    public void beforeClass() throws Exception {
        if (this.hasFailed()) {
            return;
        }
        super.beforeClass();
        ((DBI)this.dbi).registerMapper((ResultSetMapperFactory)new LowerToCamelBeanMapperFactory(CatalogOverrideTierBlockModelDao.class));
    }

    @Test(groups={"slow"})
    public void testBasic() throws Exception {
        final CatalogOverrideTierBlockModelDao obj1 = new CatalogOverrideTierBlockModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(3L));
        this.performTestInTransaction(new WithCatalogOverrideTierBlockSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverrideTierBlockSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverrideTierBlockSqlDao.this.internalCallContext);
                Long lastInserted = sqlDao.getLastInsertId();
                CatalogOverrideTierBlockModelDao rehydrated = sqlDao.getByRecordId(lastInserted, (InternalTenantContext)TestCatalogOverrideTierBlockSqlDao.this.internalCallContext);
                Assert.assertEquals((Object)rehydrated.getBlockNumber(), (Object)obj1.getBlockNumber());
                Assert.assertEquals((Object)rehydrated.getBlockDefRecordId(), (Object)obj1.getBlockDefRecordId());
                Assert.assertEquals((Object)rehydrated.getTargetTierDefRecordId(), (Object)obj1.getTargetTierDefRecordId());
                return null;
            }
        });
    }

    @Test(groups={"slow"})
    public void testGetTargetTierDefinition() throws Exception {
        final CatalogOverrideTierBlockModelDao obj1 = new CatalogOverrideTierBlockModelDao(Short.valueOf((short)1), Long.valueOf(2L), Long.valueOf(3L));
        final CatalogOverrideTierBlockModelDao obj2 = new CatalogOverrideTierBlockModelDao(Short.valueOf((short)2), Long.valueOf(5L), Long.valueOf(3L));
        final CatalogOverrideTierBlockModelDao obj3 = new CatalogOverrideTierBlockModelDao(Short.valueOf((short)4), Long.valueOf(7L), Long.valueOf(3L));
        final CatalogOverrideTierBlockModelDao nobj1 = new CatalogOverrideTierBlockModelDao(Short.valueOf((short)4), Long.valueOf(7L), Long.valueOf(4L));
        this.performTestInTransaction(new WithCatalogOverrideTierBlockSqlDaoTransaction<Void>(){

            @Override
            public Void doTransaction(CatalogOverrideTierBlockSqlDao sqlDao) {
                sqlDao.create(obj1, (InternalCallContext)TestCatalogOverrideTierBlockSqlDao.this.internalCallContext);
                sqlDao.create(obj2, (InternalCallContext)TestCatalogOverrideTierBlockSqlDao.this.internalCallContext);
                sqlDao.create(obj3, (InternalCallContext)TestCatalogOverrideTierBlockSqlDao.this.internalCallContext);
                sqlDao.create(nobj1, (InternalCallContext)TestCatalogOverrideTierBlockSqlDao.this.internalCallContext);
                ArrayList<String> keys = new ArrayList<String>();
                keys.add("1,2");
                keys.add("2,5");
                keys.add("4,7");
                Long targetTier = sqlDao.getTargetTierDefinition(keys, Integer.valueOf(keys.size()), (InternalTenantContext)TestCatalogOverrideTierBlockSqlDao.this.internalCallContext);
                Assert.assertEquals((Object)targetTier, (Object)new Long(3L));
                return null;
            }
        });
    }

    private <T> T performTestInTransaction(final WithCatalogOverrideTierBlockSqlDaoTransaction<T> callback) {
        return (T)this.dbi.inTransaction(new TransactionCallback<T>(){

            public T inTransaction(Handle handle, TransactionStatus status) throws Exception {
                CatalogOverrideTierBlockSqlDao sqlDao = (CatalogOverrideTierBlockSqlDao)handle.attach(CatalogOverrideTierBlockSqlDao.class);
                return callback.doTransaction(sqlDao);
            }
        });
    }

    private static interface WithCatalogOverrideTierBlockSqlDaoTransaction<T> {
        public <T> T doTransaction(CatalogOverrideTierBlockSqlDao var1);
    }
}

